/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.Transform;
import com.neuronrobotics.bowlerstudio.physics.CSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.PhysicsCore;
import com.neuronrobotics.bowlerstudio.physics.TransformFactory;
import com.neuronrobotics.sdk.addons.kinematics.math.TransformNR;
import com.neuronrobotics.sdk.common.IClosedLoopController;
import eu.mihosoft.vrl.v3d.CSG;
import java.util.ArrayList;

public class WheelCSGPhysicsManager
extends CSGPhysicsManager {
    private IClosedLoopController controller = null;
    private double target = 0.0;
    private static float muscleStrength = 1000.0f;
    boolean flagBroken = false;
    private double velocity;
    private RaycastVehicle vehicle;
    private final int wheelIndex;

    public WheelCSGPhysicsManager(ArrayList<CSG> baseCSG, Transform pose, double mass, PhysicsCore c, RaycastVehicle v, int wheelIndex) {
        super(baseCSG, pose, mass, false, c);
        this.vehicle = v;
        this.wheelIndex = wheelIndex;
    }

    @Override
    public void update(float timeStep) {
        if (this.getUpdateManager() != null) {
            this.getUpdateManager().update(timeStep);
        }
        if (this.getController() != null) {
            this.velocity = this.getController().compute((double)this.getWheelInfo().rotation, this.getTarget(), (double)timeStep);
        }
        this.vehicle.updateWheelTransform(this.getWheelIndex(), true);
        TransformNR trans = TransformFactory.bulletToNr(this.vehicle.getWheelInfo((int)this.getWheelIndex()).worldTransform);
        TransformFactory.nrToBullet(trans, this.getUpdateTransform());
    }

    public double getTarget() {
        return this.target;
    }

    public void setTarget(double target) {
        this.target = target;
    }

    public static float getMotorStrength() {
        return muscleStrength;
    }

    public static void setMuscleStrength(float ms) {
        muscleStrength = ms;
    }

    public void setMuscleStrength(double muscleStrength) {
        WheelCSGPhysicsManager.setMuscleStrength((float)muscleStrength);
    }

    public IClosedLoopController getController() {
        return this.controller;
    }

    public void setController(IClosedLoopController controller) {
        this.controller = controller;
    }

    public WheelInfo getWheelInfo() {
        return this.vehicle.getWheelInfo(this.getWheelIndex());
    }

    public int getWheelIndex() {
        return this.wheelIndex;
    }
}

