/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.util;

import com.neuronrobotics.sdk.util.IFileChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FileChangeWatcher {
    private File fileToWatch;
    private boolean run = true;
    private final WatchService watcher;
    private final Map<WatchKey, Path> keys;
    private final boolean recursive = false;
    private ArrayList<IFileChangeListener> listeners = new ArrayList();
    private static boolean runThread = true;
    private static HashMap<String, FileChangeWatcher> activeListener = new HashMap();
    private Thread watcherThread = null;

    public static void clearAll() {
        for (String key : activeListener.keySet()) {
            activeListener.get(key).close();
        }
        activeListener.clear();
    }

    public static FileChangeWatcher watch(File fileToWatch) throws IOException {
        String path = fileToWatch.getAbsolutePath();
        if (activeListener.get(path) == null) {
            activeListener.put(path, new FileChangeWatcher(fileToWatch));
            System.err.println("Adding file to listening " + fileToWatch.getAbsolutePath());
        }
        return activeListener.get(path);
    }

    private FileChangeWatcher(File fileToWatch) throws IOException {
        this.setFileToWatch(fileToWatch);
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, Path>();
        Path dir = Paths.get(fileToWatch.getParent(), new String[0]);
        this.register(dir);
        this.watcherThread = new Thread(){

            @Override
            public void run() {
                this.setName("File Watcher Thread");
                while (FileChangeWatcher.this.run) {
                    try {
                        System.err.println("Checking File: " + FileChangeWatcher.this.getFileToWatch().getAbsolutePath());
                        FileChangeWatcher.this.watch();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.watcherThread.start();
    }

    public void addIFileChangeListener(IFileChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeIFileChangeListener(IFileChangeListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Path prev = this.keys.get(key);
        if (prev == null || !dir.equals(prev)) {
            // empty if block
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileChangeWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void watch() {
        WatchKey key;
        try {
            key = this.watcher.take();
        }
        catch (Exception x) {
            return;
        }
        if (!this.run) {
            return;
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            System.err.println("WatchKey not recognized!!");
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            WatchEvent ev = FileChangeWatcher.cast(event);
            Path name = (Path)ev.context();
            Path child = dir.resolve(name);
            try {
                if (!child.toFile().getCanonicalPath().equals(this.fileToWatch.getCanonicalPath())) continue;
                System.err.println("File Changed: " + this.getFileToWatch().getAbsolutePath());
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).onFileChange(child.toFile(), event);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean valid = key.reset();
        if (!valid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return;
            }
        }
    }

    public File getFileToWatch() {
        return this.fileToWatch;
    }

    public void setFileToWatch(File fileToWatch) {
        this.fileToWatch = fileToWatch;
    }

    public boolean isRun() {
        return this.run;
    }

    public void close() {
        new Exception("File watcher closed " + this.fileToWatch.getAbsolutePath()).printStackTrace();
        this.run = false;
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        activeListener.remove(this.fileToWatch.getAbsolutePath());
    }
}

