/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.util.data.audio.MonoAudioInputStream;
import marytts.util.data.audio.StereoAudioInputStream;

public class AudioPlayer
extends Thread {
    public static final int MONO = 0;
    public static final int STEREO = 3;
    public static final int LEFT_ONLY = 1;
    public static final int RIGHT_ONLY = 2;
    private AudioInputStream ais;
    private LineListener lineListener;
    private SourceDataLine line;
    private int outputMode;
    private Status status = Status.WAITING;
    private boolean exitRequested = false;
    private float gain = 1.0f;

    public AudioPlayer() {
    }

    public AudioPlayer(File audioFile) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
    }

    public AudioPlayer(AudioInputStream ais) {
        this.ais = ais;
    }

    public AudioPlayer(File audioFile, LineListener lineListener) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.lineListener = lineListener;
    }

    public AudioPlayer(AudioInputStream ais, LineListener lineListener) {
        this.ais = ais;
        this.lineListener = lineListener;
    }

    public AudioPlayer(File audioFile, SourceDataLine line, LineListener lineListener) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.setLine(line);
        this.lineListener = lineListener;
    }

    public AudioPlayer(AudioInputStream ais, SourceDataLine line, LineListener lineListener) {
        this.ais = ais;
        this.setLine(line);
        this.lineListener = lineListener;
    }

    public AudioPlayer(File audioFile, SourceDataLine line, LineListener lineListener, int outputMode) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.setLine(line);
        this.lineListener = lineListener;
        this.outputMode = outputMode;
    }

    public AudioPlayer(AudioInputStream ais, SourceDataLine line, LineListener lineListener, int outputMode) {
        this.ais = ais;
        this.setLine(line);
        this.lineListener = lineListener;
        this.outputMode = outputMode;
    }

    public void setAudio(AudioInputStream audio) {
        if (this.status == Status.PLAYING) {
            throw new IllegalStateException("Cannot set audio while playing");
        }
        this.ais = audio;
    }

    public void cancel() {
        if (this.getLine() != null) {
            this.getLine().stop();
        }
        this.exitRequested = true;
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    public float getGainValue() {
        return this.gain;
    }

    public void setGain(float fGain) {
        this.gain = fGain;
        if (this.getLine() != null && this.getLine().isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            ((FloatControl)this.getLine().getControl(FloatControl.Type.MASTER_GAIN)).setValue((float)(20.0 * Math.log10((double)fGain <= 0.0 ? 0.0 : (double)fGain)));
        }
    }

    @Override
    public void run() {
        this.status = Status.PLAYING;
        AudioFormat audioFormat = this.ais.getFormat();
        if (audioFormat.getChannels() == 1) {
            if (this.outputMode != 0) {
                this.ais = new StereoAudioInputStream(this.ais, this.outputMode);
                audioFormat = this.ais.getFormat();
            }
        } else {
            assert (audioFormat.getChannels() == 2) : "Unexpected number of channels: " + audioFormat.getChannels();
            if (this.outputMode == 0) {
                this.ais = new MonoAudioInputStream(this.ais);
            } else if (this.outputMode == 1 || this.outputMode == 2) {
                this.ais = new StereoAudioInputStream(this.ais, this.outputMode);
            } else assert (this.outputMode == 3) : "Unexpected output mode: " + this.outputMode;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            if (this.getLine() == null) {
                boolean bIsSupportedDirectly = AudioSystem.isLineSupported(info);
                if (!bIsSupportedDirectly) {
                    AudioFormat sourceFormat = audioFormat;
                    AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getChannels() * (sourceFormat.getSampleSizeInBits() / 8), sourceFormat.getSampleRate(), sourceFormat.isBigEndian());
                    this.ais = AudioSystem.getAudioInputStream(targetFormat, this.ais);
                    audioFormat = this.ais.getFormat();
                }
                info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.setLine((SourceDataLine)AudioSystem.getLine(info));
            }
            if (this.lineListener != null) {
                this.getLine().addLineListener(this.lineListener);
            }
            this.getLine().open(audioFormat);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ex);
            return;
        }
        this.getLine().start();
        this.setGain(this.getGainValue());
        int nRead = 0;
        byte[] abData = new byte[65532];
        while (nRead != -1 && !this.exitRequested) {
            try {
                nRead = this.ais.read(abData, 0, abData.length);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ex);
            }
            if (nRead < 0) continue;
            this.getLine().write(abData, 0, nRead);
        }
        if (!this.exitRequested) {
            this.getLine().drain();
        }
        this.getLine().close();
    }

    public void setLine(SourceDataLine line) {
        this.line = line;
    }

    public static enum Status {
        WAITING,
        PLAYING;

    }
}

