/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.creature;

import com.neuronrobotics.bowlerstudio.creature.CadFileExporter;
import com.neuronrobotics.bowlerstudio.creature.ICadGenerator;
import com.neuronrobotics.bowlerstudio.creature.IMobileBaseUI;
import com.neuronrobotics.bowlerstudio.creature.IgenerateBed;
import com.neuronrobotics.bowlerstudio.creature.IgenerateBody;
import com.neuronrobotics.bowlerstudio.creature.IgenerateCad;
import com.neuronrobotics.bowlerstudio.creature.MobileBaseLoader;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.neuronrobotics.bowlerstudio.util.FileChangeWatcher;
import com.neuronrobotics.bowlerstudio.util.FileWatchDeviceWrapper;
import com.neuronrobotics.sdk.addons.kinematics.AbstractLink;
import com.neuronrobotics.sdk.addons.kinematics.DHParameterKinematics;
import com.neuronrobotics.sdk.addons.kinematics.ILinkListener;
import com.neuronrobotics.sdk.addons.kinematics.LinkConfiguration;
import com.neuronrobotics.sdk.addons.kinematics.MobileBase;
import com.neuronrobotics.sdk.common.BowlerAbstractDevice;
import com.neuronrobotics.sdk.common.IDeviceConnectionEventListener;
import com.neuronrobotics.sdk.pid.PIDLimitEvent;
import com.neuronrobotics.sdk.util.IFileChangeListener;
import com.neuronrobotics.sdk.util.ThreadUtil;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.parametrics.CSGDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;

public class MobileBaseCadManager {
    private static HashMap<MobileBase, MobileBaseCadManager> cadmap = new HashMap();
    private Object cadEngine;
    private MobileBase base;
    private File cadScript;
    private HashMap<DHParameterKinematics, Object> dhCadGen = new HashMap();
    private HashMap<DHParameterKinematics, ArrayList<CSG>> DHtoCadMap = new HashMap();
    private HashMap<LinkConfiguration, ArrayList<CSG>> LinktoCadMap = new HashMap();
    private HashMap<MobileBase, ArrayList<CSG>> BasetoCadMap = new HashMap();
    private boolean cadGenerating = false;
    private boolean showingStl = false;
    private ArrayList<CSG> allCad;
    private boolean bail = false;
    private IMobileBaseUI ui = null;
    private static ICadGenerator cadEngineConfiguration = null;
    private boolean configMode = false;
    private IFileChangeListener cadWatcher = new IFileChangeListener(){

        public void onFileChange(final File fileThatChanged, WatchEvent event) {
            if (MobileBaseCadManager.this.cadGenerating || !MobileBaseCadManager.this.getAutoRegen()) {
                System.out.println("No Base reload, building currently");
                return;
            }
            try {
                new Thread(){

                    @Override
                    public void run() {
                        ThreadUtil.wait((int)((int)(50.0 * Math.random() + 50.0)));
                        try {
                            System.out.println("Re-loading Cad Base Engine");
                            MobileBaseCadManager.this.cadEngine = ScriptingEngine.inlineFileScriptRun(fileThatChanged, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        MobileBaseCadManager.this.generateCad();
                    }
                }.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private boolean autoRegen = true;
    private DoubleProperty pi = new SimpleDoubleProperty(0.0);

    private MobileBaseCadManager(final MobileBase base, IMobileBaseUI myUI) {
        this.setUi(myUI);
        base.addConnectionEventListener(new IDeviceConnectionEventListener(){

            public void onDisconnect(BowlerAbstractDevice arg0) {
                MobileBaseCadManager.this.bail = true;
                MobileBaseCadManager.this.dhCadGen.clear();
                MobileBaseCadManager.this.DHtoCadMap.clear();
                MobileBaseCadManager.this.LinktoCadMap.clear();
                MobileBaseCadManager.this.BasetoCadMap.clear();
                cadmap.remove(base);
            }

            public void onConnect(BowlerAbstractDevice arg0) {
            }
        });
        this.setMobileBase(base);
    }

    public File getCadScript() {
        return this.cadScript;
    }

    public void setCadScript(File cadScript) {
        if (cadScript == null) {
            return;
        }
        FileWatchDeviceWrapper.watch((BowlerAbstractDevice)this.base, cadScript, this.cadWatcher);
        this.cadScript = cadScript;
    }

    private IgenerateBody getIgenerateBody() {
        if (this.configMode) {
            return MobileBaseCadManager.getConfigurationDisplay();
        }
        if (IgenerateBody.class.isInstance(this.cadEngine)) {
            return (IgenerateBody)this.cadEngine;
        }
        return null;
    }

    private IgenerateCad getIgenerateCad() {
        if (this.configMode) {
            return MobileBaseCadManager.getConfigurationDisplay();
        }
        if (IgenerateCad.class.isInstance(this.cadEngine)) {
            return (IgenerateCad)this.cadEngine;
        }
        return null;
    }

    private IgenerateBed getIgenerateBed() {
        if (IgenerateBed.class.isInstance(this.cadEngine)) {
            return (IgenerateBed)this.cadEngine;
        }
        return null;
    }

    private static ICadGenerator getConfigurationDisplay() {
        if (cadEngineConfiguration == null) {
            try {
                File confFile = ScriptingEngine.fileFromGit("https://github.com/CommonWealthRobotics/DHParametersCadDisplay.git", "dhcad.groovy");
                cadEngineConfiguration = (ICadGenerator)ScriptingEngine.inlineFileScriptRun(confFile, null);
                FileChangeWatcher watcher = FileChangeWatcher.watch(confFile);
                watcher.addIFileChangeListener(new IFileChangeListener(){

                    public void onFileChange(File fileThatChanged, WatchEvent event) {
                        try {
                            cadEngineConfiguration = (ICadGenerator)ScriptingEngine.gitScriptRun("https://github.com/CommonWealthRobotics/DHParametersCadDisplay.git", "dhcad.groovy", null);
                            for (MobileBase manager : cadmap.keySet()) {
                                MobileBaseCadManager mobileBaseCadManager = (MobileBaseCadManager)cadmap.get(manager);
                                if (!mobileBaseCadManager.autoRegen || !mobileBaseCadManager.configMode) continue;
                                mobileBaseCadManager.generateCad();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cadEngineConfiguration;
    }

    public ArrayList<CSG> generateBody(MobileBase base) {
        this.getProcesIndictor().set(0.0);
        this.setAllCad(new ArrayList<CSG>());
        MobileBase device = base;
        if (this.getBasetoCadMap().get(device) == null) {
            this.getBasetoCadMap().put(device, new ArrayList());
        }
        if (this.cadEngine == null) {
            try {
                this.setDefaultLinkLevelCadEngine();
            }
            catch (Exception e) {
                this.getUi().highlightException(null, e);
            }
            if (this.getCadScript() != null) {
                try {
                    this.cadEngine = ScriptingEngine.inlineFileScriptRun(this.getCadScript(), null);
                }
                catch (Exception e) {
                    this.getUi().highlightException(this.getCadScript(), e);
                }
            }
        }
        this.getProcesIndictor().set(0.1);
        try {
            this.getAllCad().clear();
            if (this.showingStl) {
                for (CSG cSG : this.getBasetoCadMap().get(device)) {
                    this.getAllCad().add(cSG);
                }
            } else {
                if (!this.bail) {
                    ArrayList<CSG> newcad = this.getIgenerateBody().generateBody(device);
                    for (CSG c : newcad) {
                        this.getAllCad().add(c);
                    }
                    this.ui.addCSG(newcad, this.getCadScript());
                } else {
                    new Exception().printStackTrace();
                }
                ArrayList<CSG> arrayList = this.getBasetoCadMap().get(device);
                arrayList.clear();
                for (CSG c : this.getAllCad()) {
                    arrayList.add(c);
                }
                new Thread(() -> this.localGetBaseCad(device)).start();
            }
        }
        catch (Exception e) {
            this.getUi().highlightException(this.getCadScript(), e);
        }
        System.out.println("Displaying Body");
        this.getProcesIndictor().set(0.35);
        this.getUi().setAllCSG((Collection<CSG>)this.getBasetoCadMap().get(device), this.getCadScript());
        System.out.println("Rendering limbs");
        this.getProcesIndictor().set(0.4);
        ArrayList limbs = base.getAllDHChains();
        double d = limbs.size();
        int i = 0;
        for (DHParameterKinematics l : limbs) {
            if (this.getDHtoCadMap().get(l) == null) {
                this.getDHtoCadMap().put(l, new ArrayList());
            }
            ArrayList<CSG> arrayList = this.getDHtoCadMap().get(l);
            int j = 0;
            if (this.showingStl || !device.isAvailable()) {
                for (CSG csg : arrayList) {
                    this.getAllCad().add(csg);
                    this.getUi().addCsg(csg, this.getCadScript());
                    this.set(base, i, j);
                    ++j;
                }
            } else {
                arrayList.clear();
                ArrayList<CSG> linksCad = this.generateCad(l);
                for (CSG csg : linksCad) {
                    this.getAllCad().add(csg);
                    arrayList.add(csg);
                    this.getUi().addCsg(csg, this.getCadScript());
                    ++j;
                }
            }
            ++i;
        }
        this.showingStl = false;
        this.getProcesIndictor().set(1.0);
        return this.getAllCad();
    }

    private void set(MobileBase base, int limb, int link) {
        ArrayList limbs = base.getAllDHChains();
        double numLimbs = limbs.size();
        DHParameterKinematics dh = (DHParameterKinematics)limbs.get(limb);
        double partsTotal = numLimbs * (double)dh.getNumberOfLinks();
        double progress = (double)(limb * dh.getNumberOfLinks() + link) / partsTotal;
        System.out.println("Cad progress " + progress + " limb " + limb + " link " + link + " total parts " + partsTotal);
        this.getProcesIndictor().set(0.333 + 2.0 * (progress / 3.0));
    }

    public LinkConfiguration getLinkConfiguration(CSG cad) {
        LinkConfiguration conf = null;
        for (LinkConfiguration c : this.LinktoCadMap.keySet()) {
            for (CSG cadTest : this.LinktoCadMap.get(c)) {
                if (cadTest != cad) continue;
                conf = c;
            }
        }
        return conf;
    }

    public ArrayList<File> generateStls(MobileBase base, File baseDirForFiles, boolean kinematic) throws IOException {
        IgenerateBed bed = this.getIgenerateBed();
        if (bed == null || kinematic) {
            return this._generateStls(base, baseDirForFiles, kinematic);
        }
        System.out.println("Found arrangeBed API in CAD engine");
        ArrayList<CSG> totalAssembly = bed.arrangeBed(base);
        this.getUi().setAllCSG(totalAssembly, this.getCadScript());
        File dir = new File(baseDirForFiles.getAbsolutePath() + "/" + base.getScriptingName());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new CadFileExporter(this.getUi()).generateManufacturingParts(totalAssembly, baseDirForFiles);
    }

    private ArrayList<File> _generateStls(MobileBase base, File baseDirForFiles, boolean kinematic) throws IOException {
        ArrayList<File> allCadStl = new ArrayList<File>();
        ArrayList limbs = base.getAllDHChains();
        double numLimbs = limbs.size();
        ArrayList<CSG> totalAssembly = new ArrayList<CSG>();
        double offset = 0.0;
        for (int i = 0; i < limbs.size(); ++i) {
            double progress = (1.0 - (numLimbs - (double)i) / numLimbs) / 2.0;
            this.getProcesIndictor().set(progress);
            DHParameterKinematics l = (DHParameterKinematics)limbs.get(i);
            ArrayList<CSG> parts = this.getDHtoCadMap().get(l);
            for (int j = 0; j < parts.size(); ++j) {
                CSG csg = parts.get(j);
                String name = csg.getName();
                try {
                    if (!kinematic) {
                        csg = csg.prepForManufacturing();
                    }
                    if (csg == null) continue;
                    CSG tmp = !kinematic ? csg.toXMax().toYMax() : csg;
                    if (totalAssembly.size() > 0 && !kinematic) {
                        totalAssembly.add(tmp.movey((Number)(0.5 + ((CSG)totalAssembly.get(totalAssembly.size() - 1)).getMaxY() + Math.abs(csg.getMinY()))));
                    } else {
                        totalAssembly.add(tmp);
                    }
                    LinkConfiguration conf = this.getLinkConfiguration(parts.get(j));
                    String linkNum = conf.getLinkIndex() + "_Link_";
                    File dir = new File(baseDirForFiles.getAbsolutePath() + "/" + base.getScriptingName() + "/" + l.getScriptingName());
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    System.out.println("Making STL for " + name);
                    File stl = new File(dir.getAbsolutePath() + "/" + linkNum + name + "_limb_" + i + "_Part_" + j + ".stl");
                    FileUtil.write((Path)Paths.get(stl.getAbsolutePath(), new String[0]), (String)tmp.toStlString());
                    allCadStl.add(stl);
                    this.getUi().setAllCSG(totalAssembly, this.getCadScript());
                    this.set(base, i, j);
                    continue;
                }
                catch (Exception ex) {
                    this.getUi().highlightException(this.getCadScript(), ex);
                }
            }
        }
        int link = 0;
        for (CSG csg : this.getBasetoCadMap().get(base)) {
            String name = csg.getName();
            try {
                File dir;
                if (!kinematic) {
                    csg = csg.prepForManufacturing();
                }
                if (csg == null) continue;
                if (!kinematic) {
                    csg = csg.toYMin().movex((Number)(-2.0 - csg.getMaxX() + offset));
                }
                if (!(dir = new File(baseDirForFiles.getAbsolutePath() + "/" + base.getScriptingName() + "/")).exists()) {
                    dir.mkdirs();
                }
                File stl = new File(dir.getAbsolutePath() + "/" + name + "_Body_part_" + link + ".stl");
                FileUtil.write((Path)Paths.get(stl.getAbsolutePath(), new String[0]), (String)csg.toStlString());
                allCadStl.add(stl);
                totalAssembly.add(csg);
                this.getUi().setAllCSG(totalAssembly, this.getCadScript());
                ++link;
            }
            catch (Exception ex) {
                this.getUi().highlightException(this.getCadScript(), ex);
            }
        }
        this.showingStl = true;
        this.getProcesIndictor().set(1.0);
        return allCadStl;
    }

    public MobileBase getMobileBase() {
        return this.base;
    }

    public void setMobileBase(MobileBase base) {
        this.base = base;
        cadmap.put(base, this);
        MobileBaseLoader.get(base);
        base.updatePositions();
    }

    public ArrayList<CSG> generateCad(DHParameterKinematics dh) {
        ArrayList<CSG> dhLinks = new ArrayList<CSG>();
        if (this.cadEngine == null) {
            try {
                this.setDefaultLinkLevelCadEngine();
            }
            catch (Exception e) {
                this.getUi().highlightException(this.getCadScript(), e);
            }
        }
        try {
            DHParameterKinematics dhtest;
            Object object;
            IgenerateCad generatorToUse = this.getIgenerateCad();
            if (this.dhCadGen.get(dh) != null && IgenerateCad.class.isInstance(object = this.dhCadGen.get(dh))) {
                generatorToUse = (IgenerateCad)object;
            }
            int j = 0;
            Iterator iterator = this.getMobileBase().getAllDHChains().iterator();
            while (iterator.hasNext() && (dhtest = (DHParameterKinematics)iterator.next()) != dh) {
                ++j;
            }
            for (int i = 0; i < dh.getNumberOfLinks(); ++i) {
                this.set(this.base, j, i);
                if (this.bail) continue;
                ArrayList<CSG> tmp = generatorToUse.generateCad(dh, i);
                this.getUi().addCSG(tmp, this.getCadScript());
                final LinkConfiguration configuration = dh.getLinkConfiguration(i);
                if (this.getLinktoCadMap().get(configuration) == null) {
                    this.getLinktoCadMap().put(configuration, new ArrayList());
                } else {
                    this.getLinktoCadMap().get(configuration).clear();
                }
                for (CSG c : tmp) {
                    dhLinks.add(c);
                    this.getLinktoCadMap().get(configuration).add(c);
                }
                AbstractLink link = dh.getFactory().getLink(configuration);
                link.addLinkListener(new ILinkListener(){

                    public void onLinkPositionUpdate(AbstractLink arg0, double arg1) {
                    }

                    public void onLinkLimit(AbstractLink arg0, PIDLimitEvent arg1) {
                        if (MobileBaseCadManager.this.getAutoRegen()) {
                            MobileBaseCadManager.this.selectCsgByLink(MobileBaseCadManager.this.base, configuration);
                        }
                    }
                });
            }
            return dhLinks;
        }
        catch (Exception e) {
            this.getUi().highlightException(this.getCadScript(), e);
            return null;
        }
    }

    public void selectCsgByMobileBase(MobileBase base) {
        try {
            ArrayList<CSG> csg = MobileBaseCadManager.get(base).getBasetoCadMap().get(base);
            this.getUi().setSelectedCsg(csg);
        }
        catch (Exception ex) {
            System.err.println("Base not loaded yet");
        }
    }

    public void selectCsgByLimb(MobileBase base, DHParameterKinematics limb) {
        try {
            ArrayList<CSG> limCad = MobileBaseCadManager.get(base).getDHtoCadMap().get(limb);
            this.getUi().setSelectedCsg(limCad);
        }
        catch (Exception ex) {
            System.err.println("Limb not loaded yet");
        }
    }

    public void selectCsgByLink(MobileBase base, LinkConfiguration limb) {
        try {
            ArrayList<CSG> limCad = MobileBaseCadManager.get(base).getLinktoCadMap().get(limb);
            this.getUi().setSelectedCsg(limCad);
        }
        catch (Exception ex) {
            System.err.println("Limb not loaded yet");
        }
    }

    public void generateCad() {
        if (this.cadGenerating || !this.getAutoRegen()) {
            return;
        }
        this.cadGenerating = true;
        new Thread(){

            @Override
            public void run() {
                System.out.print("\r\nGenerating CAD...\r\n");
                this.setName("MobileBaseCadManager Generating cad Thread ");
                MobileBase device = MobileBaseCadManager.this.base;
                try {
                    MobileBaseCadManager.this.setAllCad(MobileBaseCadManager.this.generateBody(device));
                }
                catch (Exception e) {
                    MobileBaseCadManager.this.getUi().highlightException(MobileBaseCadManager.this.getCadScript(), e);
                }
                MobileBaseCadManager.this.getUi().setCsg(MobileBaseCadManager.get(MobileBaseCadManager.this.base), MobileBaseCadManager.this.getCadScript());
                MobileBaseCadManager.this.cadGenerating = false;
                System.out.print("\r\nDone Generating CAD!\r\n");
                MobileBaseCadManager.this.getProcesIndictor().set(1.0);
            }
        }.start();
    }

    private void setDefaultLinkLevelCadEngine() throws Exception {
        String[] cad = this.base.getGitCadEngine();
        if (this.cadEngine == null) {
            this.setGitCadEngine(cad[0], cad[1], this.base);
        }
        for (DHParameterKinematics kin : this.base.getAllDHChains()) {
            String[] kinEng = kin.getGitCadEngine();
            if (cad[0].contentEquals(kinEng[0]) && cad[1].contentEquals(kinEng[1])) continue;
            this.setGitCadEngine(kinEng[0], kinEng[1], kin);
        }
    }

    public void onTabClosing() {
    }

    public void setGitCadEngine(String gitsId, String file, DHParameterKinematics dh) throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        dh.setGitCadEngine(new String[]{gitsId, file});
        File code = ScriptingEngine.fileFromGit(gitsId, file);
        try {
            Object defaultDHSolver = ScriptingEngine.inlineFileScriptRun(code, null);
            this.dhCadGen.put(dh, defaultDHSolver);
        }
        catch (Exception e) {
            this.getUi().highlightException(code, e);
        }
        FileWatchDeviceWrapper.watch((BowlerAbstractDevice)dh, code, (fileThatChanged, event) -> {
            System.out.println("Re-loading Cad Limb Engine");
            try {
                Object d = ScriptingEngine.inlineFileScriptRun(code, null);
                this.dhCadGen.put(dh, d);
                this.generateCad();
            }
            catch (Exception ex) {
                this.getUi().highlightException(code, ex);
            }
        });
    }

    public void setGitCadEngine(String gitsId, String file, MobileBase device) throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        this.setCadScript(ScriptingEngine.fileFromGit(gitsId, file));
        device.setGitCadEngine(new String[]{gitsId, file});
    }

    public ArrayList<CSG> getAllCad() {
        return this.allCad;
    }

    public void setAllCad(ArrayList<CSG> allCad) {
        for (CSG part : allCad) {
            for (String p : part.getParameters()) {
                CSGDatabase.addParameterListener((String)p, (arg0, arg1) -> {});
            }
        }
        this.allCad = allCad;
    }

    public static MobileBaseCadManager get(MobileBase device, IMobileBaseUI ui) {
        if (cadmap.get(device) == null) {
            MobileBaseCadManager mbcm = new MobileBaseCadManager(device, ui);
            cadmap.put(device, mbcm);
        }
        MobileBaseCadManager mobileBaseCadManager = cadmap.get(device);
        if (!IMobileBaseUIlocal.class.isInstance(ui) && IMobileBaseUIlocal.class.isInstance(mobileBaseCadManager.getUi())) {
            mobileBaseCadManager.setUi(ui);
        }
        return mobileBaseCadManager;
    }

    public static MobileBaseCadManager get(MobileBase device) {
        if (cadmap.get(device) == null) {
            final IMobileBaseUIlocal ui2 = new IMobileBaseUIlocal();
            device.addConnectionEventListener(new IDeviceConnectionEventListener(){

                public void onDisconnect(BowlerAbstractDevice source) {
                    ui2.list.clear();
                }

                public void onConnect(BowlerAbstractDevice source) {
                }
            });
            return MobileBaseCadManager.get(device, ui2);
        }
        return cadmap.get(device);
    }

    public static HashMap<LinkConfiguration, ArrayList<CSG>> getSimplecad(MobileBase device) {
        return MobileBaseCadManager.get((MobileBase)device).LinktoCadMap;
    }

    private ArrayList<CSG> localGetBaseCad(MobileBase device) {
        return this.BasetoCadMap.get(device);
    }

    public static ArrayList<CSG> getBaseCad(MobileBase device) {
        return MobileBaseCadManager.get(device).localGetBaseCad(device);
    }

    public DoubleProperty getProcesIndictor() {
        return this.pi;
    }

    public void setProcesIndictor(DoubleProperty pi) {
        this.pi = pi;
    }

    public HashMap<MobileBase, ArrayList<CSG>> getBasetoCadMap() {
        return this.BasetoCadMap;
    }

    public void setBasetoCadMap(HashMap<MobileBase, ArrayList<CSG>> basetoCadMap) {
        this.BasetoCadMap = basetoCadMap;
    }

    public HashMap<DHParameterKinematics, ArrayList<CSG>> getDHtoCadMap() {
        return this.DHtoCadMap;
    }

    public void setDHtoCadMap(HashMap<DHParameterKinematics, ArrayList<CSG>> dHtoCadMap) {
        this.DHtoCadMap = dHtoCadMap;
    }

    public HashMap<LinkConfiguration, ArrayList<CSG>> getLinktoCadMap() {
        return this.LinktoCadMap;
    }

    public void setLinktoCadMap(HashMap<LinkConfiguration, ArrayList<CSG>> linktoCadMap) {
        this.LinktoCadMap = linktoCadMap;
    }

    public boolean getAutoRegen() {
        return this.autoRegen;
    }

    public void setAutoRegen(boolean autoRegen) {
        this.autoRegen = autoRegen;
    }

    public IMobileBaseUI getUi() {
        return this.ui;
    }

    public void setUi(IMobileBaseUI ui) {
        this.ui = ui;
    }

    public void setConfigurationViewerMode(boolean b) {
        System.out.println("Setting config mode " + b);
        this.configMode = b;
    }

    private static class IMobileBaseUIlocal
    implements IMobileBaseUI {
        public ArrayList<CSG> list = new ArrayList();

        private IMobileBaseUIlocal() {
        }

        @Override
        public void highlightException(File fileEngineRunByName, Exception ex) {
            ex.printStackTrace();
        }

        @Override
        public void setAllCSG(Collection<CSG> toAdd, File source) {
            this.list.clear();
            this.list.addAll(toAdd);
        }

        @Override
        public void addCSG(Collection<CSG> toAdd, File source) {
            this.list.addAll(toAdd);
        }

        @Override
        public Set<CSG> getVisibleCSGs() {
            return new HashSet<CSG>(this.list);
        }

        @Override
        public void setSelectedCsg(Collection<CSG> selectedCsg) {
        }
    }
}

