/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.vitamins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.neuronrobotics.bowlerstudio.vitamins.Purchasing;
import com.neuronrobotics.bowlerstudio.vitamins.PurchasingData;
import com.neuronrobotics.sdk.common.Log;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.STL;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import eu.mihosoft.vrl.v3d.parametrics.StringParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.errors.TransportException;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class Vitamins {
    private static String jsonRootDir = "json/";
    private static final Map<String, CSG> fileLastLoaded = new HashMap<String, CSG>();
    private static final Map<String, HashMap<String, HashMap<String, Object>>> databaseSet = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
    private static final String defaultgitRpoDatabase = "https://github.com/madhephaestus/Hardware-Dimensions.git";
    private static String gitRpoDatabase = "https://github.com/madhephaestus/Hardware-Dimensions.git";
    private static Type TT_mapStringString = new TypeToken<HashMap<String, HashMap<String, Object>>>(){}.getType();
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static boolean checked;

    public static CSG get(File resource) {
        if (fileLastLoaded.get(resource.getAbsolutePath()) == null) {
            try {
                fileLastLoaded.put(resource.getAbsolutePath(), STL.file((Path)resource.toPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileLastLoaded.get(resource.getAbsolutePath()).clone();
    }

    public static CSG get(String type, String id, String purchasingVariant) throws Exception {
        String key = type + id + purchasingVariant;
        if (fileLastLoaded.get(key) == null) {
            PurchasingData purchasData = Purchasing.get(type, id, purchasingVariant);
            for (String variable : purchasData.getVariantParameters().keySet()) {
                double data = purchasData.getVariantParameters().get(variable);
                LengthParameter parameter = new LengthParameter(variable, Double.valueOf(data), (ArrayList)Arrays.asList(data, data));
                parameter.setMM(data);
            }
            try {
                fileLastLoaded.put(key, Vitamins.get(type, id));
            }
            catch (Exception e) {
                e.printStackTrace();
                gitRpoDatabase = defaultgitRpoDatabase;
                databaseSet.clear();
                fileLastLoaded.clear();
                return Vitamins.get(type, id);
            }
        }
        CSG vitToGet = fileLastLoaded.get(type + id);
        return vitToGet;
    }

    public static CSG get(String type, String id) throws Exception {
        return Vitamins.get(type, id, 0);
    }

    public static CSG get(String type, String id, int depthGauge) throws Exception {
        String key = type + id;
        try {
            CSG newVitamin = null;
            HashMap<String, Object> script = Vitamins.getMeta(type);
            StringParameter size = new StringParameter(type + " Default", id, Vitamins.listVitaminSizes(type));
            size.setStrValue(id);
            Object file = script.get("scriptGit");
            Object repo = script.get("scriptFile");
            if (file != null && repo != null) {
                ArrayList<Object> servoMeasurments = new ArrayList<Object>();
                servoMeasurments.add(id);
                newVitamin = (CSG)ScriptingEngine.gitScriptRun(script.get("scriptGit").toString(), script.get("scriptFile").toString(), servoMeasurments);
                return newVitamin;
            }
            Log.error((String)(key + " Failed to load from script"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            gitRpoDatabase = defaultgitRpoDatabase;
            databaseSet.clear();
            fileLastLoaded.clear();
            if (depthGauge < 2) {
                return Vitamins.get(type, id, depthGauge + 1);
            }
            return null;
        }
    }

    public static HashMap<String, Object> getMeta(String type) {
        return Vitamins.getConfiguration(type, "meta");
    }

    public static void setScript(String type, String git, String file) throws Exception {
        Vitamins.setParameter(type, "meta", "scriptGit", git);
        Vitamins.setParameter(type, "meta", "scriptFile", file);
    }

    public static HashMap<String, Object> getConfiguration(String type, String id) {
        HashMap<String, HashMap<String, Object>> database = Vitamins.getDatabase(type);
        if (database.get(id) == null) {
            database.put(id, new HashMap());
        }
        return database.get(id);
    }

    public static String makeJson(String type) {
        return gson.toJson(Vitamins.getDatabase(type), TT_mapStringString);
    }

    public static void saveDatabase(String type) throws Exception {
        String jsonString = Vitamins.makeJson(type);
        try {
            ScriptingEngine.pushCodeToGit(Vitamins.getGitRepoDatabase(), ScriptingEngine.getFullBranch(Vitamins.getGitRepoDatabase()), Vitamins.getRootFolder() + type + ".json", jsonString, "Pushing changed Database");
        }
        catch (TransportException ex) {
            System.out.println("You need to fork https://github.com/madhephaestus/Hardware-Dimensions.git to have permission to save");
            System.out.println("You do not have permission to push to this repo, change the GIT repo to your fork with setGitRpoDatabase(String gitRpoDatabase) ");
            throw ex;
        }
    }

    public static void newVitamin(String type, String id) throws Exception {
        HashMap<String, HashMap<String, Object>> database = Vitamins.getDatabase(type);
        if (database.keySet().size() > 0) {
            String exampleKey = null;
            for (String key : database.keySet()) {
                if (key.contains("meta")) continue;
                exampleKey = key;
            }
            if (exampleKey != null) {
                HashMap<String, Object> exampleConfiguration = Vitamins.getConfiguration(type, exampleKey);
                HashMap<String, Object> newConfig = Vitamins.getConfiguration(type, id);
                for (String key : exampleConfiguration.keySet()) {
                    newConfig.put(key, exampleConfiguration.get(key));
                }
            }
        }
        Vitamins.getConfiguration(type, id);
    }

    public static void setParameter(String type, String id, String parameterName, Object parameter) throws Exception {
        HashMap<String, Object> config = Vitamins.getConfiguration(type, id);
        try {
            config.put(parameterName, Double.parseDouble(parameter.toString()));
        }
        catch (NumberFormatException ex) {
            config.put(parameterName, parameter);
        }
    }

    public static HashMap<String, HashMap<String, Object>> getDatabase(String type) {
        if (databaseSet.get(type) == null) {
            FileInputStream inPut = null;
            try {
                File f = ScriptingEngine.fileFromGit(Vitamins.getGitRepoDatabase(), Vitamins.getRootFolder() + type + ".json");
                inPut = FileUtils.openInputStream((File)f);
                String jsonString = IOUtils.toString((InputStream)inPut);
                HashMap database = (HashMap)gson.fromJson(jsonString, TT_mapStringString);
                if (database == null) {
                    throw new RuntimeException("create a new one");
                }
                databaseSet.put(type, database);
                for (String key : databaseSet.get(type).keySet()) {
                    HashMap conf = (HashMap)database.get(key);
                    for (String confKey : conf.keySet()) {
                        try {
                            double num = Double.parseDouble(conf.get(confKey).toString());
                            conf.put(confKey, num);
                        }
                        catch (NumberFormatException ex) {
                            conf.put(confKey, conf.get(confKey).toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                databaseSet.put(type, new HashMap());
            }
        }
        return databaseSet.get(type);
    }

    private static String getRootFolder() {
        return Vitamins.getJsonRootDir();
    }

    public static ArrayList<String> listVitaminTypes() {
        ArrayList<String> types = new ArrayList<String>();
        try {
            File[] listOfFiles;
            File folder = ScriptingEngine.fileFromGit(Vitamins.getGitRepoDatabase(), Vitamins.getRootFolder() + "hobbyServo.json");
            for (File f : listOfFiles = folder.getParentFile().listFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".json")) continue;
                types.add(f.getName().substring(0, f.getName().indexOf(".json")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return types;
    }

    public static ArrayList<String> listVitaminSizes(String type) {
        ArrayList<String> types = new ArrayList<String>();
        HashMap<String, HashMap<String, Object>> database = Vitamins.getDatabase(type);
        Set<String> keys = database.keySet();
        for (String s : keys) {
            if (s == null || s.contains("meta")) continue;
            types.add(s);
        }
        return types;
    }

    public static String getGitRepoDatabase() throws IOException {
        if (!checked) {
            checked = true;
            try {
                if (ScriptingEngine.getLoginID() != null) {
                    ScriptingEngine.setAutoupdate(true);
                    GitHub github = ScriptingEngine.getGithub();
                    GHMyself self = github.getMyself();
                    Map myPublic = self.getAllRepositories();
                    for (String myRepo : myPublic.keySet()) {
                        GHRepository ghrepo = (GHRepository)myPublic.get(myRepo);
                        if (!myRepo.contentEquals("Hardware-Dimensions") || !ghrepo.getOwnerName().contentEquals(self.getLogin())) continue;
                        String myAssets = ghrepo.getGitTransportUrl().replaceAll("git://", "https://");
                        Vitamins.setGitRepoDatabase(myAssets);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gitRpoDatabase;
    }

    public static void setGitRepoDatabase(String gitRpoDatabase) {
        Vitamins.gitRpoDatabase = gitRpoDatabase;
        databaseSet.clear();
        fileLastLoaded.clear();
    }

    public static String getJsonRootDir() {
        return jsonRootDir;
    }

    public static void setJsonRootDir(String jsonRootDir) throws IOException {
        Vitamins.jsonRootDir = jsonRootDir;
        Vitamins.setGitRepoDatabase(Vitamins.getGitRepoDatabase());
    }
}

