/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio;

import com.neuronrobotics.bowlerstudio.TextToSpeech;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.neuronrobotics.sdk.addons.kinematics.JavaFXInitializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jline.ConsoleReader;
import jline.Terminal;
import marytts.signalproc.effects.ChorusEffectBase;
import marytts.signalproc.effects.HMMDurationScaleEffect;
import marytts.signalproc.effects.LpcWhisperiserEffect;
import marytts.signalproc.effects.RobotiserEffect;
import marytts.signalproc.effects.VolumeEffect;

public class BowlerKernel {
    private static final String CSG = null;
    private static File historyFile = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/bowler.history");

    private static void fail() {
        System.err.println("Usage: \r\njava -jar BowlerScriptKernel.jar -s <file 1> .. <file n> # This will load one script after the next ");
        System.err.println("java -jar BowlerScriptKernel.jar -p <file 1> .. <file n> # This will load one script then take the list of objects returned and pss them to the next script as its 'args' variable ");
        System.err.println("java -jar BowlerScriptKernel.jar -r <Groovy Jython or Clojure> (Optional)(-s or -p)<file 1> .. <file n> # This will start a shell in the requested langauge and run the files provided. ");
        System.err.println("java -jar BowlerScriptKernel.jar -g <Git repo> <Git file> # this will run a file from git");
        System.exit(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String groovy;
        JavaFXInitializer.go();
        ScriptingEngine.waitForLogin();
        if (args.length == 0) {
            BowlerKernel.fail();
        }
        boolean gitRun = false;
        String gitRepo = null;
        String gitFile = null;
        for (String s : args) {
            if (gitRun) {
                if (gitRepo == null) {
                    gitRepo = s;
                } else if (gitFile == null) {
                    gitFile = s;
                }
            }
            if (!s.contains("git") && !s.contains("-g")) continue;
            gitRun = true;
        }
        if (gitRun && gitRepo != null) {
            ScriptingEngine.pull(gitRepo);
        }
        ArrayList<String> files = ScriptingEngine.filesInGit(gitRepo);
        boolean fileExists = false;
        if (gitFile == null) {
            gitFile = "launch";
        }
        if (gitFile.endsWith("/")) {
            gitFile = gitFile + "launch";
        }
        for (String f : files) {
            if (!f.startsWith(gitFile)) continue;
            gitFile = f;
            fileExists = true;
        }
        if (!fileExists) {
            System.err.println("\n\nERROR file does not exist: " + gitFile);
            gitFile = null;
        }
        if (gitFile != null) {
            try {
                ScriptingEngine.gitScriptRun(gitRepo, gitFile, null);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                BowlerKernel.fail();
            }
        } else {
            System.out.println("Files in git:");
            for (String f : files) {
                System.out.println("\t" + f);
            }
        }
        boolean startLoadingScripts = false;
        Object ret = null;
        for (String string : args) {
            if (startLoadingScripts) {
                try {
                    ret = ScriptingEngine.inlineFileScriptRun(new File(string), null);
                }
                catch (Throwable e3) {
                    e3.printStackTrace();
                    BowlerKernel.fail();
                }
            }
            if (!string.contains("script") && !string.contains("-s")) continue;
            startLoadingScripts = true;
        }
        startLoadingScripts = false;
        for (String string : args) {
            if (startLoadingScripts) {
                try {
                    ret = ScriptingEngine.inlineFileScriptRun(new File(string), (ArrayList)ret);
                }
                catch (Throwable e4) {
                    e4.printStackTrace();
                    BowlerKernel.fail();
                }
            }
            if (!string.contains("pipe") && !string.contains("-p")) continue;
            startLoadingScripts = true;
        }
        boolean runShell = false;
        String shellTypeStorage = groovy = "Groovy";
        for (String s : args) {
            if (runShell) {
                try {
                    shellTypeStorage = s;
                }
                catch (Throwable e5) {
                    shellTypeStorage = groovy;
                }
                break;
            }
            if (!s.contains("repl") && !s.contains("-r")) continue;
            runShell = true;
        }
        if (!runShell) {
            System.exit(0);
        }
        System.out.println("Starting Bowler REPL in langauge: " + shellTypeStorage);
        if (!Terminal.getTerminal().isSupported()) {
            System.out.println("Terminal not supported " + Terminal.getTerminal());
        }
        final ConsoleReader consoleReader = new ConsoleReader();
        consoleReader.addTriggeredAction('\u0003', e -> System.exit(0));
        if (!historyFile.exists()) {
            historyFile.createNewFile();
            consoleReader.getHistory().addToHistory("println SDKBuildInfo.getVersion()");
            consoleReader.getHistory().addToHistory("for(int i=0;i<100;i++) { println dyio.getValue(0) }");
            consoleReader.getHistory().addToHistory("dyio.setValue(0,128)");
            consoleReader.getHistory().addToHistory("println dyio.getValue(0)");
            consoleReader.getHistory().addToHistory("ScriptingEngine.inlineGistScriptRun(\"d4312a0787456ec27a2a\", \"helloWorld.groovy\" , null)");
            consoleReader.getHistory().addToHistory("DeviceManager.addConnection(new DyIO(ConnectionDialog.promptConnection()),\"dyio\")");
            consoleReader.getHistory().addToHistory("DeviceManager.addConnection(new DyIO(new SerialConnection(\"/dev/DyIO0\")),\"dyio\")");
            consoleReader.getHistory().addToHistory("BowlerKernel.speak(\"Text to speech works like this\")");
            consoleReader.getHistory().addToHistory("ScriptingEngine.gitScriptRun(\\\"https://github.com/OperationSmallKat/greycat.git\\\", \\\"launch.groovy\\\" , null)");
            consoleReader.getHistory().addToHistory("println \"Hello world!\"");
            BowlerKernel.writeHistory(consoleReader.getHistory().getHistoryList());
        } else {
            ArrayList<String> history = BowlerKernel.loadHistory();
            for (String h : history) {
                consoleReader.getHistory().addToHistory(h);
            }
        }
        consoleReader.setBellEnabled(false);
        consoleReader.setDebug(new PrintWriter(new FileWriter("writer.debug", true)));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BowlerKernel.writeHistory(consoleReader.getHistory().getHistoryList());
            }
        });
        try {
            String line;
            block22: while ((line = consoleReader.readLine("Bowler " + shellTypeStorage + "> ")) != null) {
                if (line.equalsIgnoreCase("quit")) return;
                if (line.equalsIgnoreCase("exit")) {
                    return;
                }
                if (line.equalsIgnoreCase("history") || line.equalsIgnoreCase("h")) {
                    List h = consoleReader.getHistory().getHistoryList();
                    Iterator iterator = h.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block22;
                        String s = (String)iterator.next();
                        System.out.println(s);
                    }
                }
                if (line.startsWith("shellType")) {
                    try {
                        shellTypeStorage = line.split(" ")[1];
                    }
                    catch (Exception e6) {
                        shellTypeStorage = groovy;
                    }
                    continue;
                }
                try {
                    ret = ScriptingEngine.inlineScriptStringRun(line, null, shellTypeStorage);
                    if (ret == null) continue;
                    System.out.println(ret);
                }
                catch (Error e7) {
                    e7.printStackTrace();
                }
                catch (Exception e8) {
                    e8.printStackTrace();
                }
            }
            return;
        }
        catch (Exception e9) {
            e9.printStackTrace();
        }
    }

    public static ArrayList<String> loadHistory() throws IOException {
        ArrayList<String> history = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(historyFile));
        String line = null;
        while ((line = br.readLine()) != null) {
            history.add(line);
        }
        br.close();
        return history;
    }

    public static void writeHistory(List<String> history) {
        System.out.println("Saving history");
        try {
            FileOutputStream fos = new FileOutputStream(historyFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            for (String s : history) {
                bw.write(s);
                bw.newLine();
            }
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int speak(String msg) {
        return BowlerKernel.speak(msg, 200, 0, 100, 1.0, 1.0);
    }

    public static int speak(String msg, Number rate, Number pitch, Number range, Number shift, Number volume) {
        if (rate.doubleValue() > 300.0) {
            rate = 300;
        }
        if (rate.doubleValue() < 10.0) {
            rate = 10;
        }
        TextToSpeech tts = new TextToSpeech();
        tts.getAvailableVoices().stream().forEach(voice -> System.out.println("Voice: " + voice));
        if (range.doubleValue() > 200.0) {
            tts.setVoice("cmu-slt-hsmm");
        } else if (range.doubleValue() > 100.0) {
            tts.setVoice("dfki-spike-hsmm");
        } else if (range.doubleValue() > 50.0) {
            tts.setVoice("dfki-prudence-hsmm");
        } else {
            tts.setVoice("dfki-poppy-hsmm");
        }
        RobotiserEffect vocalTractLSE = new RobotiserEffect();
        vocalTractLSE.setParams("amount:" + pitch.intValue());
        String effect = "";
        if (volume.doubleValue() < 0.5) {
            LpcWhisperiserEffect lpcWhisperiserEffect = new LpcWhisperiserEffect();
            lpcWhisperiserEffect.setParams("amount:" + (50.0 + 50.0 * volume.doubleValue()));
            effect = effect + "+" + lpcWhisperiserEffect.getFullEffectAsString();
            volume = 1;
        }
        if (shift.doubleValue() < 1.0) {
            ChorusEffectBase ce = new ChorusEffectBase();
            ce.setParams("delay1:" + (int)(366.0 * shift.doubleValue()) + ";amp1:0.54;delay2:600;amp2:-0.10;delay3:250;amp3:0.30");
            effect = effect + "+" + ce.getFullEffectAsString();
        }
        VolumeEffect volumeEffect = new VolumeEffect();
        volumeEffect.setParams("amount:" + volume);
        HMMDurationScaleEffect ratEff = new HMMDurationScaleEffect();
        ratEff.setParams("durScale:" + rate.doubleValue() / 100.0);
        effect = effect + "+" + ratEff.getFullEffectAsString();
        effect = effect + "+" + volumeEffect.getFullEffectAsString();
        if (pitch.intValue() > 0) {
            effect = effect + "+" + vocalTractLSE.getFullEffectAsString();
        }
        System.out.println(msg + "-->" + effect);
        tts.getMarytts().setAudioEffects(effect);
        tts.speak(msg, 2.0f, false, true);
        return 0;
    }

    static {
        historyFile = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/bowler.history");
        ArrayList<String> history = new ArrayList<String>();
        if (!historyFile.exists()) {
            try {
                historyFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            history.add("println SDKBuildInfo.getVersion()");
            history.add("for(int i=0;i<1000000;i++) { println dyio.getValue(0) }");
            history.add("dyio.setValue(0,128)");
            history.add("println dyio.getValue(0)");
            history.add("ScriptingEngine.inlineGistScriptRun(\"d4312a0787456ec27a2a\", \"helloWorld.groovy\" , null)");
            history.add("DeviceManager.addConnection(new DyIO(ConnectionDialog.promptConnection()),\"dyio\")");
            history.add("DeviceManager.addConnection(new DyIO(new SerialConnection(\"/dev/DyIO0\")),\"dyio\")");
            history.add("shellType Clojure #Switches shell to Clojure");
            history.add("shellType Jython #Switches shell to Python");
            history.add("shellType Groovy #Switches shell to Groovy/Java");
            history.add("println \"Hello world!\"");
            BowlerKernel.writeHistory(history);
        }
    }
}

