/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio;

import com.neuronrobotics.bowlerstudio.AudioPlayer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.sound.sampled.AudioInputStream;
import marytts.LocalMaryInterface;
import marytts.MaryInterface;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.signalproc.effects.AudioEffect;
import marytts.signalproc.effects.AudioEffects;

public class TextToSpeech {
    private AudioPlayer tts;
    private MaryInterface marytts;

    public TextToSpeech() {
        try {
            this.marytts = new LocalMaryInterface();
        }
        catch (MaryConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void speak(String text, float gainValue, boolean daemon, boolean join) {
        this.stopSpeaking();
        try (AudioInputStream audio = this.marytts.generateAudio(text);){
            this.tts = new AudioPlayer();
            this.tts.setAudio(audio);
            this.tts.setGain(gainValue);
            this.tts.setDaemon(daemon);
            this.tts.start();
            if (join) {
                this.tts.join();
            }
        }
        catch (SynthesisException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Error saying phrase.", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "IO Exception", ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Interrupted ", ex);
            this.tts.interrupt();
        }
    }

    public void stopSpeaking() {
        if (this.tts != null) {
            this.tts.cancel();
        }
    }

    public Collection<Voice> getAvailableVoices() {
        return Voice.getAvailableVoices();
    }

    public MaryInterface getMarytts() {
        return this.marytts;
    }

    public List<AudioEffect> getAudioEffects() {
        return StreamSupport.stream(AudioEffects.getEffects().spliterator(), false).collect(Collectors.toList());
    }

    public void setVoice(String voice) {
        this.marytts.setVoice(voice);
    }
}

