/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import com.neuronrobotics.bowlerstudio.scripting.IScriptingLanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;

public class ClojureHelper
implements IScriptingLanguage {
    public static Var REQUIRE = ClojureHelper.var("clojure.core", "require");
    public static Var META = ClojureHelper.var("clojure.core", "meta");
    public static Var EVAL = ClojureHelper.var("clojure.core", "eval");
    public static Var READ_STRING = ClojureHelper.var("clojure.core", "load-string");

    public static Object require(String nsName) {
        return REQUIRE.invoke((Object)Symbol.intern((String)nsName));
    }

    public static Object readString(String s) {
        return READ_STRING.invoke((Object)s);
    }

    public static Var var(String varName) {
        return ClojureHelper.var("clojure.core", varName);
    }

    public static Var var(String nsName, String varName) {
        return RT.var((String)nsName, (String)varName);
    }

    public static Object eval(String string) {
        return EVAL.invoke(ClojureHelper.readString(string));
    }

    @Override
    public Object inlineScriptRun(File code, ArrayList<Object> args) {
        try {
            byte[] bytes = Files.readAllBytes(code.toPath());
            String s = new String(bytes, "UTF-8");
            return this.inlineScriptRun(s, args);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public Object inlineScriptRun(String code, ArrayList<Object> args) {
        return ClojureHelper.eval(code);
    }

    @Override
    public String getShellType() {
        return "Clojure";
    }

    @Override
    public boolean getIsTextFile() {
        return true;
    }

    @Override
    public ArrayList<String> getFileExtenetion() {
        return new ArrayList<String>(Arrays.asList("clj", "cljs", "cljc"));
    }
}

