/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Transform;
import java.util.Random;

public class Vector3d
extends javax.vecmath.Vector3d {
    private static final long serialVersionUID = 1878117798187075166L;
    public static final Vector3d ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Vector3d UNITY = new Vector3d(1.0, 1.0, 1.0);
    public static final Vector3d X_ONE = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d Y_ONE = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d Z_ONE = new Vector3d(0.0, 0.0, 1.0);

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public static Vector3d xy(double x, double y) {
        return new Vector3d(x, y);
    }

    public static Vector3d xyz(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    public Vector3d clone() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vector3d negated() {
        return new Vector3d(-this.x, -this.y, -this.z);
    }

    public Vector3d plus(Vector3d v) {
        return new Vector3d(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3d minus(Vector3d v) {
        return new Vector3d(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3d times(double a) {
        return new Vector3d(this.x * a, this.y * a, this.z * a);
    }

    public Vector3d times(Vector3d a) {
        return new Vector3d(this.x * a.x, this.y * a.y, this.z * a.z);
    }

    public Vector3d dividedBy(double a) {
        return new Vector3d(this.x / a, this.y / a, this.z / a);
    }

    public double dot(Vector3d a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public Vector3d lerp(Vector3d a, double t) {
        return this.plus(a.minus(this).times(t));
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    double magnitudeSq() {
        return this.dot(this);
    }

    public Vector3d normalized() {
        return this.dividedBy(this.magnitude());
    }

    public Vector3d cross(Vector3d a) {
        return new Vector3d(this.y * a.z - this.z * a.y, this.z * a.x - this.x * a.z, this.x * a.y - this.y * a.x);
    }

    public String toStlString() {
        return this.toStlString(new StringBuilder()).toString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        return sb.append(this.x).append(" ").append(this.y).append(" ").append(this.z);
    }

    public String toObjString() {
        return this.toObjString(new StringBuilder()).toString();
    }

    public StringBuilder toObjString(StringBuilder sb) {
        return sb.append(this.x).append(" ").append(this.y).append(" ").append(this.z);
    }

    public Vector3d transform(Transform transform) {
        return transform.transform(this);
    }

    public Vector3d transformed(Transform transform) {
        return this.clone().transform(transform);
    }

    public Vector3d transform(Transform transform, double amount) {
        return transform.transform(this, amount);
    }

    public Vector3d transformed(Transform transform, double amount) {
        return this.clone().transform(transform, amount);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Vector3d other = (Vector3d)((Object)obj);
        if (Math.abs(this.x - other.x) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.y - other.y) > 1.0E-6) {
            return false;
        }
        return !(Math.abs(this.z - other.z) > 1.0E-6);
    }

    public double angle(Vector3d v) {
        double val = this.dot(v) / (this.magnitude() * v.magnitude());
        return Math.acos(Math.max(Math.min(val, 1.0), -1.0));
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public static Vector3d x(double x) {
        return new Vector3d(x, 0.0, 0.0);
    }

    public static Vector3d y(double y) {
        return new Vector3d(0.0, y, 0.0);
    }

    public static Vector3d z(double z) {
        return new Vector3d(0.0, 0.0, z);
    }

    public Vector3d orthogonal() {
        double o1 = 0.0;
        double o2 = 0.0;
        double o3 = 0.0;
        Random r = new Random();
        int numberOfZeroEntries = 0;
        if (this.x == 0.0) {
            ++numberOfZeroEntries;
            o1 = r.nextDouble();
        }
        if (this.y == 0.0) {
            ++numberOfZeroEntries;
            o2 = r.nextDouble();
        }
        if (this.z == 0.0) {
            ++numberOfZeroEntries;
            o3 = r.nextDouble();
        }
        switch (numberOfZeroEntries) {
            case 0: {
                while (o3 == 0.0) {
                    o3 = r.nextDouble();
                }
                while (o2 == 0.0) {
                    o2 = r.nextDouble();
                }
                o1 = (-this.y * o2 - this.z * o3) / this.x;
                break;
            }
            case 1: {
                if (this.x == 0.0) {
                    while (o3 == 0.0) {
                        o3 = r.nextDouble();
                    }
                    o2 = -this.z * o3 / this.y;
                    break;
                }
                if (this.y == 0.0) {
                    while (o3 == 0.0) {
                        o3 = r.nextDouble();
                    }
                    o1 = -this.z * o3 / this.x;
                    break;
                }
                if (this.z != 0.0) break;
                while (o1 == 0.0) {
                    o1 = r.nextDouble();
                }
                o2 = -this.z * o1 / this.y;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                System.err.println("This vector is equal to (0,0,0). ");
            }
            default: {
                System.err.println("The orthogonal one is set randomly.");
                o1 = r.nextDouble();
                o2 = r.nextDouble();
                o3 = r.nextDouble();
            }
        }
        Vector3d result = new Vector3d(o1, o2, o3);
        while (this.dot(result) != 0.0) {
            result = this.orthogonal();
        }
        return result;
    }
}

