/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;

public class BatteryHolder {
    private double mountingThickness = 3.0;
    private double boardToBoardSpacing = 30.0;
    private double connectorDepth = 25.0;
    private double pegHeight = 1.0;
    private double pegToothHeight = 0.3;
    private double pegOverlap = 0.6;
    private double boardMountingWidth = 8.11;
    private double batteryHeight = 22.0;
    private double batteryLength = 54.0;
    private double footHeight = 25.0;
    private double footSize = 10.0;

    public CSG toCSG() {
        double th = 3.0;
        double smh = this.boardMountingWidth;
        double mth = this.mountingThickness;
        double pth = this.pegToothHeight;
        double ph = this.pegHeight;
        double po = this.pegOverlap;
        double o = 13.0;
        return Extrude.points(new Vector3d(0.0, 0.0, this.connectorDepth), new Vector3d(-th, -th), new Vector3d(smh + pth + ph + o, -th), new Vector3d(smh + pth + Math.max(ph / 3.0, 0.4) + o, 0.0 + po), new Vector3d(smh + pth + o, 0.0 + po), new Vector3d(smh + o, 0.0), new Vector3d(0.0 + o, 0.0), new Vector3d(0.0 + o, mth), new Vector3d(smh + o, mth), new Vector3d(smh + o, mth + th), new Vector3d(0.0, mth + th), new Vector3d(0.0, mth + th + this.batteryHeight), new Vector3d(this.batteryLength, mth + th + this.batteryHeight), new Vector3d(this.batteryLength, mth + th + this.batteryHeight * 0.3), new Vector3d(this.batteryLength + th, mth + th + this.batteryHeight * 0.3), new Vector3d(this.batteryLength + th, mth + th + this.batteryHeight + th), new Vector3d(0.0, mth + th + this.batteryHeight + th), new Vector3d(0.0, mth + th + this.batteryHeight + th + this.footHeight - th * 2.0), new Vector3d(this.footSize, mth + th + this.batteryHeight + th + this.footHeight - th), new Vector3d(this.footSize, mth + th + this.batteryHeight + th + this.footHeight), new Vector3d(-th, mth + th + this.batteryHeight + th + this.footHeight));
    }

    public static void main(String[] args) throws IOException {
        BatteryHolder arConnect = new BatteryHolder();
        FileUtil.write(Paths.get("battery-holder.stl", new String[0]), arConnect.toCSG().toStlString());
    }
}

