/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.samples.ArduinoMount;
import java.io.IOException;
import java.nio.file.Paths;

public class BreadBoardMount {
    private double breadBoardWidth = 84.0;
    private double breadboardLength = 54.0;
    private double breadBoardHeight = 8.5;
    private double pinRadius = 5.0;
    private double pinHeight = 14.0;
    private double pinHoleHeight = 10.0;
    private double bottomThickness = 2.0;
    private double servoConnectThickness = 7.0;

    private CSG board() {
        return new Cube(Vector3d.ZERO, new Vector3d(this.breadBoardWidth, this.breadboardLength, this.breadBoardHeight)).toCSG();
    }

    private CSG pins() {
        CSG prototype = new Cylinder(this.pinRadius, this.pinHeight, 16).toCSG();
        CSG first = prototype.clone().transformed(Transform.unity().translate(this.breadBoardWidth / 2.0, this.breadBoardHeight / 2.0, 0.0));
        CSG second = prototype.clone().transformed(Transform.unity().translate(this.breadBoardWidth / 2.0, -this.breadBoardHeight / 2.0, 0.0));
        CSG third = prototype.clone().transformed(Transform.unity().translate(-this.breadBoardWidth / 2.0 - 1.0, 0.0, 0.0));
        CSG pins = first.union(second).union(third);
        CSG board = this.board().transformed(Transform.unity().translateZ(this.pinHoleHeight * 2.0));
        return pins.difference(board);
    }

    private CSG pinConnections() {
        CSG first = new Cube(Vector3d.ZERO, new Vector3d(this.breadBoardWidth / 2.0, 3.0, this.bottomThickness)).toCSG().transformed(Transform.unity().translate(-this.breadBoardWidth / 4.0, 0.0, this.bottomThickness / 2.0));
        CSG second = new Cube(Vector3d.ZERO, new Vector3d(this.breadBoardWidth / 2.0 + 10.0, 3.0, this.bottomThickness)).toCSG().transformed(Transform.unity().rotZ(37.8).translate(this.breadBoardWidth / 4.0 + 5.0, 0.0, this.bottomThickness / 2.0));
        CSG third = new Cube(Vector3d.ZERO, new Vector3d(this.breadBoardWidth / 2.0 + 10.0, 3.0, this.bottomThickness)).toCSG().transformed(Transform.unity().rotZ(-37.8).translate(this.breadBoardWidth / 4.0 + 5.0, 0.0, this.bottomThickness / 2.0));
        return first.union(second).union(third);
    }

    private CSG servoConnect() {
        CSG firstA = new Cube(Vector3d.ZERO, new Vector3d(this.breadBoardWidth, this.servoConnectThickness, this.bottomThickness)).toCSG().transformed(Transform.unity().translate(0.0, -this.breadBoardHeight / 2.0, this.bottomThickness / 2.0));
        CSG firstB = new Cube(Vector3d.ZERO, new Vector3d(3.0, this.breadBoardHeight / 2.0 + this.servoConnectThickness / 2.0, this.bottomThickness)).toCSG().transformed(Transform.unity().translate(-this.breadBoardWidth / 2.0, -this.breadBoardHeight / 4.0 - this.servoConnectThickness / 4.0, this.bottomThickness / 2.0));
        CSG first = firstA.union(firstB);
        CSG second = first.transformed(Transform.unity().rotX(180.0).translateZ(-this.bottomThickness));
        return first.union(second);
    }

    public CSG toCSG() {
        return this.pins().union(this.pinConnections()).union(this.servoConnect());
    }

    public static void main(String[] args) throws IOException {
        ArduinoMount aMount = new ArduinoMount();
        FileUtil.write(Paths.get("bread-board-mount.stl", new String[0]), aMount.toCSG().toStlString());
    }
}

