/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.UnityModifier;
import eu.mihosoft.vrl.v3d.WeightFunction;
import java.io.IOException;
import java.nio.file.Paths;

public class WeightedTubeSample {
    public CSG toCSG() {
        WeightFunction weight = (v, csg) -> {
            double w = Math.max(1.0, (0.1 + Math.random()) / (v.z * 0.1 + 0.1));
            return w;
        };
        CSG protoOuter = new Cylinder(1.0, 1.0, 16).toCSG();
        CSG protoInner = new Cylinder(0.5, 1.0, 16).toCSG();
        CSG outer = protoOuter;
        CSG inner = protoInner;
        for (int i = 0; i < 50; ++i) {
            outer = outer.union(protoOuter.transformed(Transform.unity().translateZ((double)i / 5.0)));
            inner = inner.union(protoInner.transformed(Transform.unity().translateZ((double)i / 5.0)));
        }
        Transform scale = Transform.unity().scale(2.0, 2.0, 1.0);
        Transform scaleInner = Transform.unity().scale(1.5, 1.5, 1.0);
        inner = inner.weighted(weight).transformed(scaleInner).weighted(new UnityModifier());
        return outer.weighted(weight).transformed(scale).difference(inner);
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("weighted-tube.stl", new String[0]), new WeightedTubeSample().toCSG().toStlString());
    }
}

