/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.STL;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class DualMaterialRobot {
    private static CSG robot;

    public static CSG middleToCSG() throws IOException {
        if (robot == null) {
            robot = STL.file(Paths.get("/home/miho/CuraExamples/UltimakerRobot_support.stl", new String[0]));
        }
        Bounds robotBounds = robot.getBounds();
        CSG middle = robotBounds.toCSG().transformed(Transform.unity().scaleZ(0.5).translateZ(robotBounds.getBounds().z / 3.0));
        return robot.intersect(middle);
    }

    public static CSG topBottomCSG() throws IOException {
        if (robot == null) {
            robot = STL.file(Paths.get("/home/miho/CuraExamples/UltimakerRobot_support.stl", new String[0]));
        }
        Bounds robotBounds = robot.getBounds();
        CSG middle = robotBounds.toCSG().transformed(Transform.unity().scaleZ(0.5).translateZ(robotBounds.getBounds().z / 3.0));
        return robot.difference(middle);
    }

    public static void main(String[] args) throws IOException {
        robot = STL.file(Paths.get("/home/miho/CuraExamples/UltimakerRobot_support.stl", new String[0]));
        FileUtil.write(Paths.get("robot-ascii.stl", new String[0]), robot.toStlString());
    }
}

