/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.samples.PolyMailTile;
import java.io.IOException;
import java.nio.file.Paths;

public class HexaMail {
    public CSG toCSG(int numEdges, int numX, int numY) {
        PolyMailTile tile = new PolyMailTile().setNumEdges(numEdges).setHingeHoleScale(1.2);
        double hingeHoleScale = tile.getHingeHoleScale();
        CSG malePart = tile.setCombined().toCSG();
        CSG femalePart = tile.setCombined().toCSG();
        CSG result = null;
        for (int y = 0; y < numY; ++y) {
            for (int x = 0; x < numX; ++x) {
                double pinOffset = tile.getPinLength() - (tile.getJointRadius() * hingeHoleScale - tile.getJointRadius());
                double xOffset = 0.0;
                double yOffset = pinOffset * 0.9;
                if (y % 2 == 0) {
                    xOffset = tile.getApothem() + pinOffset * 0.5;
                }
                double translateX = (-tile.getApothem() * 2.0 - pinOffset) * (double)x + xOffset;
                double translateY = (-tile.getRadius() * 0.5 - tile.getRadius()) * (double)y - yOffset * (double)y;
                CSG part2 = x % 2 == 0 ? femalePart.clone() : malePart.clone();
                if (numEdges % 2 != 0) {
                    part2 = part2.transformed(Transform.unity().rotZ(360.0 / (double)numEdges * 0.5));
                }
                part2 = part2.transformed(Transform.unity().translate(translateX, translateY, 0.0));
                if (result == null) {
                    result = part2.clone();
                }
                result = result.dumbUnion(part2);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("hexamail.stl", new String[0]), new HexaMail().toCSG(6, 3, 3).toStlString());
    }
}

