/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class Hinge {
    private double jointLength = 10.0;
    private double jointRadius = 5.0;
    private double coneLength = 5.0;
    private double jointHoleLength = 5.0;
    private double jointConnectionThickness = this.jointRadius * 0.5;
    private int resolution = 16;

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("hinge.stl", new String[0]), new Hinge().toCSG().toStlString());
    }

    public CSG toCSG() {
        CSG sideConeR = new Cylinder(this.getJointRadius(), 0.0, this.getConeLength(), this.getResolution()).toCSG().transformed(Transform.unity().translateZ(this.getJointLength() * 0.5));
        CSG sideConeL = new Cylinder(this.getJointRadius(), 0.0, this.getConeLength(), this.getResolution()).toCSG().transformed(Transform.unity().translateZ(-this.getJointLength() * 0.5).rotX(180.0));
        CSG sideCones = sideConeL.union(sideConeR);
        CSG conesAndCyl = sideCones.hull();
        CSG cylinderHole = new Cube(this.getJointRadius() * 2.0, this.getJointHoleLength() * 2.0, this.getJointHoleLength()).toCSG().transformed(Transform.unity().translate(this.getJointConnectionThickness(), 0.0, -this.getJointHoleLength() * 0.0));
        CSG joint = conesAndCyl.difference(cylinderHole);
        return joint;
    }

    public Hinge setJointLength(double jointLength) {
        this.jointLength = jointLength;
        return this;
    }

    public Hinge setJointRadius(double jointRadius) {
        this.jointRadius = jointRadius;
        return this;
    }

    public Hinge setConeLength(double coneLength) {
        this.coneLength = coneLength;
        return this;
    }

    public Hinge setJointHoleLength(double jointHoleLength) {
        this.jointHoleLength = jointHoleLength;
        return this;
    }

    public Hinge setJointConnectionThickness(double jointConnectionThickness) {
        this.jointConnectionThickness = jointConnectionThickness;
        return this;
    }

    public Hinge setResolution(int resolution) {
        this.resolution = resolution;
        return this;
    }

    public double getJointLength() {
        return this.jointLength;
    }

    public double getJointRadius() {
        return this.jointRadius;
    }

    public double getConeLength() {
        return this.coneLength;
    }

    public double getJointHoleLength() {
        return this.jointHoleLength;
    }

    public double getJointConnectionThickness() {
        return this.jointConnectionThickness;
    }

    public int getResolution() {
        return this.resolution;
    }
}

