/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.UnityModifier;
import eu.mihosoft.vrl.v3d.WeightFunction;
import eu.mihosoft.vrl.v3d.samples.QuadrocopterArm;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterLadingGears {
    public static void main(String[] args) throws IOException {
        QuadrocopterLadingGears moebiusStairs = new QuadrocopterLadingGears();
        CSG csg = moebiusStairs.toCSG();
        FileUtil.write(Paths.get("quadcopter-landing-gear.stl", new String[0]), csg.toStlString());
        csg.toObj().toFiles(Paths.get("quadcopter-landing-gear.obj", new String[0]));
    }

    private CSG toCSG() {
        double armThickness = 18.0;
        double armShrinkFactor = 0.64;
        double gearHeadHeight = 18.0;
        double gearWidth = 16.0;
        double gearDepth = 20.0;
        double armInset = 6.0;
        CSG arm = QuadrocopterArm.outerCyl(armThickness / 2.0, gearDepth, 0.0, armShrinkFactor, 0.0, true);
        arm = arm.transformed(Transform.unity().translateY(armInset));
        CSG landingGearHead = new Cube(gearWidth, gearHeadHeight, gearDepth).toCSG();
        Transform lgOrigin = Transform.unity().translate(0.0, gearHeadHeight / 2.0, gearDepth / 2.0);
        landingGearHead = landingGearHead.transformed(lgOrigin);
        landingGearHead = landingGearHead.difference(arm);
        double gearLegHeight = 120.0;
        int legResolution = 10;
        CSG legPrototype = new Cube(gearDepth, gearLegHeight / (double)legResolution, gearWidth).noCenter().toCSG().transformed(Transform.unity().translate(0.0, gearHeadHeight, -gearWidth / 2.0));
        CSG leg = legPrototype.clone();
        double dH = gearLegHeight / (double)legResolution;
        for (int i = 1; i < legResolution; ++i) {
            leg = leg.union(legPrototype.transformed(Transform.unity().translateY((double)i * dH)));
        }
        WeightFunction translateWeight = (v, csg) -> {
            if (v.y < 2.0 * dH) {
                return 0.0;
            }
            double val = 0.9 + v.y * v.y / (gearLegHeight * gearLegHeight + gearLegHeight * 10.0);
            return val;
        };
        leg = leg.weighted(translateWeight).transformed(Transform.unity().scale(0.6, 1.0, 0.6)).weighted(new UnityModifier()).transformed(Transform.unity().rotY(90.0));
        return leg.union(landingGearHead);
    }
}

