/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.samples.QuadrocopterArmHolder;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterPlatform {
    public static void main(String[] args) throws IOException {
        CSG result = new QuadrocopterPlatform().toCSG();
        FileUtil.write(Paths.get("quadrocopter-platform.stl", new String[0]), result.toStlString());
        result.toObj().toFiles(Paths.get("quadrocopter-platform.obj", new String[0]));
    }

    private CSG toCSG() {
        double platformRadius = 84.0;
        double platformThickness = 3.0;
        double platformBorderThickness = 4.0;
        int numHoneycombs = 17;
        double honeycombWallThickness = 1.0;
        CSG platform = this.basePlatform(platformRadius, numHoneycombs, platformThickness, platformBorderThickness, honeycombWallThickness);
        double armHeight = 25.0;
        double armScaleFactor = 0.5;
        double armCubeWidth = armHeight;
        double armCubeThickness = 4.0;
        double holderPlatformRadius = 20.0;
        CSG armHolderPrototype = new QuadrocopterArmHolder().toCSG(armHeight, armScaleFactor, armCubeWidth, armCubeThickness, holderPlatformRadius, platformThickness).transformed(Transform.unity().translateX(-platformRadius));
        CSG armHolders = armHolderPrototype.clone();
        for (int i = 1; i < 4; ++i) {
            armHolders = armHolders.union(armHolderPrototype.transformed(Transform.unity().rotZ(i * 90)));
        }
        CSG cross = new Cube(platformRadius * 2.0, platformBorderThickness, platformThickness).toCSG().transformed(Transform.unity().translateZ(platformThickness / 2.0));
        cross = cross.union(cross.transformed(Transform.unity().rotZ(90.0)));
        platform = platform.union(armHolders, cross);
        return platform;
    }

    private CSG basePlatform(double platformRadius, int numHoneycombs, double platformThickness, double platformBorderThickness, double honeycombWallThickness) {
        double honeycombRadius = platformRadius / (double)numHoneycombs;
        CSG platform = new Cylinder(platformRadius, platformThickness, 64).toCSG();
        CSG innerPlatform = new Cylinder(platformRadius - platformBorderThickness, platformThickness, 64).toCSG();
        CSG platformShell = platform.difference(innerPlatform);
        CSG honeycombPrototype = new Cylinder(honeycombRadius, platformThickness, 6).toCSG();
        int numHoneycomb = (int)(platformRadius * 2.0 / (honeycombRadius * 2.0));
        CSG hexagons = null;
        double inradiusOfHexagon = honeycombRadius * Math.cos(0.5235987755982988);
        double sideLength = honeycombRadius * 2.0 * Math.sin(0.5235987755982988);
        numHoneycomb = (int)((double)numHoneycomb * 1.4);
        double centerOffset = 0.0;
        for (int y = 0; y < numHoneycomb; ++y) {
            for (int x = 0; x < numHoneycomb; ++x) {
                double offset = inradiusOfHexagon * (double)(x % 2);
                double dx = -platformRadius + (double)x * sideLength * 1.5;
                double dy = -platformRadius + (double)y * inradiusOfHexagon * 2.0 + offset - honeycombWallThickness / 4.0;
                CSG h = honeycombPrototype.transformed(Transform.unity().translate(dx += honeycombWallThickness * (double)x + centerOffset - honeycombWallThickness / 6.0, dy += honeycombWallThickness * (double)y + honeycombWallThickness * (double)(x % 2) / 2.0 + centerOffset * 1.75 - inradiusOfHexagon * 0.5 + honeycombWallThickness / 2.0, 0.0));
                hexagons = hexagons == null ? h : hexagons.union(h);
            }
        }
        if (hexagons != null) {
            platform = platform.difference(hexagons);
        }
        return platform.union(platformShell, honeycombPrototype.transformed(Transform.unity().scale(1.05, 1.05, 1.0)));
    }
}

