/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TPoint;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationPoint;
import java.util.ArrayList;
import java.util.List;

class PointGenerator {
    PointGenerator() {
    }

    public static List<TriangulationPoint> uniformDistribution(int n, double scale) {
        ArrayList<TriangulationPoint> points = new ArrayList<TriangulationPoint>();
        for (int i = 0; i < n; ++i) {
            points.add(new TPoint(scale * (0.5 - Math.random()), scale * (0.5 - Math.random())));
        }
        return points;
    }

    public static List<TriangulationPoint> uniformGrid(int n, double scale) {
        double x = 0.0;
        double size = scale / (double)n;
        double halfScale = 0.5 * scale;
        ArrayList<TriangulationPoint> points = new ArrayList<TriangulationPoint>();
        for (int i = 0; i < n + 1; ++i) {
            x = halfScale - (double)i * size;
            for (int j = 0; j < n + 1; ++j) {
                points.add(new TPoint(x, halfScale - (double)j * size));
            }
        }
        return points;
    }
}

