/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.parametrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.mihosoft.vrl.v3d.parametrics.IParameterChanged;
import eu.mihosoft.vrl.v3d.parametrics.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CSGDatabase {
    private static HashMap<String, Parameter> database = null;
    private static File dbFile = new File("CSGdatabase.json");
    private static final Type TT_mapStringString = new TypeToken<HashMap<String, Parameter>>(){}.getType();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final HashMap<String, ArrayList<IParameterChanged>> parameterListeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(String key, Parameter value) {
        CSGDatabase.getDatabase();
        HashMap<String, Parameter> hashMap = database;
        synchronized (hashMap) {
            CSGDatabase.getDatabase().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter get(String key) {
        Parameter ret = null;
        CSGDatabase.getDatabase();
        HashMap<String, Parameter> hashMap = database;
        synchronized (hashMap) {
            ret = CSGDatabase.getDatabase().get(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        CSGDatabase.getDatabase();
        HashMap<String, Parameter> hashMap = database;
        synchronized (hashMap) {
            database.clear();
        }
        parameterListeners.clear();
        CSGDatabase.saveDatabase();
    }

    public static void addParameterListener(String key, IParameterChanged l) {
        ArrayList<IParameterChanged> list = CSGDatabase.getParamListeners(key);
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    public static void removeParameterListener(String key, IParameterChanged l) {
        if (parameterListeners.get(key) == null) {
            return;
        }
        ArrayList<IParameterChanged> list = parameterListeners.get(key);
        if (list.contains(l)) {
            list.remove(l);
        }
    }

    public static ArrayList<IParameterChanged> getParamListeners(String key) {
        if (parameterListeners.get(key) == null) {
            parameterListeners.put(key, new ArrayList());
        }
        return parameterListeners.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String key) {
        HashMap<String, Parameter> hashMap = database;
        synchronized (hashMap) {
            CSGDatabase.getDatabase().remove(key);
        }
    }

    private static HashMap<String, Parameter> getDatabase() {
        if (database == null) {
            new Thread(){

                @Override
                public void run() {
                    block7: {
                        try {
                            String jsonString;
                            if (!CSGDatabase.getDbFile().exists()) {
                                CSGDatabase.setDatabase(new HashMap());
                                break block7;
                            }
                            FileInputStream in = null;
                            try {
                                in = FileUtils.openInputStream((File)CSGDatabase.getDbFile());
                                jsonString = IOUtils.toString((InputStream)in);
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)in);
                            }
                            HashMap tm = (HashMap)gson.fromJson(jsonString, TT_mapStringString);
                            if (tm != null) {
                                CSGDatabase.setDatabase(tm);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println(dbFile.getAbsolutePath());
                            CSGDatabase.setDatabase(new HashMap());
                        }
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            CSGDatabase.saveDatabase();
                        }
                    });
                }
            }.start();
            long start = System.currentTimeMillis();
            while (database == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (System.currentTimeMillis() - start <= 500L) continue;
                CSGDatabase.setDatabase(new HashMap<String, Parameter>());
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDatabaseFromFile(File f) {
        FileInputStream in = null;
        try {
            try {
                in = FileUtils.openInputStream((File)f);
                String jsonString = IOUtils.toString((InputStream)in);
                HashMap tm = (HashMap)gson.fromJson(jsonString, TT_mapStringString);
                if (tm != null) {
                    for (String k : tm.keySet()) {
                        CSGDatabase.set(k, (Parameter)tm.get(k));
                    }
                }
                CSGDatabase.saveDatabase();
            }
            catch (Exception e) {
                System.err.println(f.getAbsolutePath());
                e.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataBaseString() {
        String writeOut = null;
        CSGDatabase.getDatabase();
        HashMap<String, Parameter> hashMap = database;
        synchronized (hashMap) {
            writeOut = gson.toJson(database, TT_mapStringString);
        }
        return writeOut;
    }

    public static void saveDatabase() {
        String writeOut = CSGDatabase.getDataBaseString();
        try {
            if (!CSGDatabase.getDbFile().exists()) {
                CSGDatabase.getDbFile().createNewFile();
            }
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)CSGDatabase.getDbFile(), (boolean)false);
                IOUtils.write((String)writeOut, (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setDatabase(HashMap<String, Parameter> database) {
        if (CSGDatabase.database != null) {
            return;
        }
        CSGDatabase.database = database;
    }

    public static File getDbFile() {
        return dbFile;
    }

    public static void setDbFile(File dbFile) {
        if (!dbFile.exists()) {
            try {
                dbFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            CSGDatabase.loadDatabaseFromFile(dbFile);
        }
        CSGDatabase.dbFile = dbFile;
    }
}

