/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.samples.Hinge;
import eu.mihosoft.vrl.v3d.samples.TileType;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;

public class PolyMailTile {
    private TileType tileType = TileType.MALE;
    private double radius = 10.0;
    private double thickness = 2.2;
    private double jointRadius = 1.1;
    private double coneLength = 1.8;
    private double hingeHoleScale = 1.16;
    private double pinLength = 1.0;
    private double pinThickness = 2.0;
    private int numEdges = 3;

    public CSG toCSG() {
        double step = 360.0 / (double)this.numEdges;
        double initialRot = step * 0.5;
        CSG mainPrism = new Cylinder(this.getRadius(), this.getThickness(), this.numEdges).toCSG().transformed(Transform.unity().translateZ(-this.getThickness() * 0.5).rotZ(initialRot));
        Hinge hingePrototype = new Hinge().setJointRadius(this.getJointRadius()).setJointLength(this.getPinThickness()).setConeLength(this.getConeLength());
        hingePrototype.setJointConnectionThickness(hingePrototype.getJointRadius() * 2.0);
        CSG hinge1 = hingePrototype.toCSG();
        Vector3d hingeBounds = hinge1.getBounds().getBounds();
        hinge1 = hinge1.intersect(new Cube(hingeBounds.x, Math.min(hingeBounds.y, this.getThickness()), hingeBounds.z).toCSG());
        hinge1 = hinge1.transformed(Transform.unity().rotX(90.0));
        CSG pin = new Cube(this.getPinLength() + hingePrototype.getJointRadius(), this.getPinThickness(), this.getThickness()).toCSG().transformed(Transform.unity().translateX(-(this.jointRadius + this.pinLength) * 0.5));
        hinge1 = hinge1.union(pin);
        double apothem = this.getApothem();
        hinge1 = hinge1.transformed(Transform.unity().translateX(apothem + hingePrototype.getJointRadius() + this.getPinLength()));
        ArrayList<CSG> hinges = new ArrayList<CSG>();
        hinges.add(hinge1);
        for (int i = 1; i < this.numEdges; ++i) {
            CSG hinge = hinge1.transformed(Transform.unity().rotZ((double)i * step));
            hinges.add(hinge);
        }
        CSG hingeHole1 = hinge1.transformed(Transform.unity().translateX(-apothem - hingePrototype.getJointRadius() - this.getPinLength()));
        hingeHole1 = hingeHole1.transformed(Transform.unity().scale(this.getHingeHoleScale()));
        hingeHole1 = hingeHole1.transformed(Transform.unity().translateX(-apothem + this.getJointRadius() * this.getHingeHoleScale()));
        if (this.numEdges % 2 != 0) {
            hingeHole1 = hingeHole1.transformed(Transform.unity().rotZ(initialRot));
        }
        ArrayList<CSG> hingeHoles = new ArrayList<CSG>();
        hingeHoles.add(hingeHole1);
        for (int i = 1; i < this.numEdges; ++i) {
            CSG hole = hingeHole1.transformed(Transform.unity().rotZ((double)i * step));
            hingeHoles.add(hole);
        }
        CSG malePart = mainPrism.union(hinges);
        CSG femalePart = mainPrism.difference(hingeHoles);
        CSG combinedPart = mainPrism.clone();
        for (int i = 0; i < this.numEdges; ++i) {
            combinedPart = i % 2 == 0 ? combinedPart.union((CSG)hinges.get(i)) : combinedPart.difference(((CSG)hingeHoles.get(i)).transformed(Transform.unity().rotZ(step)));
        }
        if (this.numEdges % 2 != 0 && this.isCombined()) {
            throw new IllegalArgumentException("Combined type can only be used for even edge numbers.");
        }
        if (this.isMale()) {
            return malePart;
        }
        if (this.isFemale()) {
            return femalePart;
        }
        if (this.isCombined()) {
            return combinedPart;
        }
        return mainPrism;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("triangularmail.stl", new String[0]), new PolyMailTile().setNumEdges(6).setCombined().toCSG().toStlString());
    }

    public boolean isMale() {
        return this.tileType == TileType.MALE;
    }

    public boolean isFemale() {
        return this.tileType == TileType.FEMALE;
    }

    public boolean isCombined() {
        return this.tileType == TileType.COMBINED;
    }

    public PolyMailTile setMale() {
        this.tileType = TileType.MALE;
        return this;
    }

    public PolyMailTile setFemale() {
        this.tileType = TileType.FEMALE;
        return this;
    }

    public PolyMailTile setCombined() {
        this.tileType = TileType.COMBINED;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public PolyMailTile setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public double getThickness() {
        return this.thickness;
    }

    public PolyMailTile setThickness(double thickness) {
        this.thickness = thickness;
        return this;
    }

    public double getJointRadius() {
        return this.jointRadius;
    }

    public PolyMailTile setJointRadius(double jointRadius) {
        this.jointRadius = jointRadius;
        return this;
    }

    public double getConeLength() {
        return this.coneLength;
    }

    public PolyMailTile setConeLength(double coneLength) {
        this.coneLength = coneLength;
        return this;
    }

    public double getHingeHoleScale() {
        return this.hingeHoleScale;
    }

    public PolyMailTile setHingeHoleScale(double hingeHoleScale) {
        this.hingeHoleScale = hingeHoleScale;
        return this;
    }

    public double getPinLength() {
        return this.pinLength;
    }

    public PolyMailTile setPinLength(double pinLength) {
        this.pinLength = pinLength;
        return this;
    }

    public double getPinThickness() {
        return this.pinThickness;
    }

    public PolyMailTile setPinThickness(double pinThickness) {
        this.pinThickness = pinThickness;
        return this;
    }

    public PolyMailTile setNumEdges(int numEdges) {
        this.numEdges = numEdges;
        return this;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public double getSideLength() {
        return 2.0 * this.radius * Math.sin(Math.toRadians(180.0 / (double)this.numEdges));
    }

    public double getApothem() {
        return this.getRadius() * Math.cos(Math.toRadians(180.0 / (double)this.numEdges));
    }
}

