/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class Spheres {
    public CSG toCSG() {
        double maxR = 10.0;
        double w = 30.0;
        double h = 30.0;
        double d = 30.0;
        CSG.setDefaultOptType(CSG.OptType.POLYGON_BOUND);
        CSG spheres = null;
        for (int i = 0; i < 70; ++i) {
            CSG s = new Sphere(Math.random() * maxR).toCSG().transformed(Transform.unity().translate(Math.random() * w, Math.random() * h, Math.random() * d));
            spheres = spheres == null ? s : spheres.union(s);
        }
        return spheres;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("spheres.stl", new String[0]), new Spheres().toCSG().toStlString());
    }
}

