/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.UnityModifier;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.WeightFunction;
import eu.mihosoft.vrl.v3d.samples.QuadrocopterArm;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterLadingGearsAndHolders {
    public static void main(String[] args) throws IOException {
        QuadrocopterLadingGearsAndHolders ladingGearsAndHolders = new QuadrocopterLadingGearsAndHolders();
        CSG csg = ladingGearsAndHolders.toCSG();
        FileUtil.write(Paths.get("quadcopter-landing-gear-and-holder.stl", new String[0]), csg.toStlString());
        csg.toObj().toFiles(Paths.get("quadcopter-landing-gear-and-holder.obj", new String[0]));
    }

    private CSG toCSG() {
        double armThickness = 18.0;
        double armShrinkFactor = 0.64;
        double gearHeadHeight = 18.0;
        double gearWidth = 16.0;
        double gearDepth = 30.0;
        double armInset = 6.0;
        double platformInsertionDepth = 4.0;
        double platformThickness = 3.0;
        double platformSpaceTop = 50.0;
        double platformSpaceInner = 50.0;
        CSG platformReplacement = this.bottomReplacementShape(platformThickness, gearWidth, platformInsertionDepth);
        CSG arm = QuadrocopterArm.outerCyl(armThickness / 2.0, gearDepth, 0.0, armShrinkFactor, 0.0, true);
        arm = arm.transformed(Transform.unity().translateY(armInset));
        CSG landingGearHead = new Cube(gearWidth, gearHeadHeight, gearDepth).toCSG();
        Transform lgOrigin = Transform.unity().translate(0.0, gearHeadHeight / 2.0, gearDepth / 2.0);
        landingGearHead = landingGearHead.transformed(lgOrigin);
        landingGearHead = landingGearHead.difference(arm);
        double gearLegHeight = 150.0;
        int legResolution = 16;
        CSG legPrototype = new Cube(gearDepth, gearLegHeight / (double)legResolution, gearWidth).noCenter().toCSG().transformed(Transform.unity().translate(0.0, gearHeadHeight, -gearWidth / 2.0));
        CSG leg = legPrototype.clone();
        double dH = gearLegHeight / (double)legResolution;
        for (int i = 1; i < legResolution; ++i) {
            leg = leg.union(legPrototype.transformed(Transform.unity().translateY((double)i * dH)));
        }
        WeightFunction translateWeight = (v, csg) -> {
            if (v.y < 2.0 * dH) {
                return 0.0;
            }
            double val = 0.82 + v.y * v.y / (gearLegHeight * gearLegHeight);
            return val;
        };
        leg = leg.weighted(translateWeight).transformed(Transform.unity().scale(0.6, 1.0, 0.6)).weighted(new UnityModifier()).transformed(Transform.unity().rotY(90.0));
        return leg.union(landingGearHead).difference(platformReplacement.transformed(Transform.unity().translateY(gearHeadHeight + platformSpaceTop)), platformReplacement.transformed(Transform.unity().translateY(gearHeadHeight + platformSpaceTop + platformSpaceInner)));
    }

    private CSG bottomReplacementShape(double bottomThickness, double landingGearWidth, double depth) {
        Vector3d height = Vector3d.z(landingGearWidth);
        double th = bottomThickness;
        double d = depth;
        double t = th;
        return Extrude.points(height, Vector3d.ZERO, Vector3d.xy(0.0, th), Vector3d.xy(-d, th), Vector3d.xy(-d - t, th * 0.5), Vector3d.xy(-d, 0.0)).transformed(Transform.unity().rotY(270.0)).transformed(Transform.unity().translateX(-landingGearWidth * 0.5));
    }
}

