/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.svg;

import com.piro.bezier.BezierPath;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.svg.ISVGLoadProgress;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.scene.paint.Color;
import javax.vecmath.Matrix4d;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMImageElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGLoad {
    private static final String PATH_ELEMENT_NAME = "path";
    private static final String GROUP_ELEMENT_NAME = "g";
    private Document svgDocument;
    boolean hp = true;
    private ArrayList<CSG> sections = null;
    private ArrayList<CSG> holes = null;
    private List<Polygon> polygons = null;
    private ISVGLoadProgress progress = null;
    private double thickness;
    private boolean negativeThickness = false;
    private double height = 0.0;
    private double width = 0.0;
    private Double scale = null;
    private HashMap<String, Double> units = new HashMap();
    private static ISVGLoadProgress progressDefault = new ISVGLoadProgress(){

        @Override
        public void onShape(CSG newShape) {
        }
    };

    private double toPx(String value) {
        for (String key : this.units.keySet()) {
            if (!value.endsWith(key)) continue;
            String[] split = value.split(key);
            if (key.contentEquals("m") && split.length > 1) break;
            return Double.parseDouble(split[0]) / this.units.get(key);
        }
        return Double.parseDouble(value);
    }

    private void setScale(double value) {
        this.scale = value;
        this.units.put("mm", 1.0 / this.getScale());
        this.units.put("px", 1.0);
        this.units.put("cm", this.units.get("mm") / 10.0);
        this.units.put("in", this.units.get("mm") / 25.4);
        this.units.put("ft", this.units.get("in") / 12.0);
        this.units.put("m", this.units.get("mm") / 1000.0);
    }

    private Double getScale() {
        return (double)this.scale;
    }

    private double toMM(String value) {
        Double px = this.toPx(value);
        return px * 1.0 / this.getScale();
    }

    public void setHolePolarity(boolean p) {
        this.hp = p;
    }

    public SVGLoad(URI uri) throws IOException {
        this.setSVGDocument(this.createSVGDocument(uri));
    }

    public SVGLoad(File f) throws IOException {
        this.setSVGDocument(this.createSVGDocument(f.toURI()));
    }

    public SVGLoad(String data) throws IOException {
        File tmpsvg = new File(System.getProperty("java.io.tmpdir") + "/" + Math.random());
        tmpsvg.createNewFile();
        FileWriter fw = new FileWriter(tmpsvg.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(data);
        bw.close();
        this.setSVGDocument(this.createSVGDocument(tmpsvg.toURI()));
        tmpsvg.deleteOnExit();
    }

    public ArrayList<CSG> extrude(double thickness) throws IOException {
        return this.extrude(thickness, 0.005);
    }

    public static ArrayList<CSG> extrude(File f, double thickness) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness);
    }

    public static List<Polygon> toPolygons(File f) throws IOException {
        return new SVGLoad(f.toURI()).toPolygons();
    }

    public List<Polygon> toPolygons(double resolution) {
        if (this.polygons == null) {
            try {
                this.loadAllGroups(resolution, new Transform());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.polygons;
    }

    public List<Polygon> toPolygons() {
        return this.toPolygons(0.001);
    }

    public static ArrayList<CSG> extrude(File f, double thickness, double resolution) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness, resolution);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness) throws IOException {
        return new SVGLoad(uri).extrude(thickness);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness, double resolution) throws IOException {
        return new SVGLoad(uri).extrude(thickness, resolution);
    }

    private void loadAllGroups(double resolution, Transform startingFrame) {
        NodeList pn = this.getSVGDocument().getDocumentElement().getChildNodes();
        try {
            String hval = this.getSVGDocument().getDocumentElement().getAttribute("height");
            String wval = this.getSVGDocument().getDocumentElement().getAttribute("width");
            String viewbox = this.getSVGDocument().getDocumentElement().getAttribute("viewBox");
            double viewW = Double.parseDouble(viewbox.split(" ")[2]);
            this.setScale(1.0);
            this.height = this.toMM(hval);
            this.width = this.toMM(wval);
            double value = viewW / this.width;
            System.out.println("Page size height = " + this.height + " width =" + this.width + " with scale " + (int)(value * 25.4) + " DPI ");
            this.setScale(value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.height = 0.0;
            this.width = 0.0;
            this.setScale(3.543307);
        }
        int pnCount = pn.getLength();
        for (int j = 0; j < pnCount; ++j) {
            if (!SVGOMGElement.class.isInstance(pn.item(j))) continue;
            SVGOMGElement element = (SVGOMGElement)pn.item(j);
            this.loadGroup(element, resolution, startingFrame);
        }
    }

    private void loadGroup(SVGOMGElement element, double resolution, Transform startingFrame) {
        Node transforms = element.getAttributes().getNamedItem("transform");
        Transform newFrame = this.getNewframe(startingFrame, transforms);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (SVGOMGElement.class.isInstance(n)) {
                this.loadGroup((SVGOMGElement)n, resolution, newFrame);
                continue;
            }
            try {
                this.loadPath(n, resolution, newFrame);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private Transform getNewframe(Transform startingFrame, Node transforms) {
        if (transforms == null) {
            return startingFrame;
        }
        Transform newFrame = new Transform().apply(startingFrame);
        String transformValue = transforms.getNodeValue();
        if (transformValue.contains("translate")) {
            String[] transformValues = transformValue.replaceAll("translate", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            newFrame.apply(new Transform().translate(this.toPx(transformValues[0]), this.toPx(transformValues[1]), 0.0));
        } else if (transformValue.contains("scale")) {
            String[] transformValues = transformValue.replaceAll("scale", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            double scalex = this.toPx(transformValues[0]);
            double scaley = this.toPx(transformValues[1]);
            newFrame.scale(scalex, scaley, 1.0);
        } else if (transformValue.contains("matrix")) {
            String[] transformValues = transformValue.replaceAll("matrix", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            double a = this.toPx(transformValues[0]);
            double b = this.toPx(transformValues[1]);
            double c = this.toPx(transformValues[2]);
            double d = this.toPx(transformValues[3]);
            double e = this.toPx(transformValues[4]);
            double f = this.toPx(transformValues[5]);
            double[] elemenents = new double[]{a, c, 0.0, e, b, d, 0.0, f, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            newFrame.apply(new Transform(new Matrix4d(elemenents)));
        }
        return newFrame;
    }

    private void loadPath(Node pathNode, double resolution, Transform startingFrame) {
        if (pathNode != null && pathNode.getAttributes() != null) {
            Node transforms = pathNode.getAttributes().getNamedItem("transform");
            Transform newFrame = this.getNewframe(startingFrame, transforms);
            try {
                if (SVGOMPathElement.class.isInstance(pathNode)) {
                    MetaPostPath2 mpp = new MetaPostPath2(pathNode);
                    String code = mpp.toCode();
                    this.loadComposite(code, resolution, newFrame);
                } else if (SVGOMImageElement.class.isInstance(pathNode)) {
                    SVGOMImageElement image = (SVGOMImageElement)pathNode;
                    double x = this.toPx(image.getAttributes().getNamedItem("x").getNodeValue());
                    double y = this.toPx(image.getAttributes().getNamedItem("y").getNodeValue());
                    double pheight = this.toPx(image.getAttributes().getNamedItem("height").getNodeValue());
                    double pwidth = this.toPx(image.getAttributes().getNamedItem("width").getNodeValue());
                    String[] imageData = null;
                    for (int i = 0; i < image.getAttributes().getLength(); ++i) {
                        Node n = image.getAttributes().item(i);
                        if (!n.getNodeName().contains("href")) continue;
                        try {
                            imageData = n.getNodeValue().split("/");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (ClassCastException ex) {
                System.out.println("Found " + pathNode.getClass());
            }
        }
    }

    private void loadComposite(String code, double resolution, Transform startingFrame) {
        int count = code.length() - code.replace("M", "").length();
        if (count < 2) {
            try {
                this.loadSingle(code, resolution, startingFrame);
            }
            catch (Exception exception) {}
        } else {
            String[] pathParts = code.split("M");
            for (int i = 0; i < pathParts.length; ++i) {
                String sectionedPart = "M" + pathParts[i];
                if (sectionedPart.length() <= 1) continue;
                this.loadSingle(sectionedPart, resolution, startingFrame);
            }
        }
    }

    public static boolean isCCW(Polygon polygon) {
        double runningTotal = 0.0;
        List<Edge> edges = Edge.fromPolygon(polygon);
        for (Edge e : edges) {
            runningTotal += e.getP1().pos.x * e.getP2().pos.y;
            runningTotal -= e.getP2().pos.x * e.getP1().pos.y;
        }
        return runningTotal < 0.0;
    }

    private void loadSingle(String code, double resolution, Transform startingFrame) {
        BezierPath path = new BezierPath();
        path.parsePathString(code);
        ArrayList<Vector3d> p = path.evaluate();
        for (Vector3d point : p) {
            point.transform(startingFrame);
            point.transform(new Transform().scale(1.0 / this.getScale()));
            point.transform(new Transform().translate(0.0, -this.height, 0.0));
            point.transform(new Transform().rotZ(-180.0));
            point.transform(new Transform().rotY(180.0));
        }
        Polygon poly = Polygon.fromPoints(p);
        if (this.polygons == null) {
            this.polygons = new ArrayList<Polygon>();
        }
        boolean hole = SVGLoad.isCCW(poly);
        poly = Polygon.fromPoints(Extrude.toCCW(poly.getPoints()));
        this.polygons.add(poly);
        if (!this.hp) {
            hole = !hole;
        }
        CSG newbit = Extrude.getExtrusionEngine().extrude(new Vector3d(0.0, 0.0, this.thickness), poly);
        if (this.negativeThickness) {
            newbit = newbit.toZMax();
        }
        try {
            if (!hole) {
                this.getSections().add(newbit);
            } else {
                newbit.setColor(Color.RED);
                this.sections.add(newbit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.progress != null) {
            this.progress.onShape(newbit);
        } else {
            progressDefault.onShape(newbit);
        }
    }

    public ArrayList<CSG> extrude(double t, double resolution) throws IOException {
        this.thickness = t;
        if (this.thickness < 0.0) {
            this.thickness = -this.thickness;
            this.negativeThickness = true;
        } else {
            this.negativeThickness = false;
        }
        if (this.getSections() == null) {
            this.setSections(new ArrayList<CSG>());
        }
        if (this.getHoles() == null) {
            this.setHoles(new ArrayList<CSG>());
        }
        this.getSections().clear();
        this.getHoles().clear();
        this.loadAllGroups(resolution, new Transform());
        this.loadExtrusionSectoins();
        return this.getSections();
    }

    private void loadExtrusionSectoins() {
        if (this.getSections().size() == 0 && this.getHoles().size() != 0) {
            this.getSections().addAll(this.getHoles());
            this.getHoles().clear();
        }
        ArrayList<CSG> notHoles = new ArrayList<CSG>();
        for (CSG c : this.holes) {
            boolean touchesSomething = false;
            for (CSG p : this.sections) {
                if (!p.touching(c)) continue;
                touchesSomething = true;
                break;
            }
            if (touchesSomething) continue;
            notHoles.add(c);
        }
        for (CSG c : notHoles) {
            this.holes.remove(c);
            this.sections.add(c);
        }
        if (this.getSections().size() == 0) {
            return;
        }
        double ymax = this.getSections().get(0).getMaxY();
        for (CSG c : this.getSections()) {
            if (!(c.getMaxY() > ymax)) continue;
            ymax = c.getMaxY();
        }
        for (int i = 0; i < this.getSections().size(); ++i) {
            CSG tmp = this.getSections().get(i);
            for (int j = 0; j < this.getHoles().size(); ++j) {
                CSG intermTmp;
                CSG c = this.getHoles().get(j);
                if (!tmp.touching(c) || tmp.getPolygons().size() <= 0 || (intermTmp = tmp.difference(c)).getPolygons().size() <= 0) continue;
                tmp = intermTmp;
            }
            this.getSections().set(i, tmp);
        }
    }

    public void setSVGDocument(Document document) {
        this.initSVGDOM(document);
        this.svgDocument = document;
    }

    public Document getSVGDocument() {
        return this.svgDocument;
    }

    private void initSVGDOM(Document document) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgent, loader);
        bridgeContext.setDynamicState(2);
        new GVTBuilder().build(bridgeContext, document);
    }

    private Document createSVGDocument(URI uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return factory.createDocument(uri.toString());
    }

    public ISVGLoadProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ISVGLoadProgress progress) {
        this.progress = progress;
    }

    public static ISVGLoadProgress getProgressDefault() {
        return progressDefault;
    }

    public static void setProgressDefault(ISVGLoadProgress progressDefault) {
        SVGLoad.progressDefault = progressDefault;
    }

    public ArrayList<CSG> getHoles() {
        return this.holes;
    }

    public void setHoles(ArrayList<CSG> holes) {
        this.holes = holes;
    }

    public ArrayList<CSG> getSections() {
        return this.sections;
    }

    public void setSections(ArrayList<CSG> sections) {
        this.sections = sections;
    }

    class MetaPostPath2 {
        private SVGOMPathElement pathElement;
        private String transform;

        public MetaPostPath2(Node pathNode) {
            this.setPathNode(pathNode);
        }

        public String toCode() {
            String sb = "";
            SVGOMPathElement pathElement = this.getPathElement();
            SVGPathSegList pathList = pathElement.getNormalizedPathSegList();
            int pathObjects = pathList.getNumberOfItems();
            for (int i = 0; i < pathObjects; ++i) {
                SVGItem item = (SVGItem)pathList.getItem(i);
                String itemLine = String.format("%s%n", item.getValueAsString());
                sb = sb + itemLine;
            }
            return sb.toString();
        }

        private void setPathNode(Node pathNode) {
            this.pathElement = (SVGOMPathElement)pathNode;
        }

        private SVGOMPathElement getPathElement() {
            return this.pathElement;
        }
    }
}

