/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.DelaunayTriangle;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Poly2Tri;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Polygon;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonPoint;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PolygonUtil {
    private PolygonUtil() {
        throw new AssertionError("Don't instantiate me!", null);
    }

    public static Polygon fromCSGPolygon(eu.mihosoft.vrl.v3d.Polygon polygon) {
        ArrayList<PolygonPoint> points = new ArrayList<PolygonPoint>();
        for (Vertex v : polygon.vertices) {
            PolygonPoint vp = new PolygonPoint(v.pos.x, v.pos.y, v.pos.z);
            points.add(vp);
        }
        Polygon result = new Polygon(points);
        Optional holesOfPresult = polygon.getStorage().getValue("jcsg:edge:polygon-holes");
        if (holesOfPresult.isPresent()) {
            List holesOfP = (List)holesOfPresult.get();
            holesOfP.stream().forEach(hP -> result.addHole(PolygonUtil.fromCSGPolygon(hP)));
        }
        return result;
    }

    public static List<eu.mihosoft.vrl.v3d.Polygon> concaveToConvex(eu.mihosoft.vrl.v3d.Polygon incoming) {
        eu.mihosoft.vrl.v3d.Polygon concave;
        boolean xnorm = Math.abs(incoming.plane.normal.x) >= 0.99999999;
        Transform orentationInv = null;
        if (xnorm) {
            Transform orentation = new Transform().roty(incoming.plane.normal.x * 90.0);
            orentationInv = orentation.inverse();
            concave = incoming.transformed(orentation);
        } else {
            concave = incoming;
        }
        ArrayList<eu.mihosoft.vrl.v3d.Polygon> result = new ArrayList<eu.mihosoft.vrl.v3d.Polygon>();
        Vector3d normal = concave.vertices.get((int)0).normal.clone();
        boolean cw = !Extrude.isCCW(concave);
        concave = Extrude.toCCW(concave);
        Polygon p = PolygonUtil.fromCSGPolygon(concave);
        Poly2Tri.triangulate(p);
        List<DelaunayTriangle> triangles = p.getTriangles();
        ArrayList<Vertex> triPoints = new ArrayList<Vertex>();
        for (DelaunayTriangle t : triangles) {
            int counter = 0;
            for (TriangulationPoint tp : t.points) {
                triPoints.add(new Vertex(new Vector3d(tp.getX(), tp.getY(), tp.getZ()), normal));
                if (counter == 2) {
                    if (!cw) {
                        Collections.reverse(triPoints);
                    }
                    eu.mihosoft.vrl.v3d.Polygon poly = new eu.mihosoft.vrl.v3d.Polygon(triPoints, concave.getStorage());
                    if (xnorm) {
                        result.add(poly.transform(orentationInv));
                    } else {
                        result.add(poly);
                    }
                    counter = 0;
                    triPoints = new ArrayList();
                    continue;
                }
                ++counter;
            }
        }
        return result;
    }
}

