/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.svg;

import com.piro.bezier.BezierPath;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.svg.ISVGLoadProgress;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.scene.paint.Color;
import javax.vecmath.Matrix4d;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMImageElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMPolylineElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPointList;

public class SVGLoad {
    private static final String PATH_ELEMENT_NAME = "path";
    private static final String GROUP_ELEMENT_NAME = "g";
    private Document svgDocument;
    boolean hp = true;
    private HashMap<String, List<Polygon>> polygonByLayers = null;
    private HashMap<String, ArrayList<CSG>> csgByLayers = new HashMap();
    private HashMap<Polygon, Color> colors = new HashMap();
    private ISVGLoadProgress progress = null;
    private double thickness;
    private boolean negativeThickness = false;
    private double height = 0.0;
    private double width = 0.0;
    private Double scale = null;
    private HashMap<String, Double> units = new HashMap();
    private static ISVGLoadProgress progressDefault = new ISVGLoadProgress(){

        @Override
        public void onShape(CSG newShape) {
        }
    };

    private double toPx(String value) {
        for (String key : this.units.keySet()) {
            if (!value.endsWith(key)) continue;
            String[] split = value.split(key);
            if (key.contentEquals("m") && split.length > 1) break;
            return Double.parseDouble(split[0]) / this.units.get(key);
        }
        return Double.parseDouble(value);
    }

    private void setScale(double value) {
        this.scale = value;
        if (this.scale.isInfinite() || this.scale.isNaN()) {
            throw new RuntimeException("Scale must be real number");
        }
        this.units.put("mm", 1.0 / this.getScale());
        this.units.put("px", 1.0);
        this.units.put("cm", this.units.get("mm") / 10.0);
        this.units.put("in", this.units.get("mm") / 25.4);
        this.units.put("ft", this.units.get("in") / 12.0);
        this.units.put("m", this.units.get("mm") / 1000.0);
    }

    private Double getScale() {
        return (double)this.scale;
    }

    private double toMM(String value) {
        Double px = this.toPx(value);
        return px * 1.0 / this.getScale();
    }

    public void setHolePolarity(boolean p) {
        this.hp = p;
    }

    public SVGLoad(URI uri) throws IOException {
        this.setSVGDocument(this.createSVGDocument(uri));
    }

    public SVGLoad(File f) throws IOException {
        this.setSVGDocument(this.createSVGDocument(f.toURI()));
    }

    public SVGLoad(String data) throws IOException {
        File tmpsvg = new File(System.getProperty("java.io.tmpdir") + "/" + Math.random());
        tmpsvg.createNewFile();
        FileWriter fw = new FileWriter(tmpsvg.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(data);
        bw.close();
        this.setSVGDocument(this.createSVGDocument(tmpsvg.toURI()));
        tmpsvg.deleteOnExit();
    }

    public ArrayList<CSG> extrude(double thickness) throws IOException {
        return this.extrude(thickness, 0.005);
    }

    public static ArrayList<CSG> extrude(File f, double thickness) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness);
    }

    public static HashMap<String, List<Polygon>> toPolygons(File f) throws IOException {
        return new SVGLoad(f.toURI()).toPolygons();
    }

    public HashMap<String, List<Polygon>> toPolygons(double resolution) {
        if (this.polygonByLayers == null) {
            try {
                this.loadAllGroups(resolution, new Transform());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getPolygonByLayers();
    }

    public HashMap<String, List<Polygon>> toPolygons() {
        return this.toPolygons(0.001);
    }

    public static ArrayList<CSG> extrude(File f, double thickness, double resolution) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness, resolution);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness) throws IOException {
        return new SVGLoad(uri).extrude(thickness);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness, double resolution) throws IOException {
        return new SVGLoad(uri).extrude(thickness, resolution);
    }

    private void loadAllGroups(double resolution, Transform startingFrame) {
        NodeList pn = this.getSVGDocument().getDocumentElement().getChildNodes();
        try {
            String hval = this.getSVGDocument().getDocumentElement().getAttribute("height");
            String wval = this.getSVGDocument().getDocumentElement().getAttribute("width");
            String viewbox = this.getSVGDocument().getDocumentElement().getAttribute("viewBox");
            double viewW = Double.parseDouble(viewbox.split(" ")[2]);
            this.setScale(1.0);
            this.height = this.toMM(hval);
            this.width = this.toMM(wval);
            double value = viewW / this.width;
            this.setScale(value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.height = 0.0;
            this.width = 0.0;
            this.setScale(3.543307);
        }
        int pnCount = pn.getLength();
        for (int j = 0; j < pnCount; ++j) {
            Node item = pn.item(j);
            if (SVGOMGElement.class.isInstance(item)) {
                SVGOMGElement element = (SVGOMGElement)item;
                this.loadGroup(element, resolution, startingFrame, null);
            }
            if (!SVGOMPathElement.class.isInstance(item) && !SVGOMImageElement.class.isInstance(item)) continue;
            try {
                this.loadPath(item, resolution, startingFrame, "TOP");
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void loadGroup(SVGOMGElement element, double resolution, Transform startingFrame, String encapsulatingLayer) {
        String layername;
        Node transforms = element.getAttributes().getNamedItem("transform");
        Transform newFrame = this.getNewframe(startingFrame, transforms);
        try {
            layername = element.getAttributeNS("http://www.inkscape.org/namespaces/inkscape", "label");
            if (layername == null || layername.length() == 0) {
                throw new RuntimeException();
            }
        }
        catch (Throwable t) {
            layername = null;
        }
        if (layername == null) {
            layername = encapsulatingLayer;
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (SVGOMGElement.class.isInstance(n)) {
                this.loadGroup((SVGOMGElement)n, resolution, newFrame, layername);
                continue;
            }
            try {
                this.loadPath(n, resolution, newFrame, layername);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private Transform getNewframe(Transform startingFrame, Node transforms) {
        if (transforms == null) {
            return startingFrame;
        }
        Transform newFrame = new Transform().apply(startingFrame);
        String transformValue = transforms.getNodeValue();
        if (transformValue.contains("translate")) {
            String[] transformValues = transformValue.replaceAll("translate", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            newFrame.apply(new Transform().translate(this.toPx(transformValues[0]), this.toPx(transformValues[1]), 0.0));
        } else if (transformValue.contains("scale")) {
            String[] transformValues = transformValue.replaceAll("scale", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            double scalex = this.toPx(transformValues[0]);
            double scaley = this.toPx(transformValues.length == 2 ? transformValues[1] : transformValues[0]);
            newFrame.scale(scalex, scaley, 1.0);
        } else if (transformValue.contains("matrix")) {
            String[] transformValues = transformValue.replaceAll("matrix", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            double a = this.toPx(transformValues[0]);
            double b = this.toPx(transformValues[1]);
            double c = this.toPx(transformValues[2]);
            double d = this.toPx(transformValues[3]);
            double e = this.toPx(transformValues[4]);
            double f = this.toPx(transformValues[5]);
            double[] elemenents = new double[]{a, c, 0.0, e, b, d, 0.0, f, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            newFrame.apply(new Transform(new Matrix4d(elemenents)));
        }
        return newFrame;
    }

    private void loadPath(Node pathNode, double resolution, Transform startingFrame, String encapsulatingLayer) {
        block36: {
            if (pathNode != null) {
                Transform newFrame = startingFrame;
                try {
                    Node transforms = pathNode.getAttributes().getNamedItem("transform");
                    newFrame = this.getNewframe(startingFrame, transforms);
                }
                catch (Exception transforms) {
                    // empty catch block
                }
                try {
                    Color c;
                    if (SVGOMPathElement.class.isInstance(pathNode)) {
                        String string;
                        c = null;
                        try {
                            String[] style;
                            for (String s : style = pathNode.getAttributes().getNamedItem("style").getNodeValue().split(";")) {
                                if (!s.startsWith("fill:")) continue;
                                string = s.split(":")[1];
                                c = Color.web((String)string);
                                break;
                            }
                        }
                        catch (IllegalArgumentException style) {
                        }
                        catch (Exception style) {
                            // empty catch block
                        }
                        if (c == null) {
                            try {
                                for (String s : style = pathNode.getAttributes().getNamedItem("style").getNodeValue().split(";")) {
                                    if (!s.startsWith("stroke:")) continue;
                                    string = s.split(":")[1];
                                    c = Color.web((String)string);
                                    break;
                                }
                            }
                            catch (IllegalArgumentException style) {
                            }
                            catch (Exception style) {
                                // empty catch block
                            }
                        }
                        MetaPostPath2 mpp = new MetaPostPath2(pathNode);
                        String code = mpp.toCode();
                        this.loadComposite(code, resolution, newFrame, encapsulatingLayer, c);
                        break block36;
                    }
                    if (SVGOMPolylineElement.class.isInstance(pathNode)) {
                        String string;
                        c = null;
                        try {
                            String[] style;
                            for (String s : style = pathNode.getAttributes().getNamedItem("style").getNodeValue().split(";")) {
                                if (!s.startsWith("fill:")) continue;
                                string = s.split(":")[1];
                                c = Color.web((String)string);
                                break;
                            }
                        }
                        catch (IllegalArgumentException style) {
                        }
                        catch (Exception style) {
                            // empty catch block
                        }
                        try {
                            c = Color.web((String)pathNode.getAttributes().getNamedItem("stroke").getNodeValue());
                        }
                        catch (IllegalArgumentException style) {
                        }
                        catch (Exception style) {
                            // empty catch block
                        }
                        if (c == null) {
                            try {
                                for (String s : style = pathNode.getAttributes().getNamedItem("style").getNodeValue().split(";")) {
                                    if (!s.startsWith("stroke:")) continue;
                                    string = s.split(":")[1];
                                    c = Color.web((String)string);
                                    break;
                                }
                            }
                            catch (IllegalArgumentException style) {
                            }
                            catch (Exception style) {
                                // empty catch block
                            }
                        }
                        String sb = null;
                        SVGOMPolylineElement pathElement = (SVGOMPolylineElement)pathNode;
                        SVGPointList pathList = pathElement.getPoints();
                        int pathObjects = pathList.getNumberOfItems();
                        for (int i = 0; i < pathObjects; ++i) {
                            SVGItem item = (SVGItem)pathList.getItem(i);
                            String itemLine = String.format("%s%n", item.getValueAsString());
                            if (sb == null) {
                                sb = "M " + itemLine;
                            }
                            sb = sb + "L " + itemLine;
                        }
                        sb = sb + "z\n";
                        this.loadComposite(sb, resolution, newFrame, encapsulatingLayer, c);
                        break block36;
                    }
                    if (SVGOMImageElement.class.isInstance(pathNode)) {
                        SVGOMImageElement image = (SVGOMImageElement)pathNode;
                        double x = this.toPx(image.getAttributes().getNamedItem("x").getNodeValue());
                        double y = this.toPx(image.getAttributes().getNamedItem("y").getNodeValue());
                        double pheight = this.toPx(image.getAttributes().getNamedItem("height").getNodeValue());
                        double pwidth = this.toPx(image.getAttributes().getNamedItem("width").getNodeValue());
                        String[] imageData = null;
                        for (int i = 0; i < image.getAttributes().getLength(); ++i) {
                            Node n = image.getAttributes().item(i);
                            if (!n.getNodeName().contains("href")) continue;
                            try {
                                imageData = n.getNodeValue().split("/");
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (ClassCastException ex) {
                    System.out.println("Found " + pathNode.getClass());
                }
            }
        }
    }

    private void loadComposite(String code, double resolution, Transform startingFrame, String encapsulatingLayer, Color c) {
        int count = code.length() - code.replace("M", "").length();
        if (count < 2) {
            try {
                this.loadSingle(code, resolution, startingFrame, encapsulatingLayer, c);
            }
            catch (Exception exception) {}
        } else {
            String[] pathParts = code.split("M");
            for (int i = 0; i < pathParts.length; ++i) {
                String sectionedPart = "M" + pathParts[i];
                if (sectionedPart.length() <= 1) continue;
                this.loadSingle(sectionedPart, resolution, startingFrame, encapsulatingLayer, c);
            }
        }
    }

    public static boolean isCCW(Polygon polygon) {
        double runningTotal = 0.0;
        List<Edge> edges = Edge.fromPolygon(polygon);
        for (Edge e : edges) {
            runningTotal += e.getP1().pos.x * e.getP2().pos.y;
            runningTotal -= e.getP2().pos.x * e.getP1().pos.y;
        }
        return runningTotal < 0.0;
    }

    private void loadSingle(String code, double resolution, Transform startingFrame, String encapsulatingLayer, Color c) {
        BezierPath path = new BezierPath();
        path.parsePathString(code);
        ArrayList<Vector3d> p = path.evaluate();
        for (Vector3d point : p) {
            point.transform(startingFrame);
            point.transform(new Transform().scale(1.0 / this.getScale()));
            point.transform(new Transform().translate(0.0, -this.height, 0.0));
            point.transform(new Transform().rotZ(-180.0));
            point.transform(new Transform().rotY(180.0));
        }
        Polygon poly = Polygon.fromPoints(p);
        if (this.getPolygonByLayers() == null) {
            this.setPolygonByLayers(new HashMap<String, List<Polygon>>());
        }
        if (this.getPolygonByLayers().get(encapsulatingLayer) == null) {
            this.getPolygonByLayers().put(encapsulatingLayer, new ArrayList());
        }
        List<Polygon> list = this.getPolygonByLayers().get(encapsulatingLayer);
        poly = Polygon.fromPoints(Extrude.toCCW(poly.getPoints()));
        if (c != null) {
            this.colors.put(poly, c);
        }
        list.add(poly);
    }

    public List<String> getLayers() {
        ArrayList<String> layers = new ArrayList<String>();
        if (this.getPolygonByLayers() == null) {
            this.toPolygons();
        }
        for (Object key : this.getPolygonByLayers().keySet().stream().sorted().toArray()) {
            layers.add((String)key);
        }
        return layers;
    }

    public CSG extrudeLayerToCSG(double t, String layer) {
        CSG unionAll = CSG.unionAll((List<CSG>)this.extrudeLayers(t, 0.01, layer).get(layer));
        unionAll.setName(layer);
        return unionAll;
    }

    public ArrayList<CSG> extrudeLayer(double t, String layer) {
        return this.extrudeLayers(t, 0.01, layer).get(layer);
    }

    public HashMap<String, ArrayList<CSG>> extrudeLayers(double t) {
        return this.extrudeLayers(t, 0.01, null);
    }

    public HashMap<String, ArrayList<CSG>> extrudeLayers(double t, double resolution, String targetLayer) {
        this.thickness = t;
        if (this.thickness < 0.0) {
            this.thickness = -this.thickness;
            this.negativeThickness = true;
        } else {
            this.negativeThickness = false;
        }
        this.toPolygons(0.001);
        for (String key : this.getPolygonByLayers().keySet()) {
            if (targetLayer != null && !targetLayer.contentEquals(key)) continue;
            if (this.csgByLayers.get(key) == null) {
                this.csgByLayers.put(key, new ArrayList());
            }
            ArrayList<CSG> parts = this.csgByLayers.get(key);
            parts.clear();
            for (Polygon p : this.getPolygonByLayers().get(key)) {
                CSG newbit = Extrude.getExtrusionEngine().extrude(new Vector3d(0.0, 0.0, this.thickness), p);
                if (this.negativeThickness) {
                    newbit = newbit.toZMax();
                }
                if (this.colors.get(p) != null) {
                    newbit.setColor(this.colors.get(p));
                }
                parts.add(newbit);
            }
        }
        return this.csgByLayers;
    }

    public ArrayList<CSG> extrude(double t, double resolution) throws IOException {
        HashMap<String, ArrayList<CSG>> layers = this.extrudeLayers(t, resolution, null);
        ArrayList<CSG> all = new ArrayList<CSG>();
        for (String key : layers.keySet()) {
            all.addAll((Collection<CSG>)layers.get(key));
        }
        return all;
    }

    public void setSVGDocument(Document document) {
        this.initSVGDOM(document);
        this.svgDocument = document;
    }

    public Document getSVGDocument() {
        return this.svgDocument;
    }

    private void initSVGDOM(Document document) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgent, loader);
        bridgeContext.setDynamicState(2);
        new GVTBuilder().build(bridgeContext, document);
    }

    private Document createSVGDocument(URI uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return factory.createDocument(uri.toString());
    }

    public ISVGLoadProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ISVGLoadProgress progress) {
        this.progress = progress;
    }

    public static ISVGLoadProgress getProgressDefault() {
        return progressDefault;
    }

    private HashMap<String, List<Polygon>> getPolygonByLayers() {
        return this.polygonByLayers;
    }

    private void setPolygonByLayers(HashMap<String, List<Polygon>> polygonByLayers) {
        this.polygonByLayers = polygonByLayers;
    }

    class MetaPostPath2 {
        private SVGOMPathElement pathElement;
        private String transform;

        public MetaPostPath2(Node pathNode) {
            this.setPathNode(pathNode);
        }

        public String toCode() {
            String sb = "";
            SVGOMPathElement pathElement = this.getPathElement();
            SVGPathSegList pathList = pathElement.getNormalizedPathSegList();
            int pathObjects = pathList.getNumberOfItems();
            for (int i = 0; i < pathObjects; ++i) {
                SVGItem item = (SVGItem)pathList.getItem(i);
                String itemLine = String.format("%s%n", item.getValueAsString());
                sb = sb + itemLine;
            }
            return sb.toString();
        }

        private void setPathNode(Node pathNode) {
            this.pathElement = (SVGOMPathElement)pathNode;
        }

        private SVGOMPathElement getPathElement() {
            return this.pathElement;
        }
    }
}

