/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFSpline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.SplinePoint;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;

public class DXF {
    private File source;
    private final PropertyStorage properties = new PropertyStorage();
    private double extrudeDistance;

    public static ArrayList<CSG> toParts(File source, double extrudeDistance) {
        block12: {
            Parser parser = ParserBuilder.createDefaultParser();
            ArrayList<Vector3d> points = new ArrayList<Vector3d>();
            ArrayList<CSG> parts = new ArrayList<CSG>();
            try {
                parser.parse((InputStream)new FileInputStream(source), "");
                DXFDocument doc = parser.getDocument();
                Iterator layerIterable = doc.getDXFLayerIterator();
                if (layerIterable == null || !layerIterable.hasNext()) break block12;
                DXFLayer layer = (DXFLayer)layerIterable.next();
                Iterator entityIterator = layer.getDXFEntityTypeIterator();
                if (entityIterator != null) {
                    while (entityIterator.hasNext()) {
                        DXFPolyline pline;
                        List plines;
                        String entityType = (String)entityIterator.next();
                        System.out.println(entityType);
                        if (entityType.contentEquals("POLYLINE")) {
                            plines = layer.getDXFEntities(entityType);
                            if (plines == null) continue;
                            for (Object p : plines) {
                                pline = (DXFPolyline)p;
                                for (int i = 0; i < pline.getVertexCount(); ++i) {
                                    DXFVertex vertex = pline.getVertex(i);
                                    Point point = vertex.getPoint();
                                    points.add(new Vector3d(point.getX(), point.getY(), point.getZ()));
                                    System.out.println((Object)((Object)points.get(points.size() - 1)) + ",");
                                }
                            }
                            continue;
                        }
                        if (entityType.contentEquals("LINE")) {
                            System.out.println("Loading line");
                            plines = layer.getDXFEntities(entityType);
                            if (plines == null) continue;
                            for (Object p : plines) {
                                pline = (DXFLine)p;
                                Point point = pline.getStartPoint();
                                points.add(new Vector3d(point.getX(), point.getY(), point.getZ()));
                                System.out.println((Object)((Object)points.get(points.size() - 1)) + ",");
                            }
                            System.out.println("Extruding");
                            parts.add(Extrude.points(new Vector3d(0.0, 0.0, extrudeDistance), points));
                            points.clear();
                            continue;
                        }
                        if (entityType.contentEquals("SPLINE")) {
                            plines = layer.getDXFEntities(entityType);
                            if (plines == null) continue;
                            for (Object p : plines) {
                                pline = (DXFSpline)p;
                                Iterator splinePointIterator = pline.getSplinePointIterator();
                                if (splinePointIterator == null) continue;
                                while (splinePointIterator.hasNext()) {
                                    SplinePoint point = (SplinePoint)splinePointIterator.next();
                                    points.add(new Vector3d(point.getX(), point.getY(), point.getZ()));
                                    System.out.println((Object)((Object)points.get(points.size() - 1)) + ",");
                                }
                            }
                            continue;
                        }
                        System.out.println("Found type: " + entityType);
                    }
                }
                return parts;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

