/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.IPolygonDebugger;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.List;

public class Plane {
    private static IPolygonDebugger debugger = null;
    private static boolean useDebugger = false;
    public static final double EPSILON = 1.0E-9;
    public static final double EPSILON_Point = 1.0E-9;
    public static final double EPSILON_duplicate = 1.0E-4;
    public static final Plane XY_PLANE = new Plane(Vector3d.Z_ONE, 1.0);
    public static final Plane XZ_PLANE = new Plane(Vector3d.Y_ONE, 1.0);
    public static final Plane YZ_PLANE = new Plane(Vector3d.X_ONE, 1.0);
    public Vector3d normal;
    public double dist;

    public Plane(Vector3d normal, double dist) {
        this.normal = normal.normalized();
        this.dist = dist;
    }

    public static Plane createFromPoints(Vector3d a, Vector3d b, Vector3d c) {
        Vector3d n = b.minus(a).cross(c.minus(a)).normalized();
        return new Plane(n, n.dot(a));
    }

    public Plane clone() {
        return new Plane(this.normal.clone(), this.dist);
    }

    public void flip() {
        this.normal = this.normal.negated();
        this.dist = -this.dist;
    }

    public void splitPolygon(Polygon polygon, List<Polygon> coplanarFront, List<Polygon> coplanarBack, List<Polygon> front, List<Polygon> back) {
        boolean COPLANAR = false;
        boolean FRONT = true;
        int BACK = 2;
        int SPANNING = 3;
        if (debugger == null || useDebugger) {
            // empty if block
        }
        double negEpsilon = -1.0E-9;
        double posEpsilon = 1.0E-9;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            double t = polygon.plane.normal.dot(polygon.vertices.get((int)i).pos) - polygon.plane.dist;
            if (t > posEpsilon) {
                posEpsilon = t + 1.0E-9;
            }
            if (!(t < negEpsilon)) continue;
            negEpsilon = t - 1.0E-9;
        }
        int polygonType = 0;
        ArrayList<Integer> types = new ArrayList<Integer>();
        boolean somePointsInfront = false;
        boolean somePointsInBack = false;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            int type;
            double t = this.normal.dot(polygon.vertices.get((int)i).pos) - this.dist;
            int n = t < negEpsilon ? 2 : (type = t > posEpsilon ? 1 : 0);
            if (type == 2) {
                somePointsInBack = true;
            }
            if (type == 1) {
                somePointsInfront = true;
            }
            types.add(type);
        }
        if (somePointsInBack && somePointsInfront) {
            polygonType = 3;
        } else if (somePointsInBack) {
            polygonType = 2;
        } else if (somePointsInfront) {
            polygonType = 1;
        }
        switch (polygonType) {
            case 0: {
                (this.normal.dot(polygon.plane.normal) > 0.0 ? coplanarFront : coplanarBack).add(polygon);
                break;
            }
            case 1: {
                front.add(polygon);
                break;
            }
            case 2: {
                back.add(polygon);
                break;
            }
            case 3: {
                ArrayList<Vertex> f = new ArrayList<Vertex>();
                ArrayList<Vertex> b = new ArrayList<Vertex>();
                for (int i = 0; i < polygon.vertices.size(); ++i) {
                    int j = (i + 1) % polygon.vertices.size();
                    int ti = (Integer)types.get(i);
                    int tj = (Integer)types.get(j);
                    Vertex vi = polygon.vertices.get(i);
                    Vertex vj = polygon.vertices.get(j);
                    if (ti != 2) {
                        f.add(vi);
                    }
                    if (ti != 1) {
                        b.add(ti != 2 ? vi.clone() : vi);
                    }
                    if ((ti | tj) != 3) continue;
                    double t = (this.dist - this.normal.dot(vi.pos)) / this.normal.dot(vj.pos.minus(vi.pos));
                    Vertex v = vi.interpolate(vj, t);
                    f.add(v);
                    b.add(v.clone());
                }
                if (f.size() >= 3) {
                    front.add(new Polygon(f, polygon.getStorage()));
                } else {
                    System.out.println("Front Clip Fault!");
                }
                if (b.size() >= 3) {
                    back.add(new Polygon(b, polygon.getStorage()));
                    break;
                }
                System.out.println("Back Clip Fault!");
            }
        }
    }

    public static IPolygonDebugger getDebugger() {
        return debugger;
    }

    public static void setDebugger(IPolygonDebugger debugger) {
        Plane.debugger = debugger;
    }

    public static boolean isUseDebugger() {
        return useDebugger;
    }

    public static void setUseDebugger(boolean useDebugger) {
        Plane.useDebugger = useDebugger;
    }
}

