/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;

public class Transform {
    private final Matrix4d m;

    public Transform() {
        this.m = new Matrix4d();
        this.getInternalMatrix().m00 = 1.0;
        this.getInternalMatrix().m11 = 1.0;
        this.getInternalMatrix().m22 = 1.0;
        this.getInternalMatrix().m33 = 1.0;
    }

    public static Transform unity() {
        return new Transform();
    }

    public Transform(Matrix4d m) {
        this.m = m;
    }

    public Transform rotX(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, cos, sin, 0.0, 0.0, -sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rotY(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{cos, 0.0, -sin, 0.0, 0.0, 1.0, 0.0, 0.0, sin, 0.0, cos, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rotZ(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{cos, sin, 0.0, 0.0, -sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rot(double x, double y, double z) {
        return this.rotX(x).rotY(y).rotZ(z);
    }

    public Transform rot(Vector3d vec) {
        return this.rotX(vec.x).rotY(vec.y).rotZ(vec.z);
    }

    public Transform translate(Vector3d vec) {
        return this.translate(vec.x, vec.y, vec.z);
    }

    public Transform translate(double x, double y, double z) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform translateX(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, value, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public double getQuataurionX() {
        Matrix4d rotation = this.getInternalMatrix();
        Quat4d q1 = new Quat4d();
        rotation.get(q1);
        return q1.x;
    }

    public double getQuataurionY() {
        Matrix4d rotation = this.getInternalMatrix();
        Quat4d q1 = new Quat4d();
        rotation.get(q1);
        return q1.y;
    }

    public double getQuataurionZ() {
        Matrix4d rotation = this.getInternalMatrix();
        Quat4d q1 = new Quat4d();
        rotation.get(q1);
        return q1.z;
    }

    public double getQuataurionW() {
        Matrix4d rotation = this.getInternalMatrix();
        Quat4d q1 = new Quat4d();
        rotation.get(q1);
        return q1.w;
    }

    public double getX() {
        javax.vecmath.Vector3d t1 = new javax.vecmath.Vector3d();
        this.getInternalMatrix().get(t1);
        return t1.x;
    }

    public double getY() {
        javax.vecmath.Vector3d t1 = new javax.vecmath.Vector3d();
        this.getInternalMatrix().get(t1);
        return t1.y;
    }

    public double getZ() {
        javax.vecmath.Vector3d t1 = new javax.vecmath.Vector3d();
        this.getInternalMatrix().get(t1);
        return t1.z;
    }

    public String toString() {
        javax.vecmath.Vector3d t1 = new javax.vecmath.Vector3d();
        this.getInternalMatrix().get(t1);
        Quat4d q1 = new Quat4d();
        this.getInternalMatrix().get(q1);
        return "X=" + t1.x + " Y=" + t1.y + " Z=" + t1.z + " Qx=" + q1.x + " Qy=" + q1.y + " Qz=" + q1.z + " Qw=" + q1.w;
    }

    public Transform translateY(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, value, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform translateZ(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, value, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform mirror(Plane plane) {
        System.err.println("WARNING: I'm too dumb to implement the mirror() operation correctly. Please fix me!");
        double nx = plane.normal.x;
        double ny = plane.normal.y;
        double nz = plane.normal.z;
        double w = plane.dist;
        double[] elemenents = new double[]{1.0 - 2.0 * nx * nx, -2.0 * ny * nx, -2.0 * nz * nx, 0.0, -2.0 * nx * ny, 1.0 - 2.0 * ny * ny, -2.0 * nz * ny, 0.0, -2.0 * nx * nz, -2.0 * ny * nz, 1.0 - 2.0 * nz * nz, 0.0, -2.0 * nx * w, -2.0 * ny * w, -2.0 * nz * w, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(Vector3d vec) {
        if (vec.x == 0.0 || vec.y == 0.0 || vec.z == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{vec.x, 0.0, 0.0, 0.0, 0.0, vec.y, 0.0, 0.0, 0.0, 0.0, vec.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(double x, double y, double z) {
        if (x == 0.0 || y == 0.0 || z == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleX(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{s, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleY(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleZ(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.getInternalMatrix().mul(new Matrix4d(elemenents));
        return this;
    }

    public Vector3d transform(Vector3d vec) {
        double x = this.getInternalMatrix().m00 * vec.x + this.getInternalMatrix().m01 * vec.y + this.getInternalMatrix().m02 * vec.z + this.getInternalMatrix().m03;
        double y = this.getInternalMatrix().m10 * vec.x + this.getInternalMatrix().m11 * vec.y + this.getInternalMatrix().m12 * vec.z + this.getInternalMatrix().m13;
        vec.z = this.getInternalMatrix().m20 * vec.x + this.getInternalMatrix().m21 * vec.y + this.getInternalMatrix().m22 * vec.z + this.getInternalMatrix().m23;
        vec.x = x;
        vec.y = y;
        return vec;
    }

    public Vector3d transform(Vector3d vec, double amount) {
        double prevX = vec.x;
        double prevY = vec.y;
        double prevZ = vec.z;
        double x = this.getInternalMatrix().m00 * vec.x + this.getInternalMatrix().m01 * vec.y + this.getInternalMatrix().m02 * vec.z + this.getInternalMatrix().m03;
        double y = this.getInternalMatrix().m10 * vec.x + this.getInternalMatrix().m11 * vec.y + this.getInternalMatrix().m12 * vec.z + this.getInternalMatrix().m13;
        vec.z = this.getInternalMatrix().m20 * vec.x + this.getInternalMatrix().m21 * vec.y + this.getInternalMatrix().m22 * vec.z + this.getInternalMatrix().m23;
        vec.x = x;
        vec.y = y;
        double diffX = vec.x - prevX;
        double diffY = vec.y - prevY;
        double diffZ = vec.z - prevZ;
        vec.x = prevX + diffX * amount;
        vec.y = prevY + diffY * amount;
        vec.z = prevZ + diffZ * amount;
        return vec;
    }

    public double getScale() {
        return this.getInternalMatrix().getScale();
    }

    public boolean isMirror() {
        return this.getInternalMatrix().determinant() < 0.0;
    }

    public Transform apply(Transform t) {
        this.getInternalMatrix().mul(t.getInternalMatrix());
        return this;
    }

    public Matrix4d getInternalMatrix() {
        return this.m;
    }

    public Transform inverse() {
        Transform tr = new Transform().apply(this);
        tr.getInternalMatrix().invert();
        return tr;
    }

    public Transform invert() {
        this.getInternalMatrix().invert();
        return this;
    }

    public Transform move(Number x, Number y, Number z) {
        return new Transform().translate(x.doubleValue(), y.doubleValue(), z.doubleValue()).apply(this);
    }

    public Transform move(Vertex v) {
        return new Transform().translate(v.getX(), v.getY(), v.getZ()).apply(this);
    }

    public Transform move(Vector3d v) {
        return new Transform().translate(v.x, v.y, v.z).apply(this);
    }

    public Transform move(Number[] posVector) {
        return this.move(posVector[0], posVector[1], posVector[2]);
    }

    public Transform movey(Number howFarToMove) {
        return new Transform().translateY(howFarToMove.doubleValue()).apply(this);
    }

    public Transform movez(Number howFarToMove) {
        return new Transform().translateZ(howFarToMove.doubleValue()).apply(this);
    }

    public Transform movex(Number howFarToMove) {
        return new Transform().translateX(howFarToMove.doubleValue()).apply(this);
    }

    public Transform mirrory() {
        return this.scaleY(-1.0);
    }

    public Transform mirrorz() {
        return this.scaleZ(-1.0);
    }

    public Transform mirrorx() {
        return this.scaleX(-1.0);
    }

    public Transform rotz(Number degreesToRotate) {
        return new Transform().rotZ(degreesToRotate.doubleValue()).apply(this);
    }

    public Transform roty(Number degreesToRotate) {
        return new Transform().rotY(degreesToRotate.doubleValue()).apply(this);
    }

    public Transform rotx(Number degreesToRotate) {
        return new Transform().rotX(degreesToRotate.doubleValue()).apply(this);
    }
}

