/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj;

import eu.mihosoft.vrl.v3d.ObjFile;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.SmoothingGroups;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.FloatArrayList;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.IntegerArrayList;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.MtlReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public class ObjImporter {
    private static boolean debug = false;
    private static float scale = 1.0f;
    private static boolean flatXZ = false;
    private final Map<String, TriangleMesh> meshes = new HashMap<String, TriangleMesh>();
    private final Map<String, Material> materials = new HashMap<String, Material>();
    private final List<Map<String, Material>> materialLibrary = new ArrayList<Map<String, Material>>();
    private String objFileUrl;
    private FloatArrayList vertexes = new FloatArrayList();
    private FloatArrayList uvs = new FloatArrayList();
    private IntegerArrayList faces = new IntegerArrayList();
    private IntegerArrayList smoothingGroups = new IntegerArrayList();
    private FloatArrayList normals = new FloatArrayList();
    private IntegerArrayList faceNormals = new IntegerArrayList();
    private Material material = new PhongMaterial(Color.WHITE);
    private int facesStart = 0;
    private int facesNormalStart = 0;
    private int smoothingGroupsStart = 0;

    private int vertexIndex(int vertexIndex) {
        if (vertexIndex < 0) {
            return vertexIndex + this.vertexes.size() / 3;
        }
        return vertexIndex - 1;
    }

    private int uvIndex(int uvIndex) {
        if (uvIndex < 0) {
            return uvIndex + this.uvs.size() / 2;
        }
        return uvIndex - 1;
    }

    private int normalIndex(int normalIndex) {
        if (normalIndex < 0) {
            return normalIndex + this.normals.size() / 3;
        }
        return normalIndex - 1;
    }

    static void log(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public Set<String> getMeshes() {
        return this.meshes.keySet();
    }

    public ObjImporter(String objFileUrl) throws FileNotFoundException, IOException {
        this.objFileUrl = objFileUrl;
        ObjImporter.log("Reading filename = " + objFileUrl);
        this.read(new URL(objFileUrl).openStream());
    }

    public ObjImporter(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public ObjImporter(ObjFile obj) throws IOException {
        this.read(obj.getObjStream(), obj.getMtlStream());
    }

    public TriangleMesh getMesh() {
        return this.meshes.values().iterator().next();
    }

    public Collection<TriangleMesh> getMeshCollection() {
        return this.meshes.values();
    }

    public Collection<Material> getMaterialCollection() {
        return this.materials.values();
    }

    public Material getMaterial() {
        return this.materials.values().iterator().next();
    }

    public TriangleMesh getMesh(String key) {
        return this.meshes.get(key);
    }

    public Material getMaterial(String key) {
        return this.materials.get(key);
    }

    public MeshView buildMeshView(String key) {
        MeshView meshView = new MeshView();
        meshView.setId(key);
        meshView.setMaterial(this.materials.get(key));
        meshView.setMesh((Mesh)this.meshes.get(key));
        meshView.setCullFace(CullFace.NONE);
        return meshView;
    }

    public static void setDebug(boolean debug) {
        ObjImporter.debug = debug;
    }

    public static void setScale(float scale) {
        ObjImporter.scale = scale;
    }

    private void read(InputStream objInputStream) throws IOException {
        this.read(objInputStream, null);
    }

    private void read(InputStream objInputStream, InputStream mtlInputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(objInputStream));
        int currentSmoothGroup = 0;
        String key = "default";
        block2: while ((line = br.readLine()) != null) {
            try {
                float z;
                String[] split;
                if (line.startsWith("g ") || line.equals("g")) {
                    this.addMesh(key);
                    key = line.length() > 2 ? line.substring(2) : "default";
                    ObjImporter.log("key = " + key);
                    continue;
                }
                if (line.startsWith("v ")) {
                    split = line.substring(2).trim().split(" +");
                    float x = Float.parseFloat(split[0]) * scale;
                    float y = Float.parseFloat(split[1]) * scale;
                    z = Float.parseFloat(split[2]) * scale;
                    this.vertexes.add(Float.valueOf(x));
                    this.vertexes.add(Float.valueOf(y));
                    this.vertexes.add(Float.valueOf(z));
                    if (!flatXZ) continue;
                    this.uvs.add(Float.valueOf(x));
                    this.uvs.add(Float.valueOf(z));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    split = line.substring(3).trim().split(" +");
                    float u = Float.parseFloat(split[0]);
                    float v = Float.parseFloat(split[1]);
                    this.uvs.add(Float.valueOf(u));
                    this.uvs.add(Float.valueOf(1.0f - v));
                    continue;
                }
                if (line.startsWith("f ")) {
                    split = line.substring(2).trim().split(" +");
                    int[][] data = new int[split.length][];
                    boolean uvProvided = true;
                    boolean normalProvided = true;
                    for (int i = 0; i < split.length; ++i) {
                        String[] split2 = split[i].split("/");
                        if (split2.length < 2) {
                            uvProvided = false;
                        }
                        if (split2.length < 3) {
                            normalProvided = false;
                        }
                        data[i] = new int[split2.length];
                        for (int j = 0; j < split2.length; ++j) {
                            if (split2[j].length() == 0) {
                                data[i][j] = 0;
                                if (j == 1) {
                                    uvProvided = false;
                                }
                                if (j != 2) continue;
                                normalProvided = false;
                                continue;
                            }
                            data[i][j] = Integer.parseInt(split2[j]);
                        }
                    }
                    int v1 = this.vertexIndex(data[0][0]);
                    int uv1 = -1;
                    int n1 = -1;
                    if (uvProvided && !flatXZ && (uv1 = this.uvIndex(data[0][1])) < 0) {
                        uvProvided = false;
                    }
                    if (normalProvided && (n1 = this.normalIndex(data[0][2])) < 0) {
                        normalProvided = false;
                    }
                    for (int i = 1; i < data.length - 1; ++i) {
                        int v2 = this.vertexIndex(data[i][0]);
                        int v3 = this.vertexIndex(data[i + 1][0]);
                        int uv2 = -1;
                        int uv3 = -1;
                        int n2 = -1;
                        int n3 = -1;
                        if (uvProvided && !flatXZ) {
                            uv2 = this.uvIndex(data[i][1]);
                            uv3 = this.uvIndex(data[i + 1][1]);
                        }
                        if (normalProvided) {
                            n2 = this.normalIndex(data[i][2]);
                            n3 = this.normalIndex(data[i + 1][2]);
                        }
                        this.faces.add(v1);
                        this.faces.add(uv1);
                        this.faces.add(v2);
                        this.faces.add(uv2);
                        this.faces.add(v3);
                        this.faces.add(uv3);
                        this.faceNormals.add(n1);
                        this.faceNormals.add(n2);
                        this.faceNormals.add(n3);
                        this.smoothingGroups.add(currentSmoothGroup);
                    }
                    continue;
                }
                if (line.startsWith("s ")) {
                    if (line.substring(2).equals("off")) {
                        currentSmoothGroup = 0;
                        continue;
                    }
                    currentSmoothGroup = Integer.parseInt(line.substring(2));
                    continue;
                }
                if (line.startsWith("mtllib ")) {
                    split = line.substring("mtllib ".length()).trim().split(" +");
                    if (mtlInputStream == null) {
                        for (String filename : split) {
                            MtlReader mtlReader = new MtlReader(filename, this.objFileUrl);
                            this.materialLibrary.add(mtlReader.getMaterials());
                        }
                        continue;
                    }
                    if (split.length <= 1) continue;
                    ObjImporter.log("WARNING: more than one mtllib not supported if reading from streams! Using only one mtllib.");
                    MtlReader mtlReader = new MtlReader(mtlInputStream);
                    this.materialLibrary.add(mtlReader.getMaterials());
                    continue;
                }
                if (line.startsWith("usemtl ")) {
                    this.addMesh(key);
                    String materialName = line.substring("usemtl ".length());
                    for (Map<String, Material> mm : this.materialLibrary) {
                        Material m = mm.get(materialName);
                        if (m == null) continue;
                        this.material = m;
                        continue block2;
                    }
                    continue;
                }
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("vn ")) {
                    split = line.substring(2).trim().split(" +");
                    float x = Float.parseFloat(split[0]);
                    float y = Float.parseFloat(split[1]);
                    z = Float.parseFloat(split[2]);
                    this.normals.add(Float.valueOf(x));
                    this.normals.add(Float.valueOf(y));
                    this.normals.add(Float.valueOf(z));
                    continue;
                }
                ObjImporter.log("line skipped: " + line);
            }
            catch (Exception ex) {
                Logger.getLogger(MtlReader.class.getName()).log(Level.SEVERE, "Failed to parse line:" + line, ex);
            }
        }
        this.addMesh(key);
        ObjImporter.log("Totally loaded " + (double)this.vertexes.size() / 3.0 + " vertexes, " + (double)this.uvs.size() / 2.0 + " uvs, " + (double)this.faces.size() / 6.0 + " faces, " + this.smoothingGroups.size() + " smoothing groups.");
    }

    private void addMesh(String key) {
        if (this.facesStart >= this.faces.size()) {
            this.smoothingGroupsStart = this.smoothingGroups.size();
            return;
        }
        HashMap<Integer, Integer> vertexMap = new HashMap<Integer, Integer>(this.vertexes.size() / 2);
        HashMap<Integer, Integer> uvMap = new HashMap<Integer, Integer>(this.uvs.size() / 2);
        HashMap<Integer, Integer> normalMap = new HashMap<Integer, Integer>(this.normals.size() / 2);
        FloatArrayList newVertexes = new FloatArrayList(this.vertexes.size() / 2);
        FloatArrayList newUVs = new FloatArrayList(this.uvs.size() / 2);
        FloatArrayList newNormals = new FloatArrayList(this.normals.size() / 2);
        boolean useNormals = true;
        for (int i = this.facesStart; i < this.faces.size(); i += 2) {
            int vi = this.faces.get(i);
            Integer nvi = (Integer)vertexMap.get(vi);
            if (nvi == null) {
                nvi = newVertexes.size() / 3;
                vertexMap.put(vi, nvi);
                newVertexes.add(this.vertexes.get(vi * 3));
                newVertexes.add(this.vertexes.get(vi * 3 + 1));
                newVertexes.add(this.vertexes.get(vi * 3 + 2));
            }
            this.faces.set(i, nvi);
            int uvi = this.faces.get(i + 1);
            Integer nuvi = (Integer)uvMap.get(uvi);
            if (nuvi == null) {
                nuvi = newUVs.size() / 2;
                uvMap.put(uvi, nuvi);
                if (uvi >= 0) {
                    newUVs.add(this.uvs.get(uvi * 2));
                    newUVs.add(this.uvs.get(uvi * 2 + 1));
                } else {
                    newUVs.add(Float.valueOf(0.0f));
                    newUVs.add(Float.valueOf(0.0f));
                }
            }
            this.faces.set(i + 1, nuvi);
            if (!useNormals) continue;
            int ni = this.faceNormals.get(i / 2);
            Integer nni = (Integer)normalMap.get(ni);
            if (nni == null) {
                nni = newNormals.size() / 3;
                normalMap.put(ni, nni);
                if (ni >= 0 && this.normals.size() >= (ni + 1) * 3) {
                    newNormals.add(this.normals.get(ni * 3));
                    newNormals.add(this.normals.get(ni * 3 + 1));
                    newNormals.add(this.normals.get(ni * 3 + 2));
                } else {
                    useNormals = false;
                    newNormals.add(Float.valueOf(0.0f));
                    newNormals.add(Float.valueOf(0.0f));
                    newNormals.add(Float.valueOf(0.0f));
                }
            }
            this.faceNormals.set(i / 2, nni);
        }
        TriangleMesh mesh = new TriangleMesh();
        mesh.getPoints().setAll(newVertexes.toFloatArray());
        mesh.getTexCoords().setAll(newUVs.toFloatArray());
        mesh.getFaces().setAll(((IntegerArrayList)this.faces.subList(this.facesStart, this.faces.size())).toIntArray());
        if (useNormals) {
            int[] newFaces = ((IntegerArrayList)this.faces.subList(this.facesStart, this.faces.size())).toIntArray();
            int[] newFaceNormals = ((IntegerArrayList)this.faceNormals.subList(this.facesNormalStart, this.faceNormals.size())).toIntArray();
            int[] smGroups = SmoothingGroups.calcSmoothGroups(mesh, newFaces, newFaceNormals, newNormals.toFloatArray());
            mesh.getFaceSmoothingGroups().setAll(smGroups);
        } else {
            mesh.getFaceSmoothingGroups().setAll(((IntegerArrayList)this.smoothingGroups.subList(this.smoothingGroupsStart, this.smoothingGroups.size())).toIntArray());
        }
        int keyIndex = 2;
        String keyBase = key;
        while (this.meshes.get(key) != null) {
            key = keyBase + " (" + keyIndex++ + ")";
        }
        this.meshes.put(key, mesh);
        this.materials.put(key, this.material);
        ObjImporter.log("Added mesh '" + key + "' of " + mesh.getPoints().size() / mesh.getPointElementSize() + " vertexes, " + mesh.getTexCoords().size() / mesh.getTexCoordElementSize() + " uvs, " + mesh.getFaces().size() / mesh.getFaceElementSize() + " faces, " + mesh.getFaceSmoothingGroups().size() + " smoothing groups.");
        ObjImporter.log("material diffuse color = " + ((PhongMaterial)this.material).getDiffuseColor());
        ObjImporter.log("material diffuse map = " + ((PhongMaterial)this.material).getDiffuseMap());
        this.facesStart = this.faces.size();
        this.facesNormalStart = this.faceNormals.size();
        this.smoothingGroupsStart = this.smoothingGroups.size();
    }

    public static void setFlatXZ(boolean flatXZ) {
        ObjImporter.flatXZ = flatXZ;
    }
}

