/**
 * Primitive.java
 *
 * Copyright 2014-2014 Michael Hoffer info@michaelhoffer.de. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY Michael Hoffer info@michaelhoffer.de "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Michael Hoffer info@michaelhoffer.de OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of Michael Hoffer info@michaelhoffer.de.
 */ 

package eu.mihosoft.vrl.v3d;

import java.util.ArrayList;
import java.util.List;

import eu.mihosoft.vrl.v3d.parametrics.Parameter;

// TODO: Auto-generated Javadoc
/**
 * A primitive geometry.
 *
 * @author Michael Hoffer &lt;info@michaelhoffer.de&gt;
 */
public abstract class Primitive implements ItoCSG{
	ArrayList<Parameter> parametrics=new ArrayList<>();
    

    /**
     * Returns the polygons that define this primitive.
     *
     *  Note:  this method computes the polygons each time this method is
     * called. The polygons can be cached inside a {@link CSG} object.
     *
     * @return al list of polygons that define this primitive
     */
    public abstract List<Polygon> toPolygons();

    /**
     * Returns this primitive as {@link CSG}.
     *
     * @return this primitive as {@link CSG}
     */
    public   CSG toCSG() {
    	CSG tmp = CSG.fromPolygons(getProperties(),toPolygons());
    	if(parametrics!=null)
    		for(Parameter p:parametrics)
    			tmp.setParameter(p);
        return tmp;
    }
    
    /**
     * Returns the property storage of this primitive.
     * @return the property storage of this primitive
     */
    public abstract PropertyStorage getProperties();
}
