/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class FloatArrayList
extends AbstractList<Float>
implements List<Float>,
RandomAccess,
Cloneable,
Serializable {
    private transient float[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public FloatArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new float[initialCapacity];
    }

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(Collection<? extends Float> c) {
        this.elementData = new float[c.size()];
        int i = 0;
        for (Float f : c) {
            this.elementData[i] = f.floatValue();
            ++i;
        }
        this.size = this.elementData.length;
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            this.ensureCapacityInternal(minCapacity);
        }
    }

    private void ensureCapacityInternal(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = FloatArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Float) {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(Float.valueOf(this.elementData[i]))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Float) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(Float.valueOf(this.elementData[i]))) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            FloatArrayList v = (FloatArrayList)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Float[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = Float.valueOf(this.elementData[i]);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.toArray(), this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public float[] toFloatArray() {
        float[] res = new float[this.size];
        System.arraycopy(this.elementData, 0, res, 0, this.size);
        return res;
    }

    Float elementData(int index) {
        return Float.valueOf(this.elementData[index]);
    }

    @Override
    public Float get(int index) {
        this.rangeCheck(index);
        return this.elementData(index);
    }

    @Override
    public Float set(int index, Float element) {
        this.rangeCheck(index);
        Float oldValue = this.elementData(index);
        this.elementData[index] = element.floatValue();
        return oldValue;
    }

    @Override
    public boolean add(Float e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e.floatValue();
        return true;
    }

    @Override
    public void add(int index, Float element) {
        this.rangeCheckForAdd(index);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element.floatValue();
        ++this.size;
    }

    @Override
    public Float remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        Float oldValue = this.elementData(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0.0f;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Float) {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(Float.valueOf(this.elementData[index]))) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0.0f;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0.0f;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Float> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Float> c) {
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = 0.0f;
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            float[] elementData = this.elementData;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    if (c.contains(Float.valueOf(elementData[r])) != complement) continue;
                    elementData[w++] = elementData[r];
                }
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (r != this.size) {
                    System.arraycopy(elementData, r, elementData, w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        elementData[i] = 0.0f;
                    }
                    this.modCount += this.size - w;
                    this.size = w;
                    modified = true;
                }
                throw throwable;
            }
            System.arraycopy(elementData, r, elementData, w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                elementData[i] = 0.0f;
            }
            this.modCount += this.size - w;
            this.size = w;
            modified = true;
        }
        return modified;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(Float.valueOf(this.elementData[i]));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new float[arrayLength];
        float[] a = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            a[i] = ((Float)s.readObject()).floatValue();
        }
    }

    @Override
    public ListIterator<Float> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public ListIterator<Float> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<Float> iterator() {
        return new Itr();
    }

    @Override
    public List<Float> subList(int fromIndex, int toIndex) {
        FloatArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    static /* synthetic */ int access$100(FloatArrayList x0) {
        return x0.modCount;
    }

    private class SubList
    extends FloatArrayList
    implements RandomAccess {
        private final FloatArrayList parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(FloatArrayList parent, int offset, int fromIndex, int toIndex) {
            this.parent = parent;
            this.parentOffset = fromIndex;
            this.offset = offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = FloatArrayList.this.modCount;
        }

        @Override
        public float[] toFloatArray() {
            float[] res = new float[this.size];
            System.arraycopy(FloatArrayList.this.elementData, this.offset, res, 0, this.size);
            return res;
        }

        @Override
        public Float set(int index, Float e) {
            this.rangeCheck(index);
            this.checkForComodification();
            Float oldValue = FloatArrayList.this.elementData(this.offset + index);
            ((FloatArrayList)FloatArrayList.this).elementData[this.offset + index] = e.floatValue();
            return oldValue;
        }

        @Override
        public Float get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return FloatArrayList.this.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, Float e) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.parent.add(this.parentOffset + index, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public Float remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            Float result = this.parent.remove(this.parentOffset + index);
            this.modCount = this.parent.modCount;
            --this.size;
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + fromIndex, this.parentOffset + toIndex);
            this.modCount = this.parent.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + index, c);
            this.modCount = this.parent.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<Float> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Float> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            final int offset = this.offset;
            return new ListIterator<Float>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = FloatArrayList.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public Float next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    float[] elementData = FloatArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return Float.valueOf(elementData[offset + this.lastRet]);
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Float previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    float[] elementData = FloatArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return Float.valueOf(elementData[offset + this.lastRet]);
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = FloatArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(Float e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        FloatArrayList.this.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(Float e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        SubList.this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = FloatArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (this.expectedModCount != FloatArrayList.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList(this, this.offset, fromIndex, toIndex);
        }

        @Override
        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        @Override
        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        @Override
        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (FloatArrayList.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<Float> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public Float previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            float[] elementData = FloatArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return Float.valueOf(elementData[this.lastRet]);
        }

        @Override
        public void set(Float e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                FloatArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(Float e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                FloatArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = FloatArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<Float> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = FloatArrayList.access$100(FloatArrayList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != FloatArrayList.this.size;
        }

        @Override
        public Float next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= FloatArrayList.this.size) {
                throw new NoSuchElementException();
            }
            float[] elementData = FloatArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return Float.valueOf(elementData[this.lastRet]);
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                FloatArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = FloatArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (FloatArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

