/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d;

import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.PolygonMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SymbolicPolygonMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SymbolicSubdivisionBuilder;
import java.util.ArrayList;
import java.util.List;

public class SubdivisionMesh
extends PolygonMesh {
    private final PolygonMesh originalMesh;
    private int subdivisionLevel;
    private BoundaryMode boundaryMode;
    private MapBorderMode mapBorderMode;
    private final List<SymbolicPolygonMesh> symbolicMeshes;
    private boolean pointValuesDirty;
    private boolean meshDirty;
    private boolean subdivisionLevelDirty;

    public SubdivisionMesh(PolygonMesh originalMesh, int subdivisionLevel, BoundaryMode boundaryMode, MapBorderMode mapBorderMode) {
        this.originalMesh = originalMesh;
        this.setSubdivisionLevelForced(subdivisionLevel);
        this.setBoundaryModeForced(boundaryMode);
        this.setMapBorderModeForced(mapBorderMode);
        this.symbolicMeshes = new ArrayList<SymbolicPolygonMesh>(4);
        originalMesh.getPoints().addListener((observableArray, sizeChanged, from, to) -> {
            if (sizeChanged) {
                this.meshDirty = true;
            } else {
                this.pointValuesDirty = true;
            }
        });
        originalMesh.getTexCoords().addListener((observableArray, sizeChanged, from, to) -> {
            this.meshDirty = true;
        });
    }

    public void update() {
        if (this.meshDirty) {
            this.symbolicMeshes.clear();
            this.symbolicMeshes.add(new SymbolicPolygonMesh(this.originalMesh));
            this.pointValuesDirty = true;
            this.subdivisionLevelDirty = true;
        }
        while (this.subdivisionLevel >= this.symbolicMeshes.size()) {
            this.symbolicMeshes.add(SymbolicSubdivisionBuilder.subdivide(this.symbolicMeshes.get(this.symbolicMeshes.size() - 1), this.boundaryMode, this.mapBorderMode));
            this.pointValuesDirty = true;
            this.subdivisionLevelDirty = true;
        }
        if (this.pointValuesDirty) {
            for (int i = 0; i <= this.subdivisionLevel; ++i) {
                SymbolicPolygonMesh symbolicMesh = this.symbolicMeshes.get(i);
                symbolicMesh.points.update();
            }
        }
        if (this.pointValuesDirty || this.subdivisionLevelDirty) {
            this.getPoints().setAll(this.symbolicMeshes.get((int)this.subdivisionLevel).points.data);
        }
        if (this.subdivisionLevelDirty) {
            this.faces = this.symbolicMeshes.get((int)this.subdivisionLevel).faces;
            this.numEdgesInFaces = -1;
            this.getFaceSmoothingGroups().setAll(this.symbolicMeshes.get((int)this.subdivisionLevel).faceSmoothingGroups);
            this.getTexCoords().setAll(this.symbolicMeshes.get((int)this.subdivisionLevel).texCoords);
        }
        this.meshDirty = false;
        this.pointValuesDirty = false;
        this.subdivisionLevelDirty = false;
    }

    private void setSubdivisionLevelForced(int subdivisionLevel) {
        this.subdivisionLevel = subdivisionLevel;
        this.subdivisionLevelDirty = true;
    }

    private void setBoundaryModeForced(BoundaryMode boundaryMode) {
        this.boundaryMode = boundaryMode;
        this.meshDirty = true;
    }

    private void setMapBorderModeForced(MapBorderMode mapBorderMode) {
        this.mapBorderMode = mapBorderMode;
        this.meshDirty = true;
    }

    public PolygonMesh getOriginalMesh() {
        return this.originalMesh;
    }

    public int getSubdivisionLevel() {
        return this.subdivisionLevel;
    }

    public void setSubdivisionLevel(int subdivisionLevel) {
        if (subdivisionLevel != this.subdivisionLevel) {
            this.setSubdivisionLevelForced(subdivisionLevel);
        }
    }

    public BoundaryMode getBoundaryMode() {
        return this.boundaryMode;
    }

    public void setBoundaryMode(BoundaryMode boundaryMode) {
        if (boundaryMode != this.boundaryMode) {
            this.setBoundaryModeForced(boundaryMode);
        }
    }

    public MapBorderMode getMapBorderMode() {
        return this.mapBorderMode;
    }

    public void setMapBorderMode(MapBorderMode mapBorderMode) {
        if (mapBorderMode != this.mapBorderMode) {
            this.setMapBorderModeForced(mapBorderMode);
        }
    }

    public static enum MapBorderMode {
        NOT_SMOOTH,
        SMOOTH_INTERNAL,
        SMOOTH_ALL;

    }

    public static enum BoundaryMode {
        CREASE_EDGES,
        CREASE_ALL;

    }
}

