/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.SubScene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;

public class MeshContainer {
    private final List<Mesh> meshes;
    private final List<Material> materials;
    private final double width;
    private final double height;
    private final double depth;
    private final Bounds bounds;
    private final Group root = new Group();
    private Pane viewContainer;
    private SubScene subScene;

    MeshContainer(Vector3d min, Vector3d max, Mesh ... meshes) {
        this(min, max, Arrays.asList(meshes));
    }

    MeshContainer(Vector3d min, Vector3d max, List<Mesh> meshes) {
        this.meshes = meshes;
        this.materials = new ArrayList<Material>();
        this.bounds = new Bounds(min, max);
        this.width = this.bounds.getBounds().x;
        this.height = this.bounds.getBounds().y;
        this.depth = this.bounds.getBounds().z;
        PhongMaterial material = new PhongMaterial(Color.RED);
        for (Mesh mesh : meshes) {
            this.materials.add((Material)material);
        }
    }

    MeshContainer(Vector3d min, Vector3d max, List<Mesh> meshes, List<Material> materials) {
        this.meshes = meshes;
        this.materials = materials;
        this.bounds = new Bounds(min, max);
        this.width = this.bounds.getBounds().x;
        this.height = this.bounds.getBounds().y;
        this.depth = this.bounds.getBounds().z;
        if (materials.size() != meshes.size()) {
            throw new IllegalArgumentException("Mesh list and Material list must not differ in size!");
        }
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public List<Mesh> getMeshes() {
        return this.meshes;
    }

    public String toString() {
        return this.bounds.toString();
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }

    public List<MeshView> getAsMeshViews() {
        ArrayList<MeshView> result = new ArrayList<MeshView>(this.meshes.size());
        for (int i = 0; i < this.meshes.size(); ++i) {
            Mesh mesh = this.meshes.get(i);
            Material mat = this.materials.get(i);
            MeshView view = new MeshView(mesh);
            view.setMaterial(mat);
            view.setCullFace(CullFace.NONE);
            result.add(view);
        }
        return result;
    }
}

