/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.quickhull3d;

import eu.mihosoft.vrl.v3d.ext.quickhull3d.Face;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.FaceList;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HalfEdge;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.Point3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.Vector3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.VertexList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Iterator;
import java.util.Vector;

class QuickHull3D {
    public static final int CLOCKWISE = 1;
    public static final int INDEXED_FROM_ONE = 2;
    public static final int INDEXED_FROM_ZERO = 4;
    public static final int POINT_RELATIVE = 8;
    public static final double AUTOMATIC_TOLERANCE = -1.0;
    protected int findIndex = -1;
    protected double charLength;
    protected boolean debug = false;
    protected Vertex[] pointBuffer = new Vertex[0];
    protected int[] vertexPointIndices = new int[0];
    private Face[] discardedFaces = new Face[3];
    private Vertex[] maxVtxs = new Vertex[3];
    private Vertex[] minVtxs = new Vertex[3];
    protected Vector faces = new Vector(16);
    protected Vector horizon = new Vector(16);
    private FaceList newFaces = new FaceList();
    private VertexList unclaimed = new VertexList();
    private VertexList claimed = new VertexList();
    protected int numVertices;
    protected int numFaces;
    protected int numPoints;
    protected double explicitTolerance = -1.0;
    protected double tolerance;
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    private static final int NONCONVEX_WRT_LARGER_FACE = 1;
    private static final int NONCONVEX = 2;

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    public double getDistanceTolerance() {
        return this.tolerance;
    }

    public void setExplicitDistanceTolerance(double tol) {
        this.explicitTolerance = tol;
    }

    public double getExplicitDistanceTolerance() {
        return this.explicitTolerance;
    }

    private void addPointToFace(Vertex vtx, Face face) {
        vtx.face = face;
        if (face.outside == null) {
            this.claimed.add(vtx);
        } else {
            this.claimed.insertBefore(vtx, face.outside);
        }
        face.outside = vtx;
    }

    private void removePointFromFace(Vertex vtx, Face face) {
        if (vtx == face.outside) {
            face.outside = vtx.next != null && vtx.next.face == face ? vtx.next : null;
        }
        this.claimed.delete(vtx);
    }

    private Vertex removeAllPointsFromFace(Face face) {
        if (face.outside != null) {
            Vertex end = face.outside;
            while (end.next != null && end.next.face == face) {
                end = end.next;
            }
            this.claimed.delete(face.outside, end);
            end.next = null;
            return face.outside;
        }
        return null;
    }

    public QuickHull3D() {
    }

    public QuickHull3D(double[] coords) throws IllegalArgumentException {
        this.build(coords, coords.length / 3);
    }

    public QuickHull3D(Point3d[] points) throws IllegalArgumentException {
        this.build(points, points.length);
    }

    private HalfEdge findHalfEdge(Vertex tail, Vertex head) {
        Iterator it = this.faces.iterator();
        while (it.hasNext()) {
            HalfEdge he = ((Face)it.next()).findEdge(tail, head);
            if (he == null) continue;
            return he;
        }
        return null;
    }

    protected void setHull(double[] coords, int nump, int[][] faceIndices, int numf) {
        this.initBuffers(nump);
        this.setPoints(coords, nump);
        this.computeMaxAndMin();
        for (int i = 0; i < numf; ++i) {
            Face face = Face.create(this.pointBuffer, faceIndices[i]);
            HalfEdge he = face.he0;
            do {
                HalfEdge heOpp;
                if ((heOpp = this.findHalfEdge(he.head(), he.tail())) == null) continue;
                he.setOpposite(heOpp);
            } while ((he = he.next) != face.he0);
            this.faces.add(face);
        }
    }

    private void printQhullErrors(Process proc) throws IOException {
        boolean wrote = false;
        InputStream es = proc.getErrorStream();
        while (es.available() > 0) {
            System.out.write(es.read());
            wrote = true;
        }
        if (wrote) {
            System.out.println("");
        }
    }

    protected void setFromQhull(double[] coords, int nump, boolean triangulate) {
        String commandStr = "./qhull i";
        if (triangulate) {
            commandStr = commandStr + " -Qt";
        }
        try {
            Process proc = Runtime.getRuntime().exec(commandStr);
            PrintStream ps = new PrintStream(proc.getOutputStream());
            StreamTokenizer stok = new StreamTokenizer(new InputStreamReader(proc.getInputStream()));
            ps.println("3 " + nump);
            for (int i = 0; i < nump; ++i) {
                ps.println(coords[i * 3 + 0] + " " + coords[i * 3 + 1] + " " + coords[i * 3 + 2]);
            }
            ps.flush();
            ps.close();
            Vector<Integer> indexList = new Vector<Integer>(3);
            stok.eolIsSignificant(true);
            this.printQhullErrors(proc);
            do {
                stok.nextToken();
            } while (stok.sval == null || !stok.sval.startsWith("MERGEexact"));
            for (int i = 0; i < 4; ++i) {
                stok.nextToken();
            }
            if (stok.ttype != -2) {
                System.out.println("Expecting number of faces");
                System.exit(1);
            }
            int numf = (int)stok.nval;
            stok.nextToken();
            int[][] faceIndices = new int[numf][];
            for (int i = 0; i < numf; ++i) {
                indexList.clear();
                while (stok.nextToken() != 10) {
                    if (stok.ttype != -2) {
                        System.out.println("Expecting face index");
                        System.exit(1);
                    }
                    indexList.add(0, new Integer((int)stok.nval));
                }
                faceIndices[i] = new int[indexList.size()];
                int k = 0;
                Iterator it = indexList.iterator();
                while (it.hasNext()) {
                    faceIndices[i][k++] = (Integer)it.next();
                }
            }
            this.setHull(coords, nump, faceIndices, numf);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void printPoints(PrintStream ps) {
        for (int i = 0; i < this.numPoints; ++i) {
            Point3d pnt = this.pointBuffer[i].pnt;
            ps.println(pnt.x + ", " + pnt.y + ", " + pnt.z + ",");
        }
    }

    public void build(double[] coords) throws IllegalArgumentException {
        this.build(coords, coords.length / 3);
    }

    public void build(double[] coords, int nump) throws IllegalArgumentException {
        if (nump < 4) {
            throw new IllegalArgumentException("Less than four input points specified");
        }
        if (coords.length / 3 < nump) {
            throw new IllegalArgumentException("Coordinate array too small for specified number of points");
        }
        this.initBuffers(nump);
        this.setPoints(coords, nump);
        this.buildHull();
    }

    public void build(Point3d[] points) throws IllegalArgumentException {
        this.build(points, points.length);
    }

    public void build(Point3d[] points, int nump) throws IllegalArgumentException {
        if (nump < 4) {
            throw new IllegalArgumentException("Less than four input points specified");
        }
        if (points.length < nump) {
            throw new IllegalArgumentException("Point array too small for specified number of points");
        }
        this.initBuffers(nump);
        this.setPoints(points, nump);
        this.buildHull();
    }

    public void triangulate() {
        double minArea = 1000.0 * this.charLength * 2.220446049250313E-16;
        this.newFaces.clear();
        for (Face face : this.faces) {
            if (face.mark != 1) continue;
            face.triangulate(this.newFaces, minArea);
        }
        Face face = this.newFaces.first();
        while (face != null) {
            this.faces.add(face);
            face = face.next;
        }
    }

    protected void initBuffers(int nump) {
        if (this.pointBuffer.length < nump) {
            int i;
            Vertex[] newBuffer = new Vertex[nump];
            this.vertexPointIndices = new int[nump];
            for (i = 0; i < this.pointBuffer.length; ++i) {
                newBuffer[i] = this.pointBuffer[i];
            }
            for (i = this.pointBuffer.length; i < nump; ++i) {
                newBuffer[i] = new Vertex();
            }
            this.pointBuffer = newBuffer;
        }
        this.faces.clear();
        this.claimed.clear();
        this.numFaces = 0;
        this.numPoints = nump;
    }

    protected void setPoints(double[] coords, int nump) {
        int i = 0;
        while (i < nump) {
            Vertex vtx = this.pointBuffer[i];
            vtx.pnt.set(coords[i * 3 + 0], coords[i * 3 + 1], coords[i * 3 + 2]);
            vtx.index = i++;
        }
    }

    protected void setPoints(Point3d[] pnts, int nump) {
        int i = 0;
        while (i < nump) {
            Vertex vtx = this.pointBuffer[i];
            vtx.pnt.set(pnts[i]);
            vtx.index = i++;
        }
    }

    protected void computeMaxAndMin() {
        int i;
        Vector3d max = new Vector3d();
        Vector3d min = new Vector3d();
        for (i = 0; i < 3; ++i) {
            this.maxVtxs[i] = this.minVtxs[i] = this.pointBuffer[0];
        }
        max.set(this.pointBuffer[0].pnt);
        min.set(this.pointBuffer[0].pnt);
        for (i = 1; i < this.numPoints; ++i) {
            Point3d pnt = this.pointBuffer[i].pnt;
            if (pnt.x > max.x) {
                max.x = pnt.x;
                this.maxVtxs[0] = this.pointBuffer[i];
            } else if (pnt.x < min.x) {
                min.x = pnt.x;
                this.minVtxs[0] = this.pointBuffer[i];
            }
            if (pnt.y > max.y) {
                max.y = pnt.y;
                this.maxVtxs[1] = this.pointBuffer[i];
            } else if (pnt.y < min.y) {
                min.y = pnt.y;
                this.minVtxs[1] = this.pointBuffer[i];
            }
            if (pnt.z > max.z) {
                max.z = pnt.z;
                this.maxVtxs[2] = this.pointBuffer[i];
                continue;
            }
            if (!(pnt.z < min.z)) continue;
            min.z = pnt.z;
            this.minVtxs[2] = this.pointBuffer[i];
        }
        this.charLength = Math.max(max.x - min.x, max.y - min.y);
        this.charLength = Math.max(max.z - min.z, this.charLength);
        this.tolerance = this.explicitTolerance == -1.0 ? 6.661338147750939E-16 * (Math.max(Math.abs(max.x), Math.abs(min.x)) + Math.max(Math.abs(max.y), Math.abs(min.y)) + Math.max(Math.abs(max.z), Math.abs(min.z))) : this.explicitTolerance;
    }

    protected void createInitialSimplex() throws IllegalArgumentException {
        int k;
        int i;
        double max = 0.0;
        int imax = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            double diff = this.maxVtxs[i2].pnt.get(i2) - this.minVtxs[i2].pnt.get(i2);
            if (!(diff > max)) continue;
            max = diff;
            imax = i2;
        }
        if (max <= this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be coincident");
        }
        Vertex[] vtx = new Vertex[4];
        vtx[0] = this.maxVtxs[imax];
        vtx[1] = this.minVtxs[imax];
        Vector3d u01 = new Vector3d();
        Vector3d diff02 = new Vector3d();
        Vector3d nrml = new Vector3d();
        Vector3d xprod = new Vector3d();
        double maxSqr = 0.0;
        u01.sub(vtx[1].pnt, vtx[0].pnt);
        u01.normalize();
        for (int i3 = 0; i3 < this.numPoints; ++i3) {
            diff02.sub(this.pointBuffer[i3].pnt, vtx[0].pnt);
            xprod.cross(u01, diff02);
            double lenSqr = xprod.normSquared();
            if (!(lenSqr > maxSqr) || this.pointBuffer[i3] == vtx[0] || this.pointBuffer[i3] == vtx[1]) continue;
            maxSqr = lenSqr;
            vtx[2] = this.pointBuffer[i3];
            nrml.set(xprod);
        }
        if (Math.sqrt(maxSqr) <= 100.0 * this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be colinear");
        }
        nrml.normalize();
        double maxDist = 0.0;
        double d0 = vtx[2].pnt.dot(nrml);
        for (int i4 = 0; i4 < this.numPoints; ++i4) {
            double dist = Math.abs(this.pointBuffer[i4].pnt.dot(nrml) - d0);
            if (!(dist > maxDist) || this.pointBuffer[i4] == vtx[0] || this.pointBuffer[i4] == vtx[1] || this.pointBuffer[i4] == vtx[2]) continue;
            maxDist = dist;
            vtx[3] = this.pointBuffer[i4];
        }
        if (Math.abs(maxDist) <= 100.0 * this.tolerance) {
            throw new IllegalArgumentException("Input points appear to be coplanar");
        }
        if (this.debug) {
            System.out.println("initial vertices:");
            System.out.println(vtx[0].index + ": " + vtx[0].pnt);
            System.out.println(vtx[1].index + ": " + vtx[1].pnt);
            System.out.println(vtx[2].index + ": " + vtx[2].pnt);
            System.out.println(vtx[3].index + ": " + vtx[3].pnt);
        }
        Face[] tris = new Face[4];
        if (vtx[3].pnt.dot(nrml) - d0 < 0.0) {
            tris[0] = Face.createTriangle(vtx[0], vtx[1], vtx[2]);
            tris[1] = Face.createTriangle(vtx[3], vtx[1], vtx[0]);
            tris[2] = Face.createTriangle(vtx[3], vtx[2], vtx[1]);
            tris[3] = Face.createTriangle(vtx[3], vtx[0], vtx[2]);
            for (i = 0; i < 3; ++i) {
                k = (i + 1) % 3;
                tris[i + 1].getEdge(1).setOpposite(tris[k + 1].getEdge(0));
                tris[i + 1].getEdge(2).setOpposite(tris[0].getEdge(k));
            }
        } else {
            tris[0] = Face.createTriangle(vtx[0], vtx[2], vtx[1]);
            tris[1] = Face.createTriangle(vtx[3], vtx[0], vtx[1]);
            tris[2] = Face.createTriangle(vtx[3], vtx[1], vtx[2]);
            tris[3] = Face.createTriangle(vtx[3], vtx[2], vtx[0]);
            for (i = 0; i < 3; ++i) {
                k = (i + 1) % 3;
                tris[i + 1].getEdge(0).setOpposite(tris[k + 1].getEdge(1));
                tris[i + 1].getEdge(2).setOpposite(tris[0].getEdge((3 - i) % 3));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.faces.add(tris[i]);
        }
        for (i = 0; i < this.numPoints; ++i) {
            Vertex v = this.pointBuffer[i];
            if (v == vtx[0] || v == vtx[1] || v == vtx[2] || v == vtx[3]) continue;
            maxDist = this.tolerance;
            Face maxFace = null;
            for (int k2 = 0; k2 < 4; ++k2) {
                double dist = tris[k2].distanceToPlane(v.pnt);
                if (!(dist > maxDist)) continue;
                maxFace = tris[k2];
                maxDist = dist;
            }
            if (maxFace == null) continue;
            this.addPointToFace(v, maxFace);
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public Point3d[] getVertices() {
        Point3d[] vtxs = new Point3d[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            vtxs[i] = this.pointBuffer[this.vertexPointIndices[i]].pnt;
        }
        return vtxs;
    }

    public int getVertices(double[] coords) {
        for (int i = 0; i < this.numVertices; ++i) {
            Point3d pnt = this.pointBuffer[this.vertexPointIndices[i]].pnt;
            coords[i * 3 + 0] = pnt.x;
            coords[i * 3 + 1] = pnt.y;
            coords[i * 3 + 2] = pnt.z;
        }
        return this.numVertices;
    }

    public int[] getVertexPointIndices() {
        int[] indices = new int[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            indices[i] = this.vertexPointIndices[i];
        }
        return indices;
    }

    public int getNumFaces() {
        return this.faces.size();
    }

    public int[][] getFaces() {
        return this.getFaces(0);
    }

    public int[][] getFaces(int indexFlags) {
        int[][] allFaces = new int[this.faces.size()][];
        int k = 0;
        for (Face face : this.faces) {
            allFaces[k] = new int[face.numVertices()];
            this.getFaceIndices(allFaces[k], face, indexFlags);
            ++k;
        }
        return allFaces;
    }

    public void print(PrintStream ps) {
        this.print(ps, 0);
    }

    public void print(PrintStream ps, int indexFlags) {
        if ((indexFlags & 4) == 0) {
            indexFlags |= 2;
        }
        for (int i = 0; i < this.numVertices; ++i) {
            Point3d pnt = this.pointBuffer[this.vertexPointIndices[i]].pnt;
            ps.println("v " + pnt.x + " " + pnt.y + " " + pnt.z);
        }
        for (Face face : this.faces) {
            int[] indices = new int[face.numVertices()];
            this.getFaceIndices(indices, face, indexFlags);
            ps.print("f");
            for (int k = 0; k < indices.length; ++k) {
                ps.print(" " + indices[k]);
            }
            ps.println("");
        }
    }

    private void getFaceIndices(int[] indices, Face face, int flags) {
        boolean ccw = (flags & 1) == 0;
        boolean indexedFromOne = (flags & 2) != 0;
        boolean pointRelative = (flags & 8) != 0;
        HalfEdge hedge = face.he0;
        int k = 0;
        do {
            int idx = hedge.head().index;
            if (pointRelative) {
                idx = this.vertexPointIndices[idx];
            }
            if (indexedFromOne) {
                // empty if block
            }
            indices[k++] = ++idx;
        } while ((hedge = ccw ? hedge.next : hedge.prev) != face.he0);
    }

    protected void resolveUnclaimedPoints(FaceList newFaces) {
        Vertex vtxNext;
        Vertex vtx = vtxNext = this.unclaimed.first();
        while (vtx != null) {
            vtxNext = vtx.next;
            double maxDist = this.tolerance;
            Face maxFace = null;
            Face newFace = newFaces.first();
            while (newFace != null) {
                if (newFace.mark == 1) {
                    double dist = newFace.distanceToPlane(vtx.pnt);
                    if (dist > maxDist) {
                        maxDist = dist;
                        maxFace = newFace;
                    }
                    if (maxDist > 1000.0 * this.tolerance) break;
                }
                newFace = newFace.next;
            }
            if (maxFace != null) {
                this.addPointToFace(vtx, maxFace);
                if (this.debug && vtx.index == this.findIndex) {
                    System.out.println(this.findIndex + " CLAIMED BY " + maxFace.getVertexString());
                }
            } else if (this.debug && vtx.index == this.findIndex) {
                System.out.println(this.findIndex + " DISCARDED");
            }
            vtx = vtxNext;
        }
    }

    protected void deleteFacePoints(Face face, Face absorbingFace) {
        Vertex faceVtxs = this.removeAllPointsFromFace(face);
        if (faceVtxs != null) {
            if (absorbingFace == null) {
                this.unclaimed.addAll(faceVtxs);
            } else {
                Vertex vtxNext;
                Vertex vtx = vtxNext = faceVtxs;
                while (vtx != null) {
                    vtxNext = vtx.next;
                    double dist = absorbingFace.distanceToPlane(vtx.pnt);
                    if (dist > this.tolerance) {
                        this.addPointToFace(vtx, absorbingFace);
                    } else {
                        this.unclaimed.add(vtx);
                    }
                    vtx = vtxNext;
                }
            }
        }
    }

    protected double oppFaceDistance(HalfEdge he) {
        return he.face.distanceToPlane(he.opposite.face.getCentroid());
    }

    private boolean doAdjacentMerge(Face face, int mergeType) {
        HalfEdge hedge = face.he0;
        boolean convex = true;
        do {
            Face oppFace = hedge.oppositeFace();
            boolean merge = false;
            if (mergeType == 2) {
                if (this.oppFaceDistance(hedge) > -this.tolerance || this.oppFaceDistance(hedge.opposite) > -this.tolerance) {
                    merge = true;
                }
            } else if (face.area > oppFace.area) {
                double d;
                double dist1 = this.oppFaceDistance(hedge);
                if (d > -this.tolerance) {
                    merge = true;
                } else if (this.oppFaceDistance(hedge.opposite) > -this.tolerance) {
                    convex = false;
                }
            } else if (this.oppFaceDistance(hedge.opposite) > -this.tolerance) {
                merge = true;
            } else if (this.oppFaceDistance(hedge) > -this.tolerance) {
                convex = false;
            }
            if (!merge) continue;
            if (this.debug) {
                System.out.println("  merging " + face.getVertexString() + "  and  " + oppFace.getVertexString());
            }
            int numd = face.mergeAdjacentFace(hedge, this.discardedFaces);
            for (int i = 0; i < numd; ++i) {
                this.deleteFacePoints(this.discardedFaces[i], face);
            }
            if (this.debug) {
                System.out.println("  result: " + face.getVertexString());
            }
            return true;
        } while ((hedge = hedge.next) != face.he0);
        if (!convex) {
            face.mark = 2;
        }
        return false;
    }

    protected void calculateHorizon(Point3d eyePnt, HalfEdge edge0, Face face, Vector horizon) {
        this.deleteFacePoints(face, null);
        face.mark = 3;
        if (this.debug) {
            System.out.println("  visiting face " + face.getVertexString());
        }
        HalfEdge edge = edge0 == null ? (edge0 = face.getEdge(0)) : edge0.getNext();
        do {
            Face oppFace = edge.oppositeFace();
            if (oppFace.mark != 1) continue;
            if (oppFace.distanceToPlane(eyePnt) > this.tolerance) {
                this.calculateHorizon(eyePnt, edge.getOpposite(), oppFace, horizon);
                continue;
            }
            horizon.add(edge);
            if (!this.debug) continue;
            System.out.println("  adding horizon edge " + edge.getVertexString());
        } while ((edge = edge.getNext()) != edge0);
    }

    private HalfEdge addAdjoiningFace(Vertex eyeVtx, HalfEdge he) {
        Face face = Face.createTriangle(eyeVtx, he.tail(), he.head());
        this.faces.add(face);
        face.getEdge(-1).setOpposite(he.getOpposite());
        return face.getEdge(0);
    }

    protected void addNewFaces(FaceList newFaces, Vertex eyeVtx, Vector horizon) {
        newFaces.clear();
        HalfEdge hedgeSidePrev = null;
        HalfEdge hedgeSideBegin = null;
        for (HalfEdge horizonHe : horizon) {
            HalfEdge hedgeSide = this.addAdjoiningFace(eyeVtx, horizonHe);
            if (this.debug) {
                System.out.println("new face: " + hedgeSide.face.getVertexString());
            }
            if (hedgeSidePrev != null) {
                hedgeSide.next.setOpposite(hedgeSidePrev);
            } else {
                hedgeSideBegin = hedgeSide;
            }
            newFaces.add(hedgeSide.getFace());
            hedgeSidePrev = hedgeSide;
        }
        hedgeSideBegin.next.setOpposite(hedgeSidePrev);
    }

    protected Vertex nextPointToAdd() {
        if (!this.claimed.isEmpty()) {
            Face eyeFace = this.claimed.first().face;
            Vertex eyeVtx = null;
            double maxDist = 0.0;
            Vertex vtx = eyeFace.outside;
            while (vtx != null && vtx.face == eyeFace) {
                double dist = eyeFace.distanceToPlane(vtx.pnt);
                if (dist > maxDist) {
                    maxDist = dist;
                    eyeVtx = vtx;
                }
                vtx = vtx.next;
            }
            return eyeVtx;
        }
        return null;
    }

    protected void addPointToHull(Vertex eyeVtx) {
        this.horizon.clear();
        this.unclaimed.clear();
        if (this.debug) {
            System.out.println("Adding point: " + eyeVtx.index);
            System.out.println(" which is " + eyeVtx.face.distanceToPlane(eyeVtx.pnt) + " above face " + eyeVtx.face.getVertexString());
        }
        this.removePointFromFace(eyeVtx, eyeVtx.face);
        this.calculateHorizon(eyeVtx.pnt, null, eyeVtx.face, this.horizon);
        this.newFaces.clear();
        this.addNewFaces(this.newFaces, eyeVtx, this.horizon);
        Face face = this.newFaces.first();
        while (face != null) {
            if (face.mark == 1) {
                while (this.doAdjacentMerge(face, 1)) {
                }
            }
            face = face.next;
        }
        face = this.newFaces.first();
        while (face != null) {
            if (face.mark == 2) {
                face.mark = 1;
                while (this.doAdjacentMerge(face, 2)) {
                }
            }
            face = face.next;
        }
        this.resolveUnclaimedPoints(this.newFaces);
    }

    protected void buildHull() {
        Vertex eyeVtx;
        int cnt = 0;
        this.computeMaxAndMin();
        this.createInitialSimplex();
        while ((eyeVtx = this.nextPointToAdd()) != null) {
            this.addPointToHull(eyeVtx);
            ++cnt;
            if (!this.debug) continue;
            System.out.println("iteration " + cnt + " done");
        }
        this.reindexFacesAndVertices();
        if (this.debug) {
            System.out.println("hull done");
        }
    }

    private void markFaceVertices(Face face, int mark) {
        HalfEdge he0;
        HalfEdge he = he0 = face.getFirstEdge();
        do {
            he.head().index = mark;
        } while ((he = he.next) != he0);
    }

    protected void reindexFacesAndVertices() {
        for (int i = 0; i < this.numPoints; ++i) {
            this.pointBuffer[i].index = -1;
        }
        this.numFaces = 0;
        Iterator it = this.faces.iterator();
        while (it.hasNext()) {
            Face face = (Face)it.next();
            if (face.mark != 1) {
                it.remove();
                continue;
            }
            this.markFaceVertices(face, 0);
            ++this.numFaces;
        }
        this.numVertices = 0;
        for (int i = 0; i < this.numPoints; ++i) {
            Vertex vtx = this.pointBuffer[i];
            if (vtx.index != 0) continue;
            this.vertexPointIndices[this.numVertices] = i;
            ++this.numVertices;
            vtx.index = vtx.index;
        }
    }

    protected boolean checkFaceConvexity(Face face, double tol, PrintStream ps) {
        HalfEdge he = face.he0;
        do {
            face.checkConsistency();
            double dist = this.oppFaceDistance(he);
            if (dist > tol) {
                if (ps != null) {
                    ps.println("Edge " + he.getVertexString() + " non-convex by " + dist);
                }
                return false;
            }
            dist = this.oppFaceDistance(he.opposite);
            if (dist > tol) {
                if (ps != null) {
                    ps.println("Opposite edge " + he.opposite.getVertexString() + " non-convex by " + dist);
                }
                return false;
            }
            if (he.next.oppositeFace() != he.oppositeFace()) continue;
            if (ps != null) {
                ps.println("Redundant vertex " + he.head().index + " in face " + face.getVertexString());
            }
            return false;
        } while ((he = he.next) != face.he0);
        return true;
    }

    protected boolean checkFaces(double tol, PrintStream ps) {
        boolean convex = true;
        for (Face face : this.faces) {
            if (face.mark != 1 || this.checkFaceConvexity(face, tol, ps)) continue;
            convex = false;
        }
        return convex;
    }

    public boolean check(PrintStream ps) {
        return this.check(ps, this.getDistanceTolerance());
    }

    public boolean check(PrintStream ps, double tol) {
        double pointTol = 10.0 * tol;
        if (!this.checkFaces(this.tolerance, ps)) {
            return false;
        }
        for (int i = 0; i < this.numPoints; ++i) {
            Point3d pnt = this.pointBuffer[i].pnt;
            for (Face face : this.faces) {
                double dist;
                if (face.mark != 1 || !((dist = face.distanceToPlane(pnt)) > pointTol)) continue;
                if (ps != null) {
                    ps.println("Point " + i + " " + dist + " above face " + face.getVertexString());
                }
                return false;
            }
        }
        return true;
    }
}

