/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.parametrics;

import eu.mihosoft.vrl.v3d.parametrics.CSGDatabase;
import eu.mihosoft.vrl.v3d.parametrics.IParameterChanged;
import java.util.ArrayList;

public class Parameter {
    private String name = null;
    private final ArrayList<String> options = new ArrayList();
    private Long value = null;
    private String strValue = null;

    protected void setup(String key, Long defaultValue, ArrayList<String> options) {
        this.name = key;
        if (CSGDatabase.get(this.name) == null) {
            this.setValue(defaultValue);
        } else {
            this.setValue(CSGDatabase.get(this.name).getValue());
        }
        CSGDatabase.addParameterListener(this.name, new IParameterChanged(){

            @Override
            public void parameterChanged(String name, Parameter p) {
                Parameter.this.value = p.getValue();
            }
        });
        for (String o : options) {
            this.options.add(o);
        }
        CSGDatabase.set(key, this);
    }

    protected void setup(String key, String defaultValue, ArrayList<String> options) {
        this.name = key;
        this.strValue = CSGDatabase.get(this.name) == null ? defaultValue : CSGDatabase.get(this.name).getStrValue();
        CSGDatabase.addParameterListener(this.name, new IParameterChanged(){

            @Override
            public void parameterChanged(String name, Parameter p) {
                Parameter.this.strValue = p.getStrValue();
            }
        });
        for (String o : options) {
            this.options.add(o);
        }
        CSGDatabase.set(key, this);
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Long newVal) {
        if (this.value != newVal) {
            this.value = newVal;
            ArrayList<IParameterChanged> listeners = CSGDatabase.getParamListeners(this.name);
            for (int i = 0; i < listeners.size(); ++i) {
                IParameterChanged l = listeners.get(i);
                l.parameterChanged(this.name, this);
            }
        }
    }

    public Long getValue() {
        return this.value;
    }

    public ArrayList<String> getOptions() {
        return this.options;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public void setStrValue(String newValue) {
        if (!this.strValue.contentEquals(newValue)) {
            this.strValue = newValue;
            ArrayList<IParameterChanged> listeners = CSGDatabase.getParamListeners(this.name);
            for (IParameterChanged l : listeners) {
                l.parameterChanged(this.name, this);
            }
        }
    }

    public void setMM(double newVal) {
        this.setValue(new Long((long)(newVal * 1000.0)));
    }

    public void setMicrons(long newVal) {
        this.setValue(new Long(newVal));
    }

    public double getMM() {
        return Double.parseDouble(this.getValue().toString()) / 1000.0;
    }

    public double getMicrons() {
        return this.getValue().longValue();
    }
}

