/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.thumbnail;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.thumbnail.TransformConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javax.imageio.ImageIO;

public class ThumbnailImage {
    private static CullFace cullFaceValue = CullFace.BACK;

    public static Bounds getSellectedBounds(List<CSG> incoming) {
        Vector3d min = null;
        Vector3d max = null;
        for (CSG c : incoming) {
            if (c.isHide() || c.isInGroup()) continue;
            Vector3d min2 = c.getBounds().getMin().clone();
            Vector3d max2 = c.getBounds().getMax().clone();
            if (min == null) {
                min = min2;
            }
            if (max == null) {
                max = max2;
            }
            if (min2.x < min.x) {
                min.x = min2.x;
            }
            if (min2.y < min.y) {
                min.y = min2.y;
            }
            if (min2.z < min.z) {
                min.z = min2.z;
            }
            if (max.x < max2.x) {
                max.x = max2.x;
            }
            if (max.y < max2.y) {
                max.y = max2.y;
            }
            if (!(max.z < max2.z)) continue;
            max.z = max2.z;
        }
        if (max == null) {
            max = new Vector3d(0.0, 0.0, 0.0);
        }
        if (min == null) {
            min = new Vector3d(0.0, 0.0, 0.0);
        }
        return new Bounds(min, max);
    }

    public static WritableImage get(List<CSG> c) {
        ArrayList<CSG> csgList = new ArrayList<CSG>();
        for (CSG cs : c) {
            if (cs.getManipulator() != null) {
                csgList.add(cs.transformed(TransformConverter.fromAffine(cs.getManipulator())).syncProperties(cs));
                continue;
            }
            csgList.add(cs);
        }
        Group root = new Group();
        Bounds b = ThumbnailImage.getSellectedBounds(csgList);
        double yOffset = (b.getMax().y - b.getMin().y) / 2.0;
        double xOffset = (b.getMax().x - b.getMin().x) / 2.0;
        double zCenter = (b.getMax().z - b.getMin().z) / 2.0;
        for (CSG csg : csgList) {
            if (csg.isHide() || csg.isInGroup()) continue;
            MeshView meshView = csg.movez(-zCenter).getMesh();
            if (csg.isHole()) {
                PhongMaterial material = new PhongMaterial();
                material.setDiffuseColor(new Color(0.25, 0.25, 0.25, 0.75));
                material.setSpecularColor(Color.WHITE);
                meshView.setMaterial((Material)material);
                meshView.setOpacity(0.25);
            }
            meshView.setCullFace(ThumbnailImage.getCullFaceValue());
            root.getChildren().add((Object)meshView);
        }
        double totalz = b.getMax().z - b.getMin().z;
        double totaly = b.getMax().y - b.getMin().y;
        double totalx = b.getMax().x - b.getMin().x;
        PerspectiveCamera camera = new PerspectiveCamera(true);
        double maxDimension = Math.max(totalx, Math.max(totaly, totalz));
        double cameraDistance = maxDimension / Math.tan(Math.toRadians(camera.getFieldOfView() / 2.0)) * 0.8;
        Affine camDist = new Affine();
        camDist.setTz(-cameraDistance);
        Rotate rot1 = new Rotate(45.0, Rotate.Z_AXIS);
        Rotate rot2 = new Rotate(-150.0, Rotate.Y_AXIS);
        Affine camoffset = new Affine();
        camoffset.setTx(xOffset);
        camoffset.setTy(yOffset);
        camera.getTransforms().add((Object)camoffset);
        camera.getTransforms().add((Object)rot2);
        camera.getTransforms().add((Object)rot1);
        camera.getTransforms().add((Object)camDist);
        int i = 1000;
        Scene scene = new Scene((Parent)root, (double)i, (double)i, true, SceneAntialiasing.BALANCED);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.setCamera((Camera)camera);
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        params.setCamera((Camera)camera);
        params.setDepthBuffer(true);
        params.setTransform((Transform)Transform.scale((double)1.0, (double)1.0));
        camera.setNearClip(0.1);
        camera.setFarClip(9000.0);
        WritableImage snapshot = new WritableImage(i, i);
        root.snapshot(params, snapshot);
        return snapshot;
    }

    public static Thread writeImage(CSG incoming, File toPNG) {
        ArrayList<CSG> bits = new ArrayList<CSG>();
        bits.add(incoming);
        return ThumbnailImage.writeImage(bits, toPNG);
    }

    public static Thread writeImage(final ArrayList<CSG> incoming, final File toPNG) {
        Thread t = new Thread(new Runnable(){
            WritableImage img = null;

            @Override
            public void run() {
                File image = toPNG;
                Platform.runLater(() -> {
                    this.img = ThumbnailImage.get(incoming);
                });
                while (this.img == null) {
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)this.img, null);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", image);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        t.setUncaughtExceptionHandler((thread, throwable) -> {
            throwable.printStackTrace();
            thread.interrupt();
        });
        t.start();
        return t;
    }

    public static CullFace getCullFaceValue() {
        return cullFaceValue;
    }

    public static void setCullFaceValue(CullFace cullFaceValue) {
        ThumbnailImage.cullFaceValue = cullFaceValue;
    }
}

