/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.utils3d;

import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class DragSupport {
    public EventHandler<KeyEvent> keyboardEventHandler;
    public EventHandler<MouseEvent> mouseEventHandler;
    private Number anchor;
    private double dragAnchor;
    private MouseEvent lastMouseEvent;
    private Scene target;

    public DragSupport(Scene target, KeyCode modifier, Orientation orientation, Property<Number> property) {
        this(target, modifier, MouseButton.PRIMARY, orientation, property, 1.0);
    }

    public DragSupport(Scene target, KeyCode modifier, MouseButton mouseButton, Orientation orientation, Property<Number> property) {
        this(target, modifier, mouseButton, orientation, property, 1.0);
    }

    public void detach() {
        this.target.removeEventHandler(MouseEvent.ANY, this.mouseEventHandler);
        this.target.removeEventHandler(KeyEvent.ANY, this.keyboardEventHandler);
    }

    public DragSupport(Scene target, KeyCode modifier, Orientation orientation, Property<Number> property, double factor) {
        this(target, modifier, MouseButton.PRIMARY, orientation, property, factor);
    }

    public DragSupport(Scene target, KeyCode modifier, MouseButton mouseButton, Orientation orientation, Property<Number> property, double factor) {
        this.target = target;
        this.mouseEventHandler = t -> {
            if (t.getEventType() != MouseEvent.MOUSE_ENTERED_TARGET && t.getEventType() != MouseEvent.MOUSE_EXITED_TARGET) {
                this.lastMouseEvent = t;
            }
            if (t.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (t.getButton() == mouseButton && this.isModifierCorrect((MouseEvent)t, modifier)) {
                    this.anchor = (Number)property.getValue();
                    this.dragAnchor = this.getCoord((MouseEvent)t, orientation);
                    t.consume();
                }
            } else if (t.getEventType() == MouseEvent.MOUSE_DRAGGED && t.getButton() == mouseButton && this.isModifierCorrect((MouseEvent)t, modifier)) {
                property.setValue((Object)(this.anchor.doubleValue() + (this.getCoord((MouseEvent)t, orientation) - this.dragAnchor) * factor));
                t.consume();
            }
        };
        this.keyboardEventHandler = t -> {
            if (t.getEventType() == KeyEvent.KEY_PRESSED) {
                if (t.getCode() == modifier) {
                    this.anchor = (Number)property.getValue();
                    if (this.lastMouseEvent != null) {
                        this.dragAnchor = this.getCoord(this.lastMouseEvent, orientation);
                    }
                    t.consume();
                }
            } else if (t.getEventType() == KeyEvent.KEY_RELEASED && t.getCode() != modifier && this.isModifierCorrect((KeyEvent)t, modifier)) {
                this.anchor = (Number)property.getValue();
                if (this.lastMouseEvent != null) {
                    this.dragAnchor = this.getCoord(this.lastMouseEvent, orientation);
                }
                t.consume();
            }
        };
        target.addEventHandler(MouseEvent.ANY, this.mouseEventHandler);
        target.addEventHandler(KeyEvent.ANY, this.keyboardEventHandler);
    }

    private boolean isModifierCorrect(KeyEvent t, KeyCode keyCode) {
        return keyCode != KeyCode.ALT ^ t.isAltDown() && keyCode != KeyCode.CONTROL ^ t.isControlDown() && keyCode != KeyCode.SHIFT ^ t.isShiftDown() && keyCode != KeyCode.META ^ t.isMetaDown();
    }

    private boolean isModifierCorrect(MouseEvent t, KeyCode keyCode) {
        return keyCode != KeyCode.ALT ^ t.isAltDown() && keyCode != KeyCode.CONTROL ^ t.isControlDown() && keyCode != KeyCode.SHIFT ^ t.isShiftDown() && keyCode != KeyCode.META ^ t.isMetaDown();
    }

    private double getCoord(MouseEvent t, Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return t.getScreenX();
            }
            case VERTICAL: {
                return t.getScreenY();
            }
        }
        throw new IllegalArgumentException("This orientation is not supported: " + orientation);
    }
}

