/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.javacad;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JavaCadBuildInfo {
    private static final String NAME = "Neuron Robotics SDK " + JavaCadBuildInfo.getProtocolVersion() + "." + JavaCadBuildInfo.getSDKVersion() + "(" + JavaCadBuildInfo.getBuildVersion() + ")";

    public static String getVersion() {
        String s = JavaCadBuildInfo.getTag("app.version");
        if (s == null) {
            s = "0.0.0";
        }
        return s;
    }

    public static int getProtocolVersion() {
        return JavaCadBuildInfo.getBuildInfo()[0];
    }

    public static int getSDKVersion() {
        return JavaCadBuildInfo.getBuildInfo()[1];
    }

    public static int getBuildVersion() {
        return JavaCadBuildInfo.getBuildInfo()[2];
    }

    public static int[] getBuildInfo() {
        String s = JavaCadBuildInfo.getVersion();
        String[] splits = s.split("[.]+");
        int[] rev = new int[3];
        for (int i = 0; i < 3; ++i) {
            rev[i] = new Integer(splits[i]);
        }
        return rev;
    }

    private static String getTag(String target) {
        try {
            String s = "";
            InputStream is = JavaCadBuildInfo.getBuildPropertiesStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while (null != (line = br.readLine())) {
                    s = s + line + "\n";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String[] splitAll = s.split("[\n]+");
            for (int i = 0; i < splitAll.length; ++i) {
                if (!splitAll[i].contains(target)) continue;
                String[] split = splitAll[i].split("[=]+");
                return split[1];
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public static String getBuildDate() {
        String s = "";
        InputStream is = JavaCadBuildInfo.class.getResourceAsStream("/META-INF/MANIFEST.MF");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while (null != (line = br.readLine())) {
                s = s + line + "\n";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private static InputStream getBuildPropertiesStream() {
        return JavaCadBuildInfo.class.getResourceAsStream("build.properties");
    }

    public static String getSDKVersionString() {
        return NAME;
    }

    public static boolean isOS64bit() {
        return System.getProperty("os.arch").indexOf("x86_64") != -1;
    }

    public static boolean isARM() {
        return System.getProperty("os.arch").toLowerCase().indexOf("arm") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") != -1;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static boolean isUnix() {
        return JavaCadBuildInfo.isLinux() || JavaCadBuildInfo.isMac();
    }
}

