/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import java.util.List;

public class RoundedCube
extends Primitive {
    private Vector3d dimensions;
    private Vector3d center;
    private boolean centered = true;
    private final PropertyStorage properties = new PropertyStorage();
    private double cornerRadius = 0.1;
    private int resolution = 8;

    public RoundedCube() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.dimensions = new Vector3d(1.0, 1.0, 1.0);
    }

    public RoundedCube(double size) {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.dimensions = new Vector3d(size, size, size);
    }

    public RoundedCube(LengthParameter w, LengthParameter h, LengthParameter d) {
        this(Vector3d.ZERO, new Vector3d(w.getMM(), h.getMM(), d.getMM()));
        this.parametrics.add(w);
        this.parametrics.add(h);
        this.parametrics.add(d);
    }

    public RoundedCube(LengthParameter size) {
        this(size, size, size);
    }

    public RoundedCube(Vector3d center, Vector3d dimensions) {
        this.center = center;
        this.dimensions = dimensions;
    }

    public RoundedCube(double w, double h, double d) {
        this(Vector3d.ZERO, new Vector3d(w, h, d));
    }

    @Override
    public List<Polygon> toPolygons() {
        CSG spherePrototype = new Sphere(this.getCornerRadius(), this.getResolution() * 2, this.getResolution()).toCSG();
        double x = this.dimensions.x / 2.0 - this.getCornerRadius();
        double y = this.dimensions.y / 2.0 - this.getCornerRadius();
        double z = this.dimensions.z / 2.0 - this.getCornerRadius();
        CSG sphere1 = spherePrototype.transformed(Transform.unity().translate(-x, -y, -z));
        CSG sphere2 = spherePrototype.transformed(Transform.unity().translate(x, -y, -z));
        CSG sphere3 = spherePrototype.transformed(Transform.unity().translate(x, y, -z));
        CSG sphere4 = spherePrototype.transformed(Transform.unity().translate(-x, y, -z));
        CSG sphere5 = spherePrototype.transformed(Transform.unity().translate(-x, -y, z));
        CSG sphere6 = spherePrototype.transformed(Transform.unity().translate(x, -y, z));
        CSG sphere7 = spherePrototype.transformed(Transform.unity().translate(x, y, z));
        CSG sphere8 = spherePrototype.transformed(Transform.unity().translate(-x, y, z));
        List<Polygon> result = sphere1.union(sphere2, sphere3, sphere4, sphere5, sphere6, sphere7, sphere8).hull().getPolygons();
        if (!this.centered) {
            Transform centerTransform = Transform.unity().translate(this.dimensions.x / 2.0, this.dimensions.y / 2.0, this.dimensions.z / 2.0);
            for (Polygon p : result) {
                p.transform(centerTransform);
            }
        }
        return result;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public void setCenter(Vector3d center) {
        this.center = center;
    }

    public Vector3d getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Vector3d dimensions) {
        this.dimensions = dimensions;
    }

    public RoundedCube noCenter() {
        this.centered = false;
        return this;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public RoundedCube resolution(int resolution) {
        this.resolution = resolution;
        return this;
    }

    public double getCornerRadius() {
        return this.cornerRadius;
    }

    public void setCornerRadius(double cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public RoundedCube cornerRadius(double cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
    }
}

