/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.WeightFunction;

public class YModifier
implements WeightFunction {
    private Bounds bounds;
    private double min = 0.0;
    private double max = 1.0;
    private double sPerUnit;
    private boolean centered;

    public YModifier() {
    }

    public YModifier(boolean centered) {
        this.centered = centered;
    }

    @Override
    public double eval(Vector3d pos, CSG csg) {
        if (this.bounds == null) {
            this.bounds = csg.getBounds();
            this.sPerUnit = (this.max - this.min) / (this.bounds.getMax().y - this.bounds.getMin().y);
        }
        double s = this.sPerUnit * (pos.y - this.bounds.getMin().y);
        if (this.centered) {
            s -= (this.max - this.min) / 2.0;
            s = Math.abs(s) * 2.0;
        }
        return s;
    }
}

