/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.imagej;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.vecmath.Point3f;

public class STLLoader {
    String line;
    BufferedReader in;
    private ArrayList<Point3f> vertices = new ArrayList();
    private Point3f normal = new Point3f(0.0f, 0.0f, 0.0f);
    private FileInputStream fis;
    private int triangles;

    public ArrayList<Point3f> parse(File f) throws IOException {
        this.vertices.clear();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            String[] words = line.trim().split("\\s+");
            if (line.indexOf(0) < 0 && words[0].equalsIgnoreCase("solid")) {
                this.parseAscii(f);
                br.close();
                return this.vertices;
            }
            br.close();
        }
        catch (NullPointerException br) {
            // empty catch block
        }
        FileInputStream fs = new FileInputStream(f);
        byte[] buffer = new byte[84];
        fs.read(buffer, 0, 84);
        fs.close();
        this.triangles = (buffer[83] & 0xFF) << 24 | (buffer[82] & 0xFF) << 16 | (buffer[81] & 0xFF) << 8 | buffer[80] & 0xFF;
        if ((f.length() - 84L) / 50L == (long)this.triangles) {
            this.parseBinary(f);
            return this.vertices;
        }
        System.err.println("File is not a valid STL");
        return this.vertices;
    }

    private void parseAscii(File f) {
        try {
            this.in = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.vertices = new ArrayList();
        try {
            while ((this.line = this.in.readLine()) != null) {
                String[] numbers = this.line.trim().split("\\s+");
                if (numbers[0].equals("vertex")) {
                    float x = this.parseFloat(numbers[1]);
                    float y = this.parseFloat(numbers[2]);
                    float z = this.parseFloat(numbers[3]);
                    Point3f vertex = new Point3f(x, y, z);
                    this.vertices.add(vertex);
                    continue;
                }
                if (!numbers[0].equals("facet") || !numbers[1].equals("normal")) continue;
                this.normal.x = this.parseFloat(numbers[2]);
                this.normal.y = this.parseFloat(numbers[3]);
                this.normal.z = this.parseFloat(numbers[4]);
            }
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void parseBinary(File f) {
        this.vertices = new ArrayList();
        try {
            this.fis = new FileInputStream(f);
            for (int h = 0; h < 84; ++h) {
                this.fis.read();
            }
            for (int t = 0; t < this.triangles; ++t) {
                byte[] tri = new byte[50];
                for (int tb = 0; tb < 50; ++tb) {
                    tri[tb] = (byte)this.fis.read();
                }
                this.normal.x = this.leBytesToFloat(tri[0], tri[1], tri[2], tri[3]);
                this.normal.y = this.leBytesToFloat(tri[4], tri[5], tri[6], tri[7]);
                this.normal.z = this.leBytesToFloat(tri[8], tri[9], tri[10], tri[11]);
                for (int i = 0; i < 3; ++i) {
                    int j = i * 12 + 12;
                    float px = this.leBytesToFloat(tri[j], tri[j + 1], tri[j + 2], tri[j + 3]);
                    float py = this.leBytesToFloat(tri[j + 4], tri[j + 5], tri[j + 6], tri[j + 7]);
                    float pz = this.leBytesToFloat(tri[j + 8], tri[j + 9], tri[j + 10], tri[j + 11]);
                    Point3f p = new Point3f(px, py, pz);
                    this.vertices.add(p);
                }
            }
            this.fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private float parseFloat(String string) throws ParseException {
        return Float.parseFloat(string);
    }

    private float leBytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        return Float.intBitsToFloat((b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF);
    }
}

