/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Slice;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.List;

public class Fillet
extends Primitive {
    double w;
    double h;
    private final PropertyStorage properties = new PropertyStorage();

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public Fillet(double w, double h) {
        this.w = w;
        this.h = h;
    }

    public static CSG corner(double rad, double angle) {
        return CSG.unionAll(Extrude.revolve(new Fillet(rad, 0.01).toCSG().rotz(-90), 0.0, angle, 4)).difference(Extrude.revolve(new Sphere(rad).toCSG().toYMin().toZMin(), 0.0, angle, 4));
    }

    public static CSG outerFillet(CSG base, double rad) {
        List<Polygon> polys = Slice.slice(base);
        return base.union(Fillet.outerFillet(polys, rad));
    }

    public static CSG outerFillet(List<Polygon> polys, double rad) {
        ArrayList<CSG> parts = new ArrayList<CSG>();
        for (Polygon p : polys) {
            int size = p.vertices.size();
            for (int i = 0; i < size; ++i) {
                int nextNext;
                int next = i + 1;
                if (next == size) {
                    next = 0;
                }
                if ((nextNext = next + 1) == size) {
                    nextNext = 0;
                }
                Vector3d position0 = p.vertices.get((int)i).pos;
                Vector3d position1 = p.vertices.get((int)next).pos;
                Vector3d position2 = p.vertices.get((int)nextNext).pos;
                Vector3d seg1 = position0.minus(position1);
                Vector3d seg2 = position2.minus(position1);
                double len = seg1.magnitude();
                double angle = Math.toDegrees(seg1.angle(seg2));
                double angleAbs = Math.toDegrees(seg1.angle(Vector3d.Y_ONE));
                CSG fillet = new Fillet(rad, len).toCSG().toYMax();
                if (seg1.x < 0.0) {
                    angleAbs = 360.0 - angleAbs;
                }
                if (Math.abs(angle) > 0.01 && Math.abs(angle) < 180.0) {
                    parts.add(Fillet.corner(rad, angle).rotz(angleAbs).move(position0));
                }
                parts.add(fillet.rotz(angleAbs).move(position0));
            }
        }
        return CSG.unionAll(parts);
    }

    @Override
    public List<Polygon> toPolygons() {
        CSG simpleSyntax = new Cylinder(this.w, this.h + 1.0).toCSG().rotx(90).toXMin().toZMin().movey(-0.5);
        CSG cubeSection = new Cube(this.w - 0.1, this.h, this.w - 0.1).toCSG().toXMin().toZMin().toYMin();
        return cubeSection.difference(simpleSyntax).getPolygons();
    }
}

