/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.IPolygonDebugger;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.List;

public class Plane {
    private static IPolygonDebugger debugger = null;
    private static boolean useDebugger = false;
    public static final double EPSILON = 1.0E-9;
    public static final double EPSILON_Point = 1.0E-9;
    public static final double EPSILON_duplicate = 1.0E-4;
    public static final Plane XY_PLANE = new Plane(Vector3d.Z_ONE, 1.0);
    public static final Plane XZ_PLANE = new Plane(Vector3d.Y_ONE, 1.0);
    public static final Plane YZ_PLANE = new Plane(Vector3d.X_ONE, 1.0);
    private Vector3d normal;
    private double dist;

    public Plane(Vector3d normal, double dist) {
        this.setNormal(normal.normalized());
        this.setDist(dist);
    }

    public static Plane createFromPoints(List<Vertex> vertices) {
        Vector3d a = vertices.get((int)0).pos;
        Vector3d n = Plane.computeNormal(vertices);
        return new Plane(n, n.dot(a));
    }

    public static Vector3d computeNormal(List<Vertex> vertices) {
        double d;
        Vector3d normal = new Vector3d(0.0, 0.0, 0.0);
        int n = vertices.size();
        for (int i = 0; i < n; ++i) {
            Vector3d current = vertices.get((int)i).pos;
            Vector3d next = vertices.get((int)((i + 1) % n)).pos;
            normal.x += (current.y - next.y) * (current.z + next.z);
            normal.y += (current.z - next.z) * (current.x + next.x);
            normal.z += (current.x - next.x) * (current.y + next.y);
        }
        Vector3d normalized = normal.normalized();
        double lengthSquared = normal.lengthSquared();
        if (lengthSquared < (d = 1.0E-18)) {
            for (int i = 0; i < n - 2; ++i) {
                Vector3d a = vertices.get((int)i).pos;
                for (int j = i + 1; j < n - 1; ++j) {
                    Vector3d b = vertices.get((int)j).pos;
                    for (int k = j + 1; k < n; ++k) {
                        Vector3d c = vertices.get((int)k).pos;
                        normal = b.minus(a).cross(c.minus(a));
                        lengthSquared = normal.lengthSquared();
                        if (!(lengthSquared > d)) continue;
                        return normal.normalized();
                    }
                }
            }
        }
        if ((lengthSquared = normal.lengthSquared()) < d) {
            throw new NumberFormatException("This set of points is not a valid polygon");
        }
        return normalized;
    }

    public Plane clone() {
        return new Plane(this.getNormal().clone(), this.getDist());
    }

    public void flip() {
        this.setNormal(this.getNormal().negated());
        this.setDist(-this.getDist());
    }

    public void splitPolygon(Polygon polygon, List<Polygon> coplanarFront, List<Polygon> coplanarBack, List<Polygon> front, List<Polygon> back) {
        boolean COPLANAR = false;
        boolean FRONT = true;
        int BACK = 2;
        int SPANNING = 3;
        if (debugger == null || useDebugger) {
            // empty if block
        }
        double negEpsilon = -1.0E-9;
        double posEpsilon = 1.0E-9;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            double t = polygon.plane.getNormal().dot(polygon.vertices.get((int)i).pos) - polygon.plane.getDist();
            if (t > posEpsilon) {
                posEpsilon = t + 1.0E-9;
            }
            if (!(t < negEpsilon)) continue;
            negEpsilon = t - 1.0E-9;
        }
        int polygonType = 0;
        ArrayList<Integer> types = new ArrayList<Integer>();
        boolean somePointsInfront = false;
        boolean somePointsInBack = false;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            int type;
            double t = this.getNormal().dot(polygon.vertices.get((int)i).pos) - this.getDist();
            int n = t < negEpsilon ? 2 : (type = t > posEpsilon ? 1 : 0);
            if (type == 2) {
                somePointsInBack = true;
            }
            if (type == 1) {
                somePointsInfront = true;
            }
            types.add(type);
        }
        if (somePointsInBack && somePointsInfront) {
            polygonType = 3;
        } else if (somePointsInBack) {
            polygonType = 2;
        } else if (somePointsInfront) {
            polygonType = 1;
        }
        switch (polygonType) {
            case 0: {
                (this.getNormal().dot(polygon.plane.getNormal()) > 0.0 ? coplanarFront : coplanarBack).add(polygon);
                break;
            }
            case 1: {
                front.add(polygon);
                break;
            }
            case 2: {
                back.add(polygon);
                break;
            }
            case 3: {
                ArrayList<Vertex> f = new ArrayList<Vertex>();
                ArrayList<Vertex> b = new ArrayList<Vertex>();
                for (int i = 0; i < polygon.vertices.size(); ++i) {
                    int j = (i + 1) % polygon.vertices.size();
                    int ti = (Integer)types.get(i);
                    int tj = (Integer)types.get(j);
                    Vertex vi = polygon.vertices.get(i);
                    Vertex vj = polygon.vertices.get(j);
                    if (ti != 2) {
                        f.add(vi);
                    }
                    if (ti != 1) {
                        b.add(ti != 2 ? vi.clone() : vi);
                    }
                    if ((ti | tj) != 3) continue;
                    double t = (this.getDist() - this.getNormal().dot(vi.pos)) / this.getNormal().dot(vj.pos.minus(vi.pos));
                    Vertex v = vi.interpolate(vj, t);
                    f.add(v);
                    b.add(v.clone());
                }
                if (f.size() >= 3) {
                    try {
                        front.add(new Polygon(f, polygon.getStorage()).setColor(polygon.getColor()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    System.out.println("Front Clip Fault!");
                }
                if (b.size() >= 3) {
                    try {
                        back.add(new Polygon(b, polygon.getStorage()).setColor(polygon.getColor()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                System.out.println("Back Clip Fault!");
            }
        }
    }

    public static IPolygonDebugger getDebugger() {
        return debugger;
    }

    public static void setDebugger(IPolygonDebugger debugger) {
        Plane.debugger = debugger;
    }

    public static boolean isUseDebugger() {
        return useDebugger;
    }

    public static void setUseDebugger(boolean useDebugger) {
        Plane.useDebugger = useDebugger;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3d normal) {
        if (!(Double.isFinite(normal.x) && Double.isFinite(normal.y) && Double.isFinite(normal.z))) {
            NumberFormatException numberFormatException = new NumberFormatException();
            throw numberFormatException;
        }
        this.normal = normal;
    }

    public double getDist() {
        return this.dist;
    }

    public void setDist(double dist) {
        if (!Double.isFinite(dist)) {
            NumberFormatException numberFormatException = new NumberFormatException();
            throw numberFormatException;
        }
        this.dist = dist;
    }
}

