/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ObjFile {
    private String obj;
    private final String mtl;
    private InputStream objStream;
    private InputStream mtlStream;
    static final String MTL_NAME = "$JCSG_MTL_NAME$";

    ObjFile(String obj, String mtl) {
        this.obj = obj;
        this.mtl = mtl;
    }

    public void toFiles(Path p) throws IOException {
        Path parent = p.getParent();
        String fileName = p.getFileName().toString();
        if (fileName.toLowerCase().endsWith(".obj") || fileName.toLowerCase().endsWith(".mtl")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        String objName = fileName + ".obj";
        String mtlName = fileName + ".mtl";
        this.obj = this.obj.replace(MTL_NAME, mtlName);
        this.objStream = null;
        if (parent == null) {
            FileUtil.write(Paths.get(objName, new String[0]), this.obj);
            FileUtil.write(Paths.get(mtlName, new String[0]), this.mtl);
        } else {
            FileUtil.write(Paths.get(parent.toString(), objName), this.obj);
            FileUtil.write(Paths.get(parent.toString(), mtlName), this.mtl);
        }
    }

    public String getObj() {
        return this.obj;
    }

    public String getMtl() {
        return this.mtl;
    }

    public InputStream getObjStream() {
        if (this.objStream == null) {
            this.objStream = new ByteArrayInputStream(this.obj.getBytes(StandardCharsets.UTF_8));
        }
        return this.objStream;
    }

    public InputStream getMtlStream() {
        if (this.mtlStream == null) {
            this.mtlStream = new ByteArrayInputStream(this.mtl.getBytes(StandardCharsets.UTF_8));
        }
        return this.mtlStream;
    }
}

