/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.quickhull3d;

import java.util.Random;

class Vector3d {
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(Vector3d v) {
        this.set(v);
    }

    public Vector3d(double x, double y, double z) {
        this.set(x, y, z);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    public void set(int i, double value) {
        if (Double.isNaN(value)) {
            throw new NumberFormatException("value is NaN");
        }
        switch (i) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(i);
            }
        }
    }

    public void set(Vector3d v1) {
        this.set(v1.x, v1.y, v1.z);
    }

    public void add(Vector3d v1, Vector3d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
    }

    public void add(Vector3d v1) {
        this.x += v1.x;
        this.y += v1.y;
        this.z += v1.z;
    }

    public void sub(Vector3d v1, Vector3d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
    }

    public void sub(Vector3d v1) {
        this.x -= v1.x;
        this.y -= v1.y;
        this.z -= v1.z;
    }

    public void scale(double s) {
        this.x = s * this.x;
        this.y = s * this.y;
        this.z = s * this.z;
    }

    public void scale(double s, Vector3d v1) {
        this.x = s * v1.x;
        this.y = s * v1.y;
        this.z = s * v1.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double normSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3d v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSquared(Vector3d v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double dot(Vector3d v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z;
    }

    public void normalize() {
        double lenSqr = this.x * this.x + this.y * this.y + this.z * this.z;
        if (Double.isNaN(lenSqr)) {
            throw new NumberFormatException("Normal is NaN" + lenSqr);
        }
        double err = lenSqr - 1.0;
        if (err > 4.440892098500626E-16 || err < -4.440892098500626E-16) {
            double len = Math.sqrt(lenSqr);
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public void setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void set(double x, double y, double z) {
        if (Double.isNaN(x)) {
            throw new NumberFormatException("X is NaN");
        }
        if (Double.isNaN(y)) {
            throw new NumberFormatException("Y is NaN");
        }
        if (Double.isNaN(z)) {
            throw new NumberFormatException("Z is NaN");
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void cross(Vector3d v1, Vector3d v2) {
        double tmpx = v1.y * v2.z - v1.z * v2.y;
        double tmpy = v1.z * v2.x - v1.x * v2.z;
        double tmpz = v1.x * v2.y - v1.y * v2.x;
        this.x = tmpx;
        this.y = tmpy;
        this.z = tmpz;
    }

    protected void setRandom(double lower, double upper, Random generator) {
        double range = upper - lower;
        this.x = generator.nextDouble() * range + lower;
        this.y = generator.nextDouble() * range + lower;
        this.z = generator.nextDouble() * range + lower;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }
}

