/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.parametrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.mihosoft.vrl.v3d.parametrics.IParameterChanged;
import eu.mihosoft.vrl.v3d.parametrics.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CSGDatabase {
    private static ConcurrentHashMap<String, Parameter> database = null;
    private static File dbFile = new File("CSGdatabase.json");
    private static final Type TT_mapStringString = new TypeToken<ConcurrentHashMap<String, Parameter>>(){}.getType();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> parameterListeners = new ConcurrentHashMap();

    public static void set(String key, Parameter value) {
        CSGDatabase.getDatabase();
        CSGDatabase.getDatabase().put(key, value);
    }

    public static Parameter get(String key) {
        Parameter ret = null;
        CSGDatabase.getDatabase();
        ret = CSGDatabase.getDatabase().get(key);
        return ret;
    }

    public static void clear() {
        CSGDatabase.getDatabase();
        database.clear();
        parameterListeners.clear();
        CSGDatabase.saveDatabase();
    }

    public static void addParameterListener(String key, IParameterChanged l) {
        CopyOnWriteArrayList<IParameterChanged> list = CSGDatabase.getParamListeners(key);
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearParameterListeners(String key) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> concurrentHashMap = parameterListeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<IParameterChanged> back = parameterListeners.get(key);
            if (back == null) {
                back = new CopyOnWriteArrayList();
                parameterListeners.put(key, back);
            }
            back.clear();
        }
    }

    public static void removeParameterListener(String key, IParameterChanged l) {
        if (parameterListeners.get(key) == null) {
            return;
        }
        CopyOnWriteArrayList<IParameterChanged> list = parameterListeners.get(key);
        if (list.contains(l)) {
            list.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyOnWriteArrayList<IParameterChanged> getParamListeners(String key) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> concurrentHashMap = parameterListeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<IParameterChanged> back = parameterListeners.get(key);
            if (back == null) {
                back = new CopyOnWriteArrayList();
                parameterListeners.put(key, back);
            }
            return back;
        }
    }

    public static void delete(String key) {
        CSGDatabase.getDatabase().remove(key);
    }

    private static ConcurrentHashMap<String, Parameter> getDatabase() {
        if (database == null) {
            new Thread(){

                @Override
                public void run() {
                    block7: {
                        try {
                            String jsonString;
                            if (!CSGDatabase.getDbFile().exists()) {
                                CSGDatabase.setDatabase(new ConcurrentHashMap());
                                break block7;
                            }
                            FileInputStream in = null;
                            try {
                                in = FileUtils.openInputStream((File)CSGDatabase.getDbFile());
                                jsonString = IOUtils.toString((InputStream)in);
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)in);
                            }
                            ConcurrentHashMap tm = (ConcurrentHashMap)gson.fromJson(jsonString, TT_mapStringString);
                            if (tm != null) {
                                CSGDatabase.setDatabase(tm);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println(dbFile.getAbsolutePath());
                            CSGDatabase.setDatabase(new ConcurrentHashMap());
                        }
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            CSGDatabase.saveDatabase();
                        }
                    });
                }
            }.start();
            long start = System.currentTimeMillis();
            while (database == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (System.currentTimeMillis() - start <= 500L) continue;
                CSGDatabase.setDatabase(new ConcurrentHashMap<String, Parameter>());
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDatabaseFromFile(File f) {
        FileInputStream in = null;
        try {
            try {
                in = FileUtils.openInputStream((File)f);
                String jsonString = IOUtils.toString((InputStream)in);
                ConcurrentHashMap tm = (ConcurrentHashMap)gson.fromJson(jsonString, TT_mapStringString);
                if (tm != null) {
                    for (String k : tm.keySet()) {
                        CSGDatabase.set(k, (Parameter)tm.get(k));
                    }
                }
                CSGDatabase.saveDatabase();
            }
            catch (Exception e) {
                System.err.println(f.getAbsolutePath());
                e.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getDataBaseString() {
        String writeOut = null;
        CSGDatabase.getDatabase();
        writeOut = gson.toJson(database, TT_mapStringString);
        return writeOut;
    }

    public static void saveDatabase() {
        String writeOut = CSGDatabase.getDataBaseString();
        try {
            if (!CSGDatabase.getDbFile().exists()) {
                CSGDatabase.getDbFile().createNewFile();
            }
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)CSGDatabase.getDbFile(), (boolean)false);
                IOUtils.write((String)writeOut, (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setDatabase(ConcurrentHashMap<String, Parameter> database) {
        if (CSGDatabase.database != null) {
            return;
        }
        CSGDatabase.database = database;
    }

    public static File getDbFile() {
        return dbFile;
    }

    public static void setDbFile(File dbFile) {
        if (!dbFile.exists()) {
            try {
                dbFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CSGDatabase.dbFile = dbFile;
        CSGDatabase.loadDatabaseFromFile(dbFile);
    }
}

