/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj;

import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.ObjImporter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;

public class MtlReader {
    private String baseUrl;
    private Map<String, Material> materials = new HashMap<String, Material>();
    private PhongMaterial material = new PhongMaterial();
    private boolean modified = false;

    public MtlReader(String filename, String parentUrl) {
        this.baseUrl = parentUrl.substring(0, parentUrl.lastIndexOf(47) + 1);
        String fileUrl = this.baseUrl + filename;
        try {
            URL mtlUrl = new URL(fileUrl);
            ObjImporter.log("Reading material from filename = " + mtlUrl);
            this.read(mtlUrl.openStream());
        }
        catch (FileNotFoundException mtlUrl) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public MtlReader(InputStream stream) {
        try {
            ObjImporter.log("Reading material from stream");
            this.read(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void read(InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String name = "default";
        while ((line = br.readLine()) != null) {
            try {
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("newmtl ")) {
                    this.addMaterial(name);
                    name = line.substring("newmtl ".length());
                    continue;
                }
                if (line.startsWith("Kd ")) {
                    this.material.setDiffuseColor(this.readColor(line.substring(3)));
                    this.modified = true;
                    continue;
                }
                if (line.startsWith("Ks ")) {
                    this.material.setSpecularColor(this.readColor(line.substring(3)));
                    this.modified = true;
                    continue;
                }
                if (line.startsWith("Ns ")) {
                    this.material.setSpecularPower(Double.parseDouble(line.substring(3)));
                    this.modified = true;
                    continue;
                }
                if (line.startsWith("map_Kd ")) {
                    this.material.setDiffuseColor(Color.WHITE);
                    this.material.setDiffuseMap(this.loadImage(line.substring("map_Kd ".length())));
                    this.modified = true;
                    continue;
                }
                ObjImporter.log("material line ignored for " + name + ": " + line);
            }
            catch (Exception ex) {
                Logger.getLogger(MtlReader.class.getName()).log(Level.SEVERE, "Failed to parse line:" + line, ex);
            }
        }
        this.addMaterial(name);
    }

    private void addMaterial(String name) {
        if (this.modified) {
            if (!this.materials.containsKey(name)) {
                this.materials.put(name, (Material)this.material);
            } else {
                ObjImporter.log("This material is already added. Ignoring " + name);
            }
            this.material = new PhongMaterial(Color.WHITE);
        }
    }

    private Color readColor(String line) {
        String[] split = line.trim().split(" +");
        float red = Float.parseFloat(split[0]);
        float green = Float.parseFloat(split[1]);
        float blue = Float.parseFloat(split[2]);
        return Color.color((double)red, (double)green, (double)blue);
    }

    private Image loadImage(String filename) {
        filename = this.baseUrl + filename;
        ObjImporter.log("Loading image from " + filename);
        Image image = new Image(filename);
        return new Image(filename);
    }

    public Map<String, Material> getMaterials() {
        return Collections.unmodifiableMap(this.materials);
    }
}

