/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.IPolygonDebugger;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.List;

public class Plane {
    private static IPolygonDebugger debugger = null;
    private static boolean useDebugger = false;
    public static final double EPSILON = 1.0E-9;
    public static final double EPSILON_Point = 1.0E-9;
    public static final double EPSILON_duplicate = 1.0E-4;
    public static final Plane XY_PLANE = new Plane(Vector3d.Z_ONE, 1.0);
    public static final Plane XZ_PLANE = new Plane(Vector3d.Y_ONE, 1.0);
    public static final Plane YZ_PLANE = new Plane(Vector3d.X_ONE, 1.0);
    private Vector3d normal;
    private double dist;

    public Plane(Vector3d normal, double dist) {
        this.setNormal(normal.normalized());
        this.setDist(dist);
    }

    public static Plane createFromPoints(List<Vertex> vertices) {
        Vector3d a = vertices.get((int)0).pos;
        Vector3d n = Plane.computeNormal(vertices);
        return new Plane(n, n.dot(a));
    }

    public static Vector3d computeNormal(List<Vertex> vertices) {
        if (vertices == null || vertices.size() < 3) {
            return new Vector3d(0.0, 0.0, 1.0);
        }
        Vector3d normal = new Vector3d(0.0, 0.0, 0.0);
        int n = vertices.size();
        for (int i = 0; i < n; ++i) {
            Vector3d current = vertices.get((int)i).pos;
            Vector3d next = vertices.get((int)((i + 1) % n)).pos;
            normal.x += (current.y - next.y) * (current.z + next.z);
            normal.y += (current.z - next.z) * (current.x + next.x);
            normal.z += (current.x - next.x) * (current.y + next.y);
        }
        if (Plane.isValidNormal(normal, 1.0E-9)) {
            return normal.normalized();
        }
        normal = Plane.findNormalFromNonColinearPoints(vertices);
        if (normal != null) {
            return normal;
        }
        normal = Plane.findPrincipalDirection(vertices);
        if (normal != null) {
            return normal;
        }
        return Plane.determineStatisticalNormal(vertices);
    }

    private static boolean isValidNormal(Vector3d normal, double epsilon) {
        double lengthSquared = normal.lengthSquared();
        return lengthSquared >= epsilon * epsilon;
    }

    private static Vector3d findNormalFromNonColinearPoints(List<Vertex> vertices) {
        int n = vertices.size();
        Vector3d firstPoint = vertices.get((int)0).pos;
        for (int i = 1; i < n; ++i) {
            Vector3d v1 = vertices.get((int)i).pos.minus(firstPoint);
            for (int j = i + 1; j < n; ++j) {
                Vector3d v2 = vertices.get((int)j).pos.minus(firstPoint);
                Vector3d cross = v1.cross(v2);
                if (!Plane.isValidNormal(cross, 1.0E-9)) continue;
                return cross.normalized();
            }
        }
        return null;
    }

    private static Vector3d findPrincipalDirection(List<Vertex> vertices) {
        double maxX = Double.NEGATIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        for (Vertex vertex : vertices) {
            Vector3d pos = vertex.pos;
            maxX = Math.max(maxX, pos.x);
            minX = Math.min(minX, pos.x);
            maxY = Math.max(maxY, pos.y);
            minY = Math.min(minY, pos.y);
            maxZ = Math.max(maxZ, pos.z);
            minZ = Math.min(minZ, pos.z);
        }
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        double rangeZ = maxZ - minZ;
        if (rangeX <= rangeY && rangeX <= rangeZ) {
            return new Vector3d(1.0, 0.0, 0.0);
        }
        if (rangeY <= rangeX && rangeY <= rangeZ) {
            return new Vector3d(0.0, 1.0, 0.0);
        }
        return new Vector3d(0.0, 0.0, 1.0);
    }

    /*
     * WARNING - void declaration
     */
    private static Vector3d determineStatisticalNormal(List<Vertex> vertices) {
        void var3_6;
        Vector3d center = new Vector3d(0.0, 0.0, 0.0);
        for (Vertex vertex : vertices) {
            center = center.plus(vertex.pos);
        }
        center = center.times(1.0 / (double)vertices.size());
        double[][] covariance = new double[3][3];
        for (Vertex vertex : vertices) {
            Vector3d diff = vertex.pos.minus(center);
            double[] dArray = covariance[0];
            dArray[0] = dArray[0] + diff.x * diff.x;
            double[] dArray2 = covariance[0];
            dArray2[1] = dArray2[1] + diff.x * diff.y;
            double[] dArray3 = covariance[0];
            dArray3[2] = dArray3[2] + diff.x * diff.z;
            double[] dArray4 = covariance[1];
            dArray4[1] = dArray4[1] + diff.y * diff.y;
            double[] dArray5 = covariance[1];
            dArray5[2] = dArray5[2] + diff.y * diff.z;
            double[] dArray6 = covariance[2];
            dArray6[2] = dArray6[2] + diff.z * diff.z;
        }
        covariance[1][0] = covariance[0][1];
        covariance[2][0] = covariance[0][2];
        covariance[2][1] = covariance[1][2];
        Vector3d vector3d = new Vector3d(1.0, 1.0, 1.0);
        for (int i = 0; i < 10; ++i) {
            Vector3d vector3d3 = Plane.multiplyMatrixVector(covariance, (Vector3d)var3_6);
            vector3d3 = vector3d3.normalized();
        }
        return var3_6;
    }

    private static Vector3d multiplyMatrixVector(double[][] matrix, Vector3d vector) {
        return new Vector3d(matrix[0][0] * vector.x + matrix[0][1] * vector.y + matrix[0][2] * vector.z, matrix[1][0] * vector.x + matrix[1][1] * vector.y + matrix[1][2] * vector.z, matrix[2][0] * vector.x + matrix[2][1] * vector.y + matrix[2][2] * vector.z);
    }

    public Plane clone() {
        return new Plane(this.getNormal().clone(), this.getDist());
    }

    public void flip() {
        this.setNormal(this.getNormal().negated());
        this.setDist(-this.getDist());
    }

    public void splitPolygon(Polygon polygon, List<Polygon> coplanarFront, List<Polygon> coplanarBack, List<Polygon> front, List<Polygon> back) {
        boolean COPLANAR = false;
        boolean FRONT = true;
        int BACK = 2;
        int SPANNING = 3;
        if (debugger == null || useDebugger) {
            // empty if block
        }
        double negEpsilon = -1.0E-9;
        double posEpsilon = 1.0E-9;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            double t = polygon.plane.getNormal().dot(polygon.vertices.get((int)i).pos) - polygon.plane.getDist();
            if (t > posEpsilon) {
                posEpsilon = t + 1.0E-9;
            }
            if (!(t < negEpsilon)) continue;
            negEpsilon = t - 1.0E-9;
        }
        int polygonType = 0;
        ArrayList<Integer> types = new ArrayList<Integer>();
        boolean somePointsInfront = false;
        boolean somePointsInBack = false;
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            int type;
            double t = this.getNormal().dot(polygon.vertices.get((int)i).pos) - this.getDist();
            int n = t < negEpsilon ? 2 : (type = t > posEpsilon ? 1 : 0);
            if (type == 2) {
                somePointsInBack = true;
            }
            if (type == 1) {
                somePointsInfront = true;
            }
            types.add(type);
        }
        if (somePointsInBack && somePointsInfront) {
            polygonType = 3;
        } else if (somePointsInBack) {
            polygonType = 2;
        } else if (somePointsInfront) {
            polygonType = 1;
        }
        switch (polygonType) {
            case 0: {
                (this.getNormal().dot(polygon.plane.getNormal()) > 0.0 ? coplanarFront : coplanarBack).add(polygon);
                break;
            }
            case 1: {
                front.add(polygon);
                break;
            }
            case 2: {
                back.add(polygon);
                break;
            }
            case 3: {
                ArrayList<Vertex> f = new ArrayList<Vertex>();
                ArrayList<Vertex> b = new ArrayList<Vertex>();
                for (int i = 0; i < polygon.vertices.size(); ++i) {
                    int j = (i + 1) % polygon.vertices.size();
                    int ti = (Integer)types.get(i);
                    int tj = (Integer)types.get(j);
                    Vertex vi = polygon.vertices.get(i);
                    Vertex vj = polygon.vertices.get(j);
                    if (ti != 2) {
                        f.add(vi);
                    }
                    if (ti != 1) {
                        b.add(ti != 2 ? vi.clone() : vi);
                    }
                    if ((ti | tj) != 3) continue;
                    double t = (this.getDist() - this.getNormal().dot(vi.pos)) / this.getNormal().dot(vj.pos.minus(vi.pos));
                    Vertex v = vi.interpolate(vj, t);
                    f.add(v);
                    b.add(v.clone());
                }
                if (f.size() >= 3) {
                    try {
                        front.add(new Polygon(f, polygon.getStorage()).setColor(polygon.getColor()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (b.size() < 3) break;
                try {
                    back.add(new Polygon(b, polygon.getStorage()).setColor(polygon.getColor()));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static IPolygonDebugger getDebugger() {
        return debugger;
    }

    public static void setDebugger(IPolygonDebugger debugger) {
        Plane.debugger = debugger;
    }

    public static boolean isUseDebugger() {
        return useDebugger;
    }

    public static void setUseDebugger(boolean useDebugger) {
        Plane.useDebugger = useDebugger;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3d normal) {
        if (!(Double.isFinite(normal.x) && Double.isFinite(normal.y) && Double.isFinite(normal.z))) {
            NumberFormatException numberFormatException = new NumberFormatException();
            throw numberFormatException;
        }
        this.normal = normal;
    }

    public double getDist() {
        return this.dist;
    }

    public void setDist(double dist) {
        if (!Double.isFinite(dist)) {
            NumberFormatException numberFormatException = new NumberFormatException();
            throw numberFormatException;
        }
        this.dist = dist;
    }
}

