/*
 * Decompiled with CFR 0.152.
 */
package com.piro.bezier;

import com.piro.bezier.Bezier;
import com.piro.bezier.BezierListProducer;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BezierPath {
    static final Matcher matchPoint = Pattern.compile("\\s*(\\d+)[^\\d]+(\\d+)\\s*").matcher("");
    BezierListProducer path;
    private ArrayList<Vector3d> plInternal = new ArrayList();
    double resolution = 0.075;

    public BezierPath() {
    }

    public BezierPath(String path) {
        this.parsePathString(path);
    }

    public void parsePathString(String d) {
        this.path = new BezierListProducer();
        this.parsePathList(d);
    }

    protected void parsePathList(String list) {
        Matcher matchPathCmd = Pattern.compile("([MmLlHhVvAaQqTtCcSsZz])|([-+]?((\\d*\\.\\d+)|(\\d+))([eE][-+]?\\d+)?)").matcher(list);
        LinkedList<String> tokens = new LinkedList<String>();
        while (matchPathCmd.find()) {
            tokens.addLast(matchPathCmd.group());
        }
        int curCmd = 90;
        block22: while (tokens.size() != 0) {
            String curToken = (String)tokens.removeFirst();
            char initChar = curToken.charAt(0);
            if (initChar >= 'A' && initChar <= 'Z' || initChar >= 'a' && initChar <= 'z') {
                curCmd = initChar;
            } else {
                tokens.addFirst(curToken);
            }
            switch (curCmd) {
                case 77: {
                    float x = BezierPath.nextFloat(tokens);
                    float y = BezierPath.nextFloat(tokens);
                    this.path.movetoAbs(x, y);
                    this.setThePoint(new Vector3d(x, y, 0.0));
                    curCmd = 76;
                    break;
                }
                case 109: {
                    float x = BezierPath.nextFloat(tokens);
                    float y = BezierPath.nextFloat(tokens);
                    this.path.movetoRel(x, y);
                    this.setThePoint(new Vector3d(x, y, 0.0));
                    curCmd = 108;
                    break;
                }
                case 76: {
                    this.path.linetoAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 108: {
                    this.path.linetoRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 72: {
                    this.path.linetoHorizontalAbs(BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 104: {
                    this.path.linetoHorizontalRel(BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 86: {
                    this.path.linetoVerticalAbs(BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 118: {
                    this.path.linetoVerticalAbs(BezierPath.nextFloat(tokens));
                    this.setThePoint(this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(1.0));
                    break;
                }
                case 65: 
                case 97: {
                    break;
                }
                case 81: {
                    double i;
                    this.path.curvetoQuadraticAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 113: {
                    double i;
                    this.path.curvetoQuadraticAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 84: {
                    double i;
                    this.path.curvetoQuadraticSmoothAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 116: {
                    double i;
                    this.path.curvetoQuadraticSmoothRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 67: {
                    double i;
                    this.path.curvetoCubicAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 99: {
                    double i;
                    this.path.curvetoCubicRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 83: {
                    double i;
                    this.path.curvetoCubicSmoothAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 115: {
                    double i;
                    this.path.curvetoCubicSmoothRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    for (i = this.resolution; i < 1.0; i += this.resolution) {
                        this.addingPoint(i);
                    }
                    continue block22;
                }
                case 90: 
                case 122: {
                    this.path.closePath();
                    break;
                }
                case 47: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid path element");
                }
            }
        }
    }

    private boolean addingPoint(double i) {
        Vector3d eval = this.path.bezierSegs.get(this.path.bezierSegs.size() - 1).eval(i);
        return this.setThePoint(eval);
    }

    private boolean setThePoint(Vector3d eval) {
        for (Vector3d v : this.plInternal) {
            if (!(Math.abs(v.minus(eval).magnitude()) < 1.0E-11)) continue;
            return false;
        }
        return this.plInternal.add(eval);
    }

    protected static float nextFloat(LinkedList<String> l) {
        String s = l.removeFirst();
        return Float.parseFloat(s);
    }

    public Vector3d eval(float interp) {
        Vector3d point = new Vector3d(0.0, 0.0);
        if ((double)interp < 0.001) {
            interp = 0.001f;
        }
        if ((double)interp > 0.9999) {
            interp = 0.9999f;
        }
        double curLength = this.path.curveLength * interp;
        for (Bezier bez : this.path.bezierSegs) {
            double bezLength = bez.getLength();
            if (curLength < bezLength) {
                double param = curLength / bezLength;
                point = bez.eval(param);
                break;
            }
            curLength -= bezLength;
        }
        return point;
    }

    public ArrayList<Vector3d> evaluate() {
        return this.plInternal;
    }
}

