/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import com.piro.bezier.BezierPath;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.IExtrusion;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Extrude {
    private static IExtrusion extrusionEngine = new IExtrusion(){

        public CSG points(Vector3d dir, List<Vector3d> points) {
            ArrayList<Vector3d> newList = new ArrayList<Vector3d>(points);
            return this.extrude(dir, Polygon.fromPoints(Extrude.toCCW(newList)));
        }

        @Override
        public CSG extrude(Vector3d dir, Polygon polygon1) {
            return this.monotoneExtrude(dir, polygon1);
        }

        private CSG monotoneExtrude(Vector3d dir, Polygon polygon1) {
            ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
            newPolygons.addAll(PolygonUtil.concaveToConvex(polygon1.flipped()));
            Polygon polygon2 = polygon1.translated(dir);
            int numvertices = polygon1.vertices.size();
            for (int i = 0; i < numvertices; ++i) {
                int nexti = (i + 1) % numvertices;
                Vector3d bottomV1 = polygon1.vertices.get((int)i).pos;
                Vector3d topV1 = polygon2.vertices.get((int)i).pos;
                Vector3d bottomV2 = polygon1.vertices.get((int)nexti).pos;
                Vector3d topV2 = polygon2.vertices.get((int)nexti).pos;
                double distance = bottomV1.minus(bottomV2).magnitude();
                if (Math.abs(distance) < 1.0E-11) continue;
                List<Vector3d> pPoints = Arrays.asList(bottomV2, topV2, topV1, bottomV1);
                try {
                    newPolygons.add(Polygon.fromPoints(pPoints, polygon1.getStorage()));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            polygon2 = polygon2.flipped();
            List<Polygon> topPolygons = PolygonUtil.concaveToConvex(polygon2.flipped());
            newPolygons.addAll(topPolygons);
            CSG extrude = CSG.fromPolygons(newPolygons);
            return extrude;
        }

        @Override
        public CSG extrude(Vector3d dir, List<Vector3d> points) {
            return this.points(dir, points);
        }
    };

    private Extrude() {
        throw new AssertionError("Don't instantiate me!", null);
    }

    public static CSG polygons(Polygon polygon1, Number zDistance) {
        return Extrude.polygons(polygon1, polygon1.transformed(new Transform().movez(zDistance)));
    }

    public static CSG polygons(Polygon polygon1, Polygon polygon2) {
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        newPolygons.addAll(PolygonUtil.concaveToConvex(polygon1.flipped()));
        if (polygon1.vertices.size() != polygon2.vertices.size()) {
            throw new RuntimeException("These polygons do not match");
        }
        int numvertices = polygon1.vertices.size();
        for (int i = 0; i < numvertices; ++i) {
            int nexti = (i + 1) % numvertices;
            Vector3d bottomV1 = polygon1.vertices.get((int)i).pos;
            Vector3d topV1 = polygon2.vertices.get((int)i).pos;
            Vector3d bottomV2 = polygon1.vertices.get((int)nexti).pos;
            Vector3d topV2 = polygon2.vertices.get((int)nexti).pos;
            List<Vector3d> pPoints = Arrays.asList(bottomV2, topV2, topV1, bottomV1);
            newPolygons.add(Polygon.fromPoints(pPoints, polygon1.getStorage()));
        }
        polygon2 = polygon2.flipped();
        List<Polygon> topPolygons = PolygonUtil.concaveToConvex(polygon2.flipped());
        newPolygons.addAll(topPolygons);
        CSG extrude = CSG.fromPolygons(newPolygons);
        return extrude;
    }

    public static ArrayList<CSG> polygons(Polygon polygon1, ArrayList<Transform> transforms) {
        if (transforms.size() == 1) {
            transforms.add(0, new Transform());
        }
        polygon1 = Polygon.fromPoints(Extrude.toCCW(polygon1.getPoints()));
        if (transforms.size() < 2) {
            transforms.add(0, new Transform());
        }
        ArrayList<CSG> parts = new ArrayList<CSG>();
        Transform transform = new Transform();
        for (int i = 0; i < transforms.size() - 1; ++i) {
            CSG tmp = Extrude.polygons(polygon1.transformed(transform).transformed(transforms.get(i)), polygon1.transformed(transform).transformed(transforms.get(i + 1)));
            parts.add(tmp);
        }
        return parts;
    }

    public static ArrayList<CSG> polygons(Polygon polygon1, Transform ... transformparts) {
        return Extrude.polygons(polygon1, (ArrayList)Arrays.asList(transformparts));
    }

    public static CSG points(Vector3d dir, List<Vector3d> points) {
        return Extrude.getExtrusionEngine().extrude(dir, points);
    }

    public static CSG points(Vector3d dir, Vector3d ... points) {
        return Extrude.points(dir, Arrays.asList(points));
    }

    public static List<Vector3d> toCCW(List<Vector3d> points) {
        ArrayList<Vector3d> result = new ArrayList<Vector3d>(points);
        if (!Extrude.isCCW(Polygon.fromPoints(result))) {
            Collections.reverse(result);
        }
        return result;
    }

    static List<Vector3d> toCW(List<Vector3d> points) {
        ArrayList<Vector3d> result = new ArrayList<Vector3d>(points);
        if (Extrude.isCCW(Polygon.fromPoints(result))) {
            Collections.reverse(result);
        }
        return result;
    }

    public static boolean isCCW(Polygon polygon) {
        if (polygon.vertices.size() < 3) {
            throw new IllegalArgumentException("Only polygons with at least 3 vertices are supported!");
        }
        int highestLeftVertexIndex = 0;
        Vertex highestLeftVertex = polygon.vertices.get(0);
        for (int i = 0; i < polygon.vertices.size(); ++i) {
            Vertex v = polygon.vertices.get(i);
            if (v.pos.y > highestLeftVertex.pos.y) {
                highestLeftVertex = v;
                highestLeftVertexIndex = i;
                continue;
            }
            if (v.pos.y != highestLeftVertex.pos.y || !(v.pos.x < highestLeftVertex.pos.x)) continue;
            highestLeftVertex = v;
            highestLeftVertexIndex = i;
        }
        int nextVertexIndex = (highestLeftVertexIndex + 1) % polygon.vertices.size();
        int prevVertexIndex = highestLeftVertexIndex - 1;
        if (prevVertexIndex < 0) {
            prevVertexIndex = polygon.vertices.size() - 1;
        }
        Vertex nextVertex = polygon.vertices.get(nextVertexIndex);
        Vertex prevVertex = polygon.vertices.get(prevVertexIndex);
        double a1 = Extrude.normalizedX(highestLeftVertex.pos, nextVertex.pos);
        double a2 = Extrude.normalizedX(highestLeftVertex.pos, prevVertex.pos);
        int selectedVIndex = a2 > a1 ? nextVertexIndex : prevVertexIndex;
        if (selectedVIndex == 0 && highestLeftVertexIndex == polygon.vertices.size() - 1) {
            selectedVIndex = polygon.vertices.size();
        }
        if (highestLeftVertexIndex == 0 && selectedVIndex == polygon.vertices.size() - 1) {
            highestLeftVertexIndex = polygon.vertices.size();
        }
        return selectedVIndex > highestLeftVertexIndex;
    }

    private static double normalizedX(Vector3d v1, Vector3d v2) {
        Vector3d v2MinusV1 = v2.minus(v1);
        return v2MinusV1.dividedBy((double)v2MinusV1.magnitude()).times((Vector3d)Vector3d.X_ONE).x;
    }

    public static IExtrusion getExtrusionEngine() {
        return extrusionEngine;
    }

    public static void setExtrusionEngine(IExtrusion extrusionEngine) {
        Extrude.extrusionEngine = extrusionEngine;
    }

    public static CSG byPath(List<List<Vector3d>> points, double height) {
        return Extrude.byPath(points, height, 200);
    }

    public static CSG byPath(List<List<Vector3d>> points, double height, int resolution) {
        ArrayList<Transform> trPath = Extrude.pathToTransforms(points, resolution);
        ArrayList<Vector3d> finalPath = new ArrayList<Vector3d>();
        for (Transform tr : trPath) {
            javax.vecmath.Vector3d t1 = new javax.vecmath.Vector3d();
            tr.getInternalMatrix().get(t1);
            Vector3d finalPoint = new Vector3d(t1.x, t1.y, 0.0);
            finalPath.add(finalPoint);
        }
        return Extrude.points(new Vector3d(0.0, 0.0, height), finalPath);
    }

    public static ArrayList<Transform> pathToTransforms(List<List<Vector3d>> points, int resolution) {
        String pathStringA;
        Vector3d start = points.get(0).get(0);
        String pathStringB = pathStringA = "M " + start.x + "," + start.y;
        for (List<Vector3d> sections : points) {
            if (sections.size() == 4) {
                Vector3d controlA = sections.get(1);
                Vector3d controlB = sections.get(2);
                Vector3d endPoint = sections.get(3);
                pathStringA = pathStringA + "C " + controlA.x + "," + controlA.y + " " + controlB.x + "," + controlB.y + " " + endPoint.x + "," + endPoint.y + "\n";
                pathStringB = pathStringB + "C " + controlA.x + "," + controlA.z + " " + controlB.x + "," + controlB.z + " " + endPoint.x + "," + endPoint.z + "\n";
                continue;
            }
            if (sections.size() != 1) continue;
            pathStringA = pathStringA + "L " + sections.get((int)0).x + "," + sections.get((int)0).y + "\n";
            pathStringB = pathStringB + "L " + sections.get((int)0).x + "," + sections.get((int)0).z + "\n";
        }
        BezierPath path = new BezierPath();
        path.parsePathString(pathStringA);
        BezierPath path2 = new BezierPath();
        path2.parsePathString(pathStringB);
        return Extrude.bezierToTransforms(path, path2, resolution, null, null);
    }

    public static ArrayList<CSG> moveAlongProfile(CSG object, List<List<Vector3d>> points, int resolution) {
        return Extrude.move(object, Extrude.pathToTransforms(points, resolution));
    }

    public static ArrayList<Transform> bezierToTransforms(Vector3d controlA, Vector3d controlB, Vector3d endPoint, int iterations) {
        BezierPath path = new BezierPath();
        path.parsePathString("C " + controlA.x + "," + controlA.y + " " + controlB.x + "," + controlB.y + " " + endPoint.x + "," + endPoint.y);
        BezierPath path2 = new BezierPath();
        path2.parsePathString("C " + controlA.x + "," + controlA.z + " " + controlB.x + "," + controlB.z + " " + endPoint.x + "," + endPoint.z);
        return Extrude.bezierToTransforms(path, path2, iterations, controlA, controlB);
    }

    public static ArrayList<Transform> bezierToTransforms(List<Vector3d> parts, int iterations) {
        if (parts.size() == 3) {
            return Extrude.bezierToTransforms(parts.get(0), parts.get(1), parts.get(2), iterations);
        }
        if (parts.size() == 2) {
            return Extrude.bezierToTransforms(parts.get(0), parts.get(0), parts.get(1), parts.get(1), iterations);
        }
        if (parts.size() == 1) {
            return Extrude.bezierToTransforms(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 0.0), parts.get(0), parts.get(0), iterations);
        }
        return Extrude.bezierToTransforms(parts.get(0), parts.get(1), parts.get(2), parts.get(3), iterations);
    }

    private Transform toTransform() {
        return null;
    }

    public static ArrayList<Transform> bezierToTransforms(BezierPath pathA, BezierPath pathB, int iterations, Vector3d controlA, Vector3d controlB) {
        double roty;
        double rotz;
        double run;
        double rise;
        double xdiff;
        double zdiff;
        double ydiff;
        double d = 1.0 / (double)iterations;
        ArrayList<Transform> p = new ArrayList<Transform>();
        Vector3d pointAStart = pathA.eval(0.0f);
        Vector3d pointBStart = pathB.eval(0.0f);
        double x = pointAStart.x;
        double y = pointAStart.y;
        double z = pointBStart.y;
        double lastx = x;
        double lasty = y;
        double lastz = z;
        int startIndex = 0;
        if (controlA != null) {
            startIndex = 1;
            double ydiff2 = controlA.y - y;
            double zdiff2 = controlA.z - z;
            double xdiff2 = controlA.x - x;
            double rise2 = zdiff2;
            double run2 = Math.sqrt(ydiff2 * ydiff2 + xdiff2 * xdiff2);
            double rotz2 = 90.0 - Math.toDegrees(Math.atan2(xdiff2, ydiff2));
            double roty2 = Math.toDegrees(Math.atan2(rise2, run2));
            Transform t = new Transform();
            t.translateX(x);
            t.translateY(y);
            t.translateZ(z);
            t.rotZ(-rotz2);
            t.rotY(roty2);
            p.add(t);
        }
        for (int i = startIndex; i < iterations - 1; ++i) {
            float pathFunction = (float)i / (float)(iterations - 1);
            Vector3d pointA = pathA.eval(pathFunction);
            Vector3d pointB = pathB.eval(pathFunction);
            x = pointA.x;
            y = pointA.y;
            z = pointB.y;
            Transform t = new Transform();
            t.translateX(x);
            t.translateY(y);
            t.translateZ(z);
            Vector3d pointAEst = pathA.eval((float)((double)pathFunction + d));
            Vector3d pointBEst = pathB.eval((float)((double)pathFunction + d));
            double xest = pointAEst.x;
            double yest = pointAEst.y;
            double zest = pointBEst.y;
            ydiff = yest - y;
            zdiff = zest - z;
            xdiff = xest - x;
            rise = zdiff;
            run = Math.sqrt(ydiff * ydiff + xdiff * xdiff);
            rotz = 90.0 - Math.toDegrees(Math.atan2(xdiff, ydiff));
            roty = Math.toDegrees(Math.atan2(rise, run));
            t.rotZ(-rotz);
            t.rotY(roty);
            p.add(t);
            lastx = x;
            lasty = y;
            lastz = z;
        }
        Vector3d pointA = pathA.eval(1.0f);
        Vector3d pointB = pathB.eval(1.0f);
        x = pointA.x;
        y = pointA.y;
        z = pointB.y;
        Transform t = new Transform();
        t.translateX(x);
        t.translateY(y);
        t.translateZ(z);
        if (controlB != null) {
            lastx = controlB.x;
            lasty = controlB.y;
            lastz = controlB.z;
        }
        ydiff = y - lasty;
        zdiff = z - lastz;
        xdiff = x - lastx;
        rise = zdiff;
        run = Math.sqrt(ydiff * ydiff + xdiff * xdiff);
        rotz = 90.0 - Math.toDegrees(Math.atan2(xdiff, ydiff));
        roty = Math.toDegrees(Math.atan2(rise, run));
        t.rotZ(-rotz);
        t.rotY(roty);
        p.add(t);
        return p;
    }

    public static ArrayList<Transform> bezierToTransforms(Vector3d start, Vector3d controlA, Vector3d controlB, Vector3d endPoint, int iterations) {
        String startString = "M " + start.x + "," + start.y + "\nC " + controlA.x + "," + controlA.y + " " + controlB.x + "," + controlB.y + " " + endPoint.x + "," + endPoint.y;
        String b = "M " + start.x + "," + start.z + "\nC " + controlA.x + "," + controlA.z + " " + controlB.x + "," + controlB.z + " " + endPoint.x + "," + endPoint.z;
        BezierPath path = new BezierPath();
        path.parsePathString(startString);
        BezierPath path2 = new BezierPath();
        path2.parsePathString(b);
        return Extrude.bezierToTransforms(path, path2, iterations, controlA, controlB);
    }

    public static ArrayList<CSG> revolve(CSG slice, double radius, int numSlices) {
        return Extrude.revolve(slice, radius, 360.0, null, numSlices);
    }

    public static ArrayList<CSG> revolve(Polygon poly, int numSlices) {
        return Extrude.revolve(poly, 0.0, numSlices);
    }

    public static ArrayList<CSG> revolve(Polygon poly, double radius, int numSlices) {
        int i;
        ArrayList<CSG> parts = new ArrayList<CSG>();
        ArrayList<Polygon> slices = new ArrayList<Polygon>();
        for (i = 0; i < numSlices; ++i) {
            double angle = 360.0 / (double)numSlices * (double)i;
            slices.add(poly.transformed(new Transform().movex(radius).roty(angle)));
        }
        for (i = 0; i < slices.size(); ++i) {
            int next = i + 1;
            if (next == slices.size()) {
                next = 0;
            }
            parts.add(Extrude.polygons((Polygon)slices.get(i), (Polygon)slices.get(next)));
        }
        return parts;
    }

    public static ArrayList<CSG> revolve(CSG slice, double radius, double archLen, int numSlices) {
        return Extrude.revolve(slice, radius, archLen, null, numSlices);
    }

    public static ArrayList<CSG> revolve(CSG slice, double radius, double archLen, List<List<Vector3d>> points, int numSlices) {
        ArrayList<CSG> parts = new ArrayList<CSG>();
        double slices = numSlices;
        double increment = archLen / slices;
        CSG slicePRofile = slice.movey(radius);
        for (double i = 0.0; i < archLen + increment; i += increment) {
            parts.add(slicePRofile.rotz(i));
        }
        if (points != null) {
            ArrayList<Transform> pathtransforms = Extrude.pathToTransforms(points, numSlices);
            for (int i = 0; i < parts.size(); ++i) {
                CSG sweep = parts.get(i).transformed(pathtransforms.get(i));
                parts.set(i, sweep);
            }
        }
        for (int i = 0; i < parts.size() - 1; ++i) {
            CSG sweep = CSG.hullAll(parts.get(i), parts.get(i + 1));
            parts.set(i, sweep);
        }
        return parts;
    }

    public static ArrayList<CSG> bezier(CSG slice, ArrayList<Double> controlA, ArrayList<Double> controlB, ArrayList<Double> endPoint, int numSlices) {
        ArrayList<CSG> parts = new ArrayList<CSG>();
        for (int i = 0; i < numSlices; ++i) {
            parts.add(0, slice.clone());
        }
        return Extrude.bezier(parts, controlA, controlB, endPoint);
    }

    public static ArrayList<CSG> bezier(ArrayList<CSG> s, ArrayList<Double> controlA, ArrayList<Double> controlB, ArrayList<Double> endPoint) {
        ArrayList<CSG> slice = Extrude.moveBezier(s, controlA, controlB, endPoint);
        for (int i = 0; i < slice.size() - 1; ++i) {
            CSG sweep = HullUtil.hull(slice.get(i), slice.get(i + 1));
            slice.set(i, sweep);
        }
        return slice;
    }

    public static ArrayList<CSG> hull(ArrayList<CSG> s, ArrayList<Transform> p) {
        ArrayList<CSG> slice = Extrude.move(s, p);
        for (int i = 0; i < slice.size() - 1; ++i) {
            CSG sweep = HullUtil.hull(slice.get(i), slice.get(i + 1));
            slice.set(i, sweep);
        }
        return slice;
    }

    public static ArrayList<CSG> hull(CSG c, ArrayList<Transform> p) {
        ArrayList<CSG> s = new ArrayList<CSG>();
        for (int i = 0; i < p.size(); ++i) {
            s.add(c.clone());
        }
        return Extrude.hull(s, p);
    }

    public static ArrayList<CSG> linear(ArrayList<CSG> s, ArrayList<Double> endPoint) {
        ArrayList start = (ArrayList)Arrays.asList(0.0, 0.0, 0.0);
        return Extrude.bezier(s, start, endPoint, endPoint);
    }

    public static ArrayList<CSG> linear(CSG s, ArrayList<Double> endPoint, int numSlices) {
        ArrayList start = (ArrayList)Arrays.asList(0.0, 0.0, 0.0);
        return Extrude.bezier(s, start, endPoint, endPoint, numSlices);
    }

    public static ArrayList<CSG> move(ArrayList<CSG> slice, ArrayList<Transform> p) {
        return CSG.move(slice, p);
    }

    public static ArrayList<CSG> move(CSG slice, ArrayList<Transform> p) {
        return slice.move(p);
    }

    public static ArrayList<CSG> moveBezier(CSG slice, ArrayList<Double> controlA, ArrayList<Double> controlB, ArrayList<Double> endPoint, int numSlices) {
        ArrayList<Transform> p = Extrude.bezierToTransforms(Extrude.fromDouble(controlA), Extrude.fromDouble(controlB), Extrude.fromDouble(endPoint), numSlices);
        return Extrude.move(slice, p);
    }

    public static ArrayList<CSG> moveBezier(ArrayList<CSG> slice, ArrayList<Double> controlA, ArrayList<Double> controlB, ArrayList<Double> endPoint) {
        int numSlices = slice.size();
        ArrayList<Transform> p = Extrude.bezierToTransforms(Extrude.fromDouble(controlA), Extrude.fromDouble(controlB), Extrude.fromDouble(endPoint), numSlices);
        return Extrude.move(slice, p);
    }

    private static Vector3d fromDouble(ArrayList<Double> controlA) {
        return new Vector3d(controlA.get(0), controlA.get(1), controlA.get(2));
    }

    public static ArrayList<CSG> moveBezier(CSG slice, BezierPath pathA, int numSlices) {
        Vector3d pointA = pathA.eval(1.0f);
        String zpath = "C 0,0 " + pointA.x + "," + pointA.y + " " + pointA.x + "," + pointA.y;
        BezierPath pathB = new BezierPath();
        pathB.parsePathString(zpath);
        return Extrude.moveBezier(slice, pathA, pathB, numSlices);
    }

    public static ArrayList<CSG> moveBezier(CSG slice, BezierPath pathA, BezierPath pathB, int iterations) {
        ArrayList<Transform> p = Extrude.bezierToTransforms(pathA, pathB, iterations, null, null);
        return Extrude.move(slice, p);
    }

    public static Polygon toCCW(Polygon concave) {
        if (!Extrude.isCCW(concave)) {
            List<Vector3d> points = concave.getPoints();
            ArrayList<Vector3d> result = new ArrayList<Vector3d>(points);
            Collections.reverse(result);
            return Polygon.fromPoints(result);
        }
        return concave;
    }
}

